Unit ImportFromXLS;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls,
  JvExExtCtrls, JvExtComponent, ActnList, JvSpin, JvExControls,
  JvDBLookupTreeView, Grids, DBGrids, JvExDBGrids, JvDBGrid, JvExMask,
  JvToolEdit, JvBaseEdits, JvDBControls, Mask, DBCtrls, ComCtrls, JvExComCtrls,
  JvComCtrls, JvDBTreeView, DB,  ExcelXP, OleServer,
  JvDataSource, JvMemoryDataset, Menus, Excel2000,
  System.Actions, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client;

Type
  TfrmImportFromXLS = Class(TForm)
    Footer: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    JvFooterBtn2: TJvFooterBtn;
    TTemplate: TFDQuery;
    DSTemplate: TDataSource;
    Actions: TActionList;
    actImport: TAction;
    MemoryTable: TJvMemoryData;
    DSMemoryTable: TJvDataSource;
    JvFooterBtn3: TJvFooterBtn;
    PanelHeader: TPanel;
    ExcelFilenameEdit: TJvFilenameEdit;
    Label5: TLabel;
    Panel2: TPanel;
    Pages: TJvPageControl;
    TabCategory: TTabSheet;
    OnlyCategory: TRadioButton;
    CatalogTree: TJvDBTreeView;
    TabSheet3: TTabSheet;
    TemplateGrid: TJvDBGrid;
    TabSheetPreview: TTabSheet;
    Label11: TLabel;
    Label1: TLabel;
    _article: TEdit;
    Label2: TLabel;
    lblPrice: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    _comment: TEdit;
    _developer: TEdit;
    _price: TEdit;
    _name: TEdit;
    lbl_name: TLabel;
    lbl_article: TLabel;
    lbl_price: TLabel;
    lbl_developer: TLabel;
    lbl_comment: TLabel;
    actSaveToDB: TAction;
    actRemove: TAction;
    PopupMenu1: TPopupMenu;
    N1: TMenuItem;
    PanelInfo: TPanel;
    DBGridPreview: TJvDBGrid;
    CategoryNotUsed: TRadioButton;
    Label8: TLabel;
    THardware: TFDQuery;
    MyQuery1: TFDQuery;
    _last: TEdit;
    Label6: TLabel;
    _first: TEdit;
    Label7: TLabel;
    Label9: TLabel;
    _PageNo: TEdit;
    Procedure FormShow(Sender: TObject);
    Procedure OnlyCategoryClick(Sender: TObject);
    Procedure _articleChange(Sender: TObject);
    Procedure CatalogTreeChange(Sender: TObject; Node: TTreeNode);
    Procedure actImportExecute(Sender: TObject);
    Procedure actImportUpdate(Sender: TObject);
    Procedure actSaveToDBUpdate(Sender: TObject);
    Procedure actSaveToDBExecute(Sender: TObject);
    Procedure actRemoveUpdate(Sender: TObject);
    Procedure actRemoveExecute(Sender: TObject);
    Procedure JvFooterBtn1Click(Sender: TObject);
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    Procedure JvFooterBtn4Click(Sender: TObject);
    Procedure FormCreate(Sender: TObject);
    Procedure FormDestroy(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
    procedure MemoryTableAfterOpen(DataSet: TDataSet);
  Private
    InProgress: Boolean;
    AbortProgress: Boolean;
    Procedure UpdateData;
    Function DetectPosition(str: String): integer;
    Function LetterNumber(Ch: Char): integer;
    Function ConvertToInteger(str: String): integer;
    Function MyStrToReal(input: String): real;
    Procedure DoUpdateWithoutCategory;
    Procedure DoUpdateWithCategory;
    Procedure ExcelClose;
    { Private declarations }
  Public
    { ExcelApplication1: TExcelApplication;
      ExcelWorkbook1: TExcelWorkbook;
      ExcelWorksheet1: TExcelWorksheet; }
//    LCID: integer;
  //  xf: TXLSFile;
    { Public declarations }
  End;

Var
  frmImportFromXLS: TfrmImportFromXLS;

Implementation

Uses Main,  Universal;

{$R *.dfm}

Procedure TfrmImportFromXLS.FormActivate(Sender: TObject);
Begin
  Pages.ActivePage := TabCategory;
End;

Procedure TfrmImportFromXLS.FormClose(Sender: TObject;
  Var Action: TCloseAction);
Begin
  frmMain.SaveSettings;
  AbortProgress := true;
End;

Procedure TfrmImportFromXLS.FormCreate(Sender: TObject);
Begin
  LCID := GetUserDefaultLCID;
  { ExcelApplication1 := TExcelApplication.Create(Nil);
    ExcelWorkbook1 := TExcelWorkbook.Create(Nil);
    ExcelWorksheet1 := TExcelWorksheet.Create(Nil); }
  xf := TXLSFile.Create;
End;

Procedure TfrmImportFromXLS.FormDestroy(Sender: TObject);
Begin
  { FreeAndNil(ExcelWorksheet1);
    FreeAndNil(ExcelWorkbook1);
    FreeAndNil(ExcelApplication1); }
  xf.Destroy;
End;

Procedure TfrmImportFromXLS.FormShow(Sender: TObject);
Begin

  if not frmUniversal.DBConnected then
    close;

  Pages.ActivePage := TabCategory;
  OnlyCategoryClick(self);
  TTemplate.Active := true;
  InProgress := false;
  //
  if ExcelFilenameEdit.FileName <> '' then
    if not FileExists(ExcelFilenameEdit.FileName) then
      ExcelFilenameEdit.FileName := '';
End;

Procedure TfrmImportFromXLS.JvFooterBtn1Click(Sender: TObject);
Begin
  AbortProgress := true;
End;

Procedure TfrmImportFromXLS.JvFooterBtn4Click(Sender: TObject);
Begin
  MyQuery1.Execute;
  ShowMessage(IntToStr(MyQuery1.RowsAffected));
End;

Procedure TfrmImportFromXLS.OnlyCategoryClick(Sender: TObject);
Begin
  If OnlyCategory.Checked Then
  Begin
    CatalogTree.Enabled := true;
    CatalogTree.Color := clInfoBk;
  End
  Else
  Begin
    CatalogTree.Enabled := false;
    CatalogTree.Color := clBtnFace;
  End;
  UpdateData;
End;

Procedure TfrmImportFromXLS.UpdateData;
Begin
  Case DetectPosition(_article.Text) Of
    1:
      lbl_article.Caption := '  ';
    2:
      lbl_article.Caption := ' ';
    3:
      lbl_article.Caption := '    ';
  End;

  Case DetectPosition(_name.Text) Of
    1:
      lbl_name.Caption := '  ';
    2:
      lbl_name.Caption := ' ';
    3:
      lbl_name.Caption := '    ';
  End;

  Case DetectPosition(_price.Text) Of
    1:
      lbl_price.Caption := '  ';
    2:
      lbl_price.Caption := ' ';
    3:
      lbl_price.Caption := '    ';
  End;

  Case DetectPosition(_developer.Text) Of
    1:
      lbl_developer.Caption := '  ';
    2:
      lbl_developer.Caption := ' ';
    3:
      lbl_developer.Caption := '    ';
  End;

  Case DetectPosition(_comment.Text) Of
    1:
      lbl_comment.Caption := '  ';
    2:
      lbl_comment.Caption := ' ';
    3:
      lbl_comment.Caption := '    ';
  End;
  //

End;

Procedure TfrmImportFromXLS.actImportUpdate(Sender: TObject);
Begin
  actImport.Enabled := ((Length(ExcelFilenameEdit.Text) > 0) And Not InProgress)
End;

Procedure TfrmImportFromXLS.actRemoveExecute(Sender: TObject);
Begin
  MemoryTable.Delete;
End;

Procedure TfrmImportFromXLS.actRemoveUpdate(Sender: TObject);
Begin
  actRemove.Enabled := (MemoryTable.Active And (MemoryTable.RecordCount > 0) And
    (MemoryTable.RecNo > 0));
End;

Procedure TfrmImportFromXLS.actSaveToDBUpdate(Sender: TObject);
Begin
  actSaveToDB.Enabled := (MemoryTable.Active And (MemoryTable.RecordCount > 0));
End;

Procedure TfrmImportFromXLS.CatalogTreeChange(Sender: TObject; Node: TTreeNode);
Begin
  UpdateData;
End;

Function TfrmImportFromXLS.DetectPosition(str: String): integer;
Var
  i: integer;
  newpos: integer;
Begin
  If (str = '') Then
  Begin
    result := 1;
  End
  Else If trystrtoint(str, newpos) Then
  Begin
    result := 2;
  End
  Else If Length(str) > 1 Then
    result := 3
  Else
  Begin
    newpos := LetterNumber(str[1]);
    If newpos > 0 Then
      result := 2
    Else
      result := 3;
  End;
End;

Function TfrmImportFromXLS.ConvertToInteger(str: String): integer;
Var
  i: integer;
  newpos: integer;
Begin
  If (str = '') Then
  Begin
    result := -1;
  End
  Else If trystrtoint(str, newpos) Then
  Begin
    result := newpos - 1;
  End
  Else If Length(str) > 1 Then
    result := -1
  Else
  Begin
    newpos := LetterNumber(str[1]);
    If newpos > -1 Then
      result := newpos - 1
    Else
      result := -1;
  End;
End;

Procedure TfrmImportFromXLS._articleChange(Sender: TObject);
Begin
  UpdateData;
End;

Function TfrmImportFromXLS.LetterNumber(Ch: Char): integer;
  Function GetLN(C, F: Char): integer;
  Begin
    result := Ord(C) - Ord(F) + 1;
  End;

Begin
  Case Ch Of
    'A' .. 'Z':
      result := GetLN(Ch, 'A');
    'a' .. 'z':
      result := GetLN(Ch, 'a');
  Else
    result := 0; // ,  
  End;
End;
{
  Procedure TfrmImportFromXLS.actImportExecute(Sender: TObject);
  Var
  icid, i: integer;
  olev: OleVariant;
  cnt: integer;
  first, last: integer;
  pos_articul: integer;
  page_no: integer;
  category: String;
  category_id: integer;
  pos_category, pos_name, pos_price, pos_developer, pos_comment: integer;
  Begin
  //   
  AbortProgress := false;
  _article.Text := trim(_article.Text);
  _name.Text := trim(_name.Text);
  _price.Text := trim(_price.Text);
  _developer.Text := trim(_developer.Text);
  _comment.Text := trim(_comment.Text);
  If (_article.Text = '') Then
  Begin
  ShowMessage('.    ');
  End
  Else If FileExists(ExcelFilenameEdit.Text) Then
  Try
  InProgress := true;
  Pages.ActivePage := TabSheetPreview;
  PanelInfo.Caption := ' ...';
  actImport.Update;
  DBGridPreview.DataSource := Nil;
  DBGridPreview.Visible := false;
  Application.ProcessMessages;
  page_no := StrToInt(_PageNo.Text);

  ExcelApplication1.ConnectKind := ckNewInstance;
  ExcelApplication1.Connect; // 
  ExcelApplication1.AutoQuit := false;
  ExcelApplication1.Visible[LCID] := false;

  // ExcelApplication1.Visible[icid] := false;
  ExcelApplication1.Workbooks.Open(ExcelFilenameEdit.Text, EmptyParam,
  EmptyParam, EmptyParam, EmptyParam, EmptyParam, EmptyParam, EmptyParam,
  EmptyParam, EmptyParam, EmptyParam, EmptyParam, EmptyParam, icid);
  ExcelWorkbook1.ConnectTo(ExcelApplication1.ActiveWorkbook);
  ExcelWorksheet1.ConnectTo(ExcelWorkbook1.Sheets[page_no] As _WorkSheet);
  cnt := ExcelWorksheet1.UsedRange[0].Rows.Count;
  // fill data to temp table
  MemoryTable.Active := true;
  MemoryTable.EmptyTable;
  pos_articul := ConvertToInteger(_article.Text);
  pos_name := ConvertToInteger(_name.Text);
  pos_price := ConvertToInteger(_price.Text);
  pos_developer := ConvertToInteger(_developer.Text);
  pos_comment := ConvertToInteger(_comment.Text);
  If OnlyCategory.Checked Then
  Begin
  category := TTemplate.FieldByName('name').AsString;
  category_id := TTemplate.FieldByName('rec_no').AsInteger;
  End
  Else
  Begin
  pos_category := -1;
  End;

  if not trystrtoint(_last.Text, last) then
  last := cnt
  else if last > cnt then
  last := cnt;
  if not trystrtoint(_first.Text, first) then
  first := 1
  else if first > cnt then
  first := 1;

  For i := first To last Do
  Begin
  If ((i Div 1000) = (i / 1000)) Then
  Application.ProcessMessages;
  If AbortProgress Then
  break;

  //  
  MemoryTable.Append;
  If ((i Div 100) = (i / 100)) Then
  PanelInfo.Caption := '  Excel [' + IntToStr(i) + '   '
  + IntToStr(cnt) + ' ]';

  If pos_articul > 0 Then
  MemoryTable.FieldByName('article').AsString :=
  trim(ExcelWorksheet1.Cells.Item[i, pos_articul].Value)
  Else If (_article.Text <> '') Then
  MemoryTable.FieldByName('article').AsString := _article.Text;

  If pos_name > 0 Then
  MemoryTable.FieldByName('name').AsString :=
  trim(ExcelWorksheet1.Cells.Item[i, pos_name].Value)
  Else If (_name.Text <> '') Then
  MemoryTable.FieldByName('name').AsString := _name.Text;

  If pos_price > 0 Then
  MemoryTable.FieldByName('price').AsFloat :=
  MyStrToReal(trim(ExcelWorksheet1.Cells.Item[i, pos_price].Value));

  If pos_developer > 0 Then
  MemoryTable.FieldByName('developer').AsString :=
  trim(ExcelWorksheet1.Cells.Item[i, pos_developer].Value)
  Else If (_developer.Text <> '') Then
  MemoryTable.FieldByName('developer').AsString := _developer.Text;

  If pos_comment > 0 Then
  MemoryTable.FieldByName('comment').AsString :=
  trim(ExcelWorksheet1.Cells.Item[i, pos_comment].Value)
  Else If (_comment.Text <> '') Then
  MemoryTable.FieldByName('comment').AsString := _comment.Text;

  MemoryTable.Post;
  If MemoryTable.FieldByName('article').AsString = '' Then
  MemoryTable.Delete;

  End;
  ExcelClose;
  Except
  ShowMessage('    ');
  End
  Else
  Begin
  ShowMessage
  ('   .        ');
  End;
  PanelInfo.Caption := '  Excel';
  DBGridPreview.DataSource := DSMemoryTable;
  DBGridPreview.Visible := true;
  InProgress := false;
  End;
}

Procedure TfrmImportFromXLS.ExcelClose;
Begin
  { Try
    ExcelWorkbook1.Close(true, '', false, LCID);
    ExcelWorkbook1.Disconnect;
    ExcelApplication1.Disconnect;
    Except
    // ShowMessage(' ExcelClose');
    End;
  }
End;

procedure TfrmImportFromXLS.MemoryTableAfterOpen(DataSet: TDataSet);
begin
  (MemoryTable.FieldByName('price') As TFloatField).DisplayFormat := ',0.00';
end;

Function TfrmImportFromXLS.MyStrToReal(input: String): real;
Var
  i, t: integer;
  o, n: String;
  tr: extended;
Begin
  For i := 1 To Length(input) Do
  Begin
    n := input[i];
    If (n = '.') Or (n = ',') Then
      o := o + ',';
    If trystrtoint(n, t) Then
      o := o + n;
  End;
  If TryStrToFloat(o, tr) Then
  Begin
    result := Round(tr * 100) / 100;
  End
  Else
    result := 0;
End;

Procedure TfrmImportFromXLS.actSaveToDBExecute(Sender: TObject);
Begin
  If CategoryNotUsed.Checked Then
    DoUpdateWithoutCategory
  Else
    DoUpdateWithCategory;
End;

Procedure TfrmImportFromXLS.DoUpdateWithoutCategory;
Var
  cnt_old: integer;
  SQL: String;
Begin
  //    
  MemoryTable.first;
  cnt_old := 0;
  formatSETTINGS.DecimalSeparator := '.';
  MemoryTable.first;
  If MemoryTable.RecordCount > 100 Then
    DBGridPreview.Visible := false;
  PanelInfo.Caption := '  ...';
  Application.ProcessMessages;
  THardware.SQL.Clear;
  While Not MemoryTable.Eof Do
    Try
      If ((MemoryTable.RecNo Div 500) = (MemoryTable.RecNo / 500)) Then
      Begin
        PanelInfo.Caption := '  [' + IntToStr(MemoryTable.RecNo) +
          '  ' + IntToStr(MemoryTable.RecordCount) + ']';
        Application.ProcessMessages;
        THardware.SQL.Add('COMMIT;');
        THardware.Execute;
        cnt_old := cnt_old + THardware.RowsAffected;
        THardware.SQL.Clear;
      End;

      SQL := 'UPDATE `uni_hardware` SET ';
      If (_name.Text <> '') Then
        SQL := SQL + '`name`=' + QuotedStr(MemoryTable.FieldByName('name')
          .AsString) + ',';
      If (_price.Text <> '') Then
        SQL := SQL + '`price`=' + FloatToStr(MemoryTable.FieldByName('price')
          .AsFloat) + ',';
      If (_developer.Text <> '') Then
        SQL := SQL + '`developer`=' +
          QuotedStr(MemoryTable.FieldByName('developer').AsString) + ',';
      If (_comment.Text <> '') Then
        SQL := SQL + '`comment`=' + QuotedStr(MemoryTable.FieldByName('comment')
          .AsString) + ',';
      SQL := SQL + '`lastupdate`=now()';
      SQL := SQL + ' WHERE `article`=' +
        QuotedStr(MemoryTable.FieldByName('article').AsString) + ';';
      THardware.SQL.Add(SQL);
      MemoryTable.Next;
    Except
    End;
  Try
    THardware.SQL.Add('COMMIT;');
    PanelInfo.Caption := ' ...';
    // THardware.SQL.SaveToFile('c:\temp.sql');
    Application.ProcessMessages;
    THardware.Execute;
    cnt_old := cnt_old + THardware.RowsAffected;
  Except
  End;

  DBGridPreview.Visible := true;
  PanelInfo.Caption := '  Excel';
  If (cnt_old > 0) Then
    ShowMessage('   ')
  Else
    ShowMessage('       ')
End;

Procedure TfrmImportFromXLS.DoUpdateWithCategory;
Var
  v_article, v_name, v_developer, v_comment: String;
  v_price: real;
  i_category: integer;
  cnt_new, cnt_old: integer;
  hf: String;
Begin
  //    
  MemoryTable.first;
  cnt_new := 0;
  cnt_old := 0;
  { hf := ' `rec_no`, `kind`, `article`, `lastupdate`';
    if (_name.Text <> '') then
    hf := hf + ', `name`';
    if (_comment.Text <> '') then
    hf := hf + ', `comment`';
    if (_price.Text <> '') then
    hf := hf + ', `price`';
    if (_developer.Text <> '') then
    hf := hf + ', `developer`';

    THardware.SQL.Text := 'SELECT ' + hf + ' FROM `uni_hardware`;';

    if OnlyCategory.Checked then
    begin
    i_category := TTemplate.FieldByName('rec_no').AsInteger;
    THardware.SQL.Text := 'SELECT * FROM `uni_hardware` WHERE `kind`=' +
    IntToStr(i_category) + ';';
    end;
    if CategoryNotUsed.Checked then
    begin
    i_category := -1;
    end; }

  i_category := TTemplate.FieldByName('rec_no').AsInteger;
  MemoryTable.first;
  If MemoryTable.RecordCount > 100 Then
    DBGridPreview.Visible := false;
  PanelInfo.Caption := '   ...';

  While Not MemoryTable.Eof Do
    Try
      If ((MemoryTable.RecNo Div 100) = (MemoryTable.RecNo / 100)) Then
      Begin
        PanelInfo.Caption := ': ' +
          IntToStr(Round((MemoryTable.RecNo / MemoryTable.RecordCount) *
          100)) + '%';
      End;
      //
      v_article := trim(MemoryTable.FieldByName('article').AsString);
      v_name := trim(MemoryTable.FieldByName('name').AsString);
      v_price := MemoryTable.FieldByName('price').AsFloat;
      v_developer := trim(MemoryTable.FieldByName('developer').AsString);
      v_comment := trim(MemoryTable.FieldByName('comment').AsString);

      If (v_article <> '') Then
      Begin
        THardware.SQL.Text := 'SELECT * FROM `uni_hardware` WHERE `kind`=' +
          IntToStr(i_category) + ' AND `article`=' + QuotedStr(v_article) +
          ' LIMIT 1;';

        THardware.Active := true;
        If (THardware.RecordCount > 0) Then
        Begin
          THardware.Edit;
          THardware.FieldByName('lastupdate').AsDateTime := Now();
          If (_name.Text <> '') Then
            THardware.FieldByName('name').AsString := v_name;
          If (_price.Text <> '') Then
            THardware.FieldByName('price').AsFloat := v_price;
          If (_developer.Text <> '') Then
            THardware.FieldByName('developer').AsString := v_developer;
          If (_comment.Text <> '') Then
            THardware.FieldByName('comment').AsString := v_comment;
          THardware.Post;
          // THardware.RowsAffected;
          cnt_old := cnt_old + 1;
        End
        Else
        Begin
          THardware.Append;
          THardware.FieldByName('kind').AsString := IntToStr(i_category);
          THardware.FieldByName('article').AsString := v_article;
          THardware.FieldByName('lastupdate').AsDateTime := Now();
          If (_name.Text <> '') Then
            THardware.FieldByName('name').AsString := v_name;
          If (_price.Text <> '') Then
            THardware.FieldByName('price').AsFloat := v_price;
          If (_developer.Text <> '') Then
            THardware.FieldByName('developer').AsString := v_developer;
          If (_comment.Text <> '') Then
            THardware.FieldByName('comment').AsString := v_comment;
          THardware.Post;
          cnt_new := cnt_new + 1;
        End;
        Application.ProcessMessages;
        MemoryTable.Next;
      End;
    Except
      ShowMessage(' ');
    End;

  DBGridPreview.Visible := true;
  PanelInfo.Caption := '  Excel';
  If ((cnt_new > 0) Or (cnt_old > 0)) Then
    ShowMessage('   ' + #13#10 + ': ' +
      IntToStr(cnt_new))
  Else
    ShowMessage('     ')

End;

Procedure TfrmImportFromXLS.actImportExecute(Sender: TObject);
Var
  icid, i: integer;
  olev: OleVariant;
  cnt: integer;
  first, last: integer;
  pos_articul: integer;
  category: String;
  category_id: integer;
  pos_category, pos_name, pos_price, pos_developer, pos_comment: integer;
  curPage: integer;
  OpenSuccess: Boolean;
var
  usedRange: TRangeRect;
Begin
  //   
  AbortProgress := false;
  _article.Text := trim(_article.Text);
  _name.Text := trim(_name.Text);
  _price.Text := trim(_price.Text);
  _developer.Text := trim(_developer.Text);
  _comment.Text := trim(_comment.Text);
  if not trystrtoint(_PageNo.Text, curPage) then
    curPage := 0
  else
    curPage := curPage - 1;
  if curPage < 0 then
    curPage := 0;

  If (_article.Text = '') Then
  Begin
    ShowMessage('.    ');
  End
  Else If FileExists(ExcelFilenameEdit.Text) Then
  begin
    InProgress := true;
    Pages.ActivePage := TabSheetPreview;
    PanelInfo.Caption := ' ...';
    actImport.Update;
    DBGridPreview.DataSource := Nil;
    DBGridPreview.Visible := false;
    Application.ProcessMessages;

    MemoryTable.Active := true;
    MemoryTable.EmptyTable;
    OpenSuccess := false;
    try
      xf.OpenFile(ExcelFilenameEdit.Text);
      OpenSuccess := true;
    except
      OpenSuccess := false;
      ShowMessage('   .' + #13#10 +
        '   Office 2003  ');
    end;
    if OpenSuccess then
    begin
      xf.Workbook.Sheets[curPage].GetUsedRect(usedRange);
      cnt := usedRange.RowTo;
      // fill data to temp table
      pos_articul := ConvertToInteger(_article.Text);
      pos_name := ConvertToInteger(_name.Text);
      pos_price := ConvertToInteger(_price.Text);
      pos_developer := ConvertToInteger(_developer.Text);
      pos_comment := ConvertToInteger(_comment.Text);
      If OnlyCategory.Checked Then
      Begin
        category := TTemplate.FieldByName('name').AsString;
        category_id := TTemplate.FieldByName('rec_no').AsInteger;
      End
      Else
      Begin
        pos_category := -1;
      End;

      if not trystrtoint(_last.Text, last) then
        last := cnt
      else if last > cnt then
        last := cnt
      else
        last := last - 1;

      if not trystrtoint(_first.Text, first) then
        first := 0
      else if first > cnt then
        first := 0
      else
        first := first - 1;

      For i := first To last Do
      Begin
        If ((i Div 1000) = (i / 1000)) Then
          Application.ProcessMessages;
        If AbortProgress Then
          break;

        //  
        MemoryTable.Append;
        If ((i Div 100) = (i / 100)) Then
          PanelInfo.Caption := '  Excel [' + IntToStr(i) + '   '
            + IntToStr(cnt) + ' ]';

        If pos_articul > -1 Then
          MemoryTable.FieldByName('article').AsString :=
            trim(xf.Workbook.Sheets[curPage].Cells[i, pos_articul].Value)
        Else If (_article.Text <> '') Then
          MemoryTable.FieldByName('article').AsString := _article.Text;

        If pos_name > -1 Then
          MemoryTable.FieldByName('name').AsString :=
            trim(xf.Workbook.Sheets[curPage].Cells[i, pos_name].Value)
        Else If (_name.Text <> '') Then
          MemoryTable.FieldByName('name').AsString := _name.Text;

        If pos_price > -1 Then
          MemoryTable.FieldByName('price').AsFloat :=
            MyStrToReal(trim(xf.Workbook.Sheets[curPage].Cells[i,
            pos_price].Value));

        If pos_developer > -1 Then
          MemoryTable.FieldByName('developer').AsString :=
            trim(xf.Workbook.Sheets[curPage].Cells[i, pos_developer].Value)
        Else If (_developer.Text <> '') Then
          MemoryTable.FieldByName('developer').AsString := _developer.Text;

        If pos_comment > -1 Then
          MemoryTable.FieldByName('comment').AsString :=
            trim(xf.Workbook.Sheets[curPage].Cells[i, pos_comment].Value)
        Else If (_comment.Text <> '') Then
          MemoryTable.FieldByName('comment').AsString := _comment.Text;

        MemoryTable.Post;
        If MemoryTable.FieldByName('article').AsString = '' Then
          MemoryTable.Delete;
      End;

    End;
    ExcelClose;
  end
  Else
  Begin
    ShowMessage
      ('   .        ');
  End;
  PanelInfo.Caption := '  Excel';
  DBGridPreview.DataSource := DSMemoryTable;
  DBGridPreview.Visible := true;
  InProgress := false;
End;

End.
