Unit WordExcel;

Interface

Uses
  SysUtils, Classes, WordXP, ExcelXP, OleServer, Windows, Dialogs, OleCtrls;

Type
  TfrmWordExcel = Class(TDataModule)
    Procedure DataModuleCreate(Sender: TObject);
    Procedure DataModuleDestroy(Sender: TObject);
  Private
    { Private declarations }
  Public
    ExcelApplication1: TExcelApplication;
    ExcelWorkbook1: TExcelWorkbook;
    ExcelWorksheet1: TExcelWorksheet;
    WordDocument1: TWordDocument;
    WordApplication1: TWordApplication;
    LCID: integer;
    Procedure ExcelLoad(filename: String);
    Procedure ExcelClose;
    { Public declarations }
  End;

Var
  frmWordExcel: TfrmWordExcel;

Implementation

{$R *.dfm}

Procedure TfrmWordExcel.DataModuleCreate(Sender: TObject);
Begin
  LCID := GetUserDefaultLCID;
  ExcelApplication1 := TExcelApplication.Create(Nil);
  ExcelWorkbook1 := TExcelWorkbook.Create(Nil);
  ExcelWorksheet1 := TExcelWorksheet.Create(Nil);
  WordApplication1 := TWordApplication.Create(Nil);
  WordDocument1 := TWordDocument.Create(Nil);
End;

Procedure TfrmWordExcel.ExcelLoad(filename: String);
Var
  fil, SaveChanges: OleVariant;
  LCID, i, cnt: integer;
  What, LookIn, LookAt, SearchOrder, SearchDirection, MathCase, MathByte,
    SearchFormat: OleVariant;
  c_name, c_kinddesc, c_article, c_count, c_price, c_total,
    c_comment: OleVariant;
  f_name, f_kinddesc, f_article, f_count, f_price, f_total,
    f_comment: ExcelRange;
  ursys, curcount: integer;
  total_system, total_project: real;
  Found: ExcelRange;
  num: integer;
Type
  TWordReplaceFlags = Set Of (wrfReplaceAll, wrfMatchCase, wrfMatchWildcards);
Begin
  Try
    ExcelApplication1.ConnectKind := ckNewInstance;
    ExcelApplication1.Connect; // 
    ExcelApplication1.AutoQuit := False;
    ExcelApplication1.Visible[LCID] := False;
    fil := filename;
    ExcelApplication1.Workbooks.Open(fil, EmptyParam, EmptyParam, EmptyParam,
      EmptyParam, EmptyParam, EmptyParam, EmptyParam, EmptyParam, EmptyParam,
      EmptyParam, EmptyParam, EmptyParam, EmptyParam, EmptyParam, LCID);
    ExcelWorkbook1.ConnectTo(ExcelApplication1.ActiveWorkbook);
  Except
    ShowMessage(' ExcelLoad');
  End;
End;

Procedure TfrmWordExcel.DataModuleDestroy(Sender: TObject);
Begin
  FreeAndNil(ExcelWorksheet1);
  FreeAndNil(ExcelWorkbook1);
  FreeAndNil(ExcelApplication1);
  FreeAndNil(WordDocument1);
  FreeAndNil(WordApplication1);
End;

Procedure TfrmWordExcel.ExcelClose;
Begin
  Try
    ExcelWorkbook1.Close(true, '', False, LCID);
    ExcelWorkbook1.Disconnect;
    ExcelApplication1.Disconnect;
  Except
    ShowMessage(' ExcelClose');
  End;
End;

End.
