Unit Users;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, JvExDBGrids, JvDBGrid, DB,
  Menus, JvMenus, ActnList, ExtCtrls, StdCtrls, ComCtrls, System.Actions,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client;

Type
  TfrmUsers = Class(TForm)
    MainMenu: TMainMenu;
    mUsers: TMenuItem;
    mUsersAdd: TMenuItem;
    mUsersEdit: TMenuItem;
    mUsersDelete: TMenuItem;
    Actions: TActionList;
    actUsersAdd: TAction;
    actUsersEdit: TAction;
    actUsersDelete: TAction;
    PopupMenu: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    DSUsers: TDataSource;
    TemplateGrid: TJvDBGrid;
    PanelTop: TPanel;
    _Search: TEdit;
    Label2: TLabel;
    TUsers: TFDQuery;
    StatusBar: TStatusBar;
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    Procedure FormActivate(Sender: TObject);
    Procedure FormShow(Sender: TObject);
    Procedure actUsersAddExecute(Sender: TObject);
    Procedure actUsersDeleteExecute(Sender: TObject);
    Procedure actUsersEditExecute(Sender: TObject);
    Procedure TemplateGridDblClick(Sender: TObject);
    Procedure actUsersEditUpdate(Sender: TObject);
    Procedure actUsersDeleteUpdate(Sender: TObject);
    Procedure _SearchChange(Sender: TObject);
    procedure actUsersAddUpdate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  Private
    Procedure UpdateList;
    procedure SetUserMySQL(username, password: string; status: integer);
    procedure ReqMySQL(req: string);
    { Private declarations }
  Public
    { Public declarations }
  End;

Implementation

Uses Main, UserAdd, UserDelete, LanguageSelect, Universal;

{$R *.dfm}

Procedure TfrmUsers.actUsersAddExecute(Sender: TObject);
Begin
  frmUserAdd.ClearData;
  If frmUserAdd.ShowModal = mrOk Then
  Begin
    TUsers.Append;
    TUsers.FieldByName('username').AsString := frmUserAdd.username.Text;
    TUsers.FieldByName('userpass').AsString := frmUserAdd.userpass.Text;
    TUsers.FieldByName('usergroup').AsString := frmUserAdd.Usergroup.Text;
    TUsers.FieldByName('user_fio').AsString := frmUserAdd.user_fio.Text;
    TUsers.FieldByName('email').AsString := frmUserAdd.email.Text;
    TUsers.FieldByName('active').AsInteger := frmUserAdd.status.ItemIndex;
    TUsers.FieldByName('address_index').AsString := frmUserAdd.address_index.Text;
    // TUsers.FieldByName('country_code').AsString := frmUserAdd.country_code.Text;
    TUsers.FieldByName('phone_1').AsString := frmUserAdd.phone_1.Text;
    TUsers.FieldByName('phone_2').AsString := frmUserAdd.phone_2.Text;
    TUsers.FieldByName('address_line_1').AsString := frmUserAdd.address_line_1.Text;
    TUsers.FieldByName('address_line_2').AsString := frmUserAdd.address_line_2.Text;
    TUsers.Post;

    SetUserMySQL(frmUserAdd.username.Text, frmUserAdd.userpass.Text, frmUserAdd.status.ItemIndex);
  End;
End;

procedure TfrmUsers.actUsersAddUpdate(Sender: TObject);
begin
  actUsersAdd.Enabled := (frmMain.Usergroup.Length > 1)
end;

Procedure TfrmUsers.actUsersDeleteExecute(Sender: TObject);
Begin
  If frmUserDelete.ShowModal = mrOk Then
  Begin
    TUsers.Delete;
  End;
End;

Procedure TfrmUsers.actUsersDeleteUpdate(Sender: TObject);
Begin
  actUsersDelete.Enabled := (frmMain.Usergroup.Length > 1) and (TUsers.RecordCount > 0);
End;

Procedure TfrmUsers.actUsersEditExecute(Sender: TObject);
Begin
  frmUserAdd.ClearData;
  If (TUsers.RecordCount > 0) Then
    Try
      frmUserAdd.username.Text := TUsers.FieldByName('username').AsString;
      frmUserAdd.userpass.Text := TUsers.FieldByName('userpass').AsString;
      frmUserAdd.user_fio.Text := TUsers.FieldByName('user_fio').AsString;
      frmUserAdd.email.Text := TUsers.FieldByName('email').AsString;
      frmUserAdd.status_int := TUsers.FieldByName('active').AsInteger;
      frmUserAdd.address_index.Text := TUsers.FieldByName('address_index').AsString;
      // frmUserAdd.country_code.Text :=        TUsers.FieldByName('country_code').AsString;
      frmUserAdd.phone_1.Text := TUsers.FieldByName('phone_1').AsString;
      frmUserAdd.phone_2.Text := TUsers.FieldByName('phone_2').AsString;
      frmUserAdd.address_line_1.Text := TUsers.FieldByName('address_line_1').AsString;
      frmUserAdd.address_line_2.Text := TUsers.FieldByName('address_line_2').AsString;
      frmUserAdd.Usergroup.Text := TUsers.FieldByName('usergroup').AsString;

      If frmUserAdd.ShowModal = mrOk Then
      Begin
        TUsers.Edit;
        TUsers.FieldByName('username').AsString := frmUserAdd.username.Text;
        TUsers.FieldByName('userpass').AsString := frmUserAdd.userpass.Text;
        TUsers.FieldByName('usergroup').AsString := frmUserAdd.Usergroup.Text;
        TUsers.FieldByName('user_fio').AsString := frmUserAdd.user_fio.Text;
        TUsers.FieldByName('email').AsString := frmUserAdd.email.Text;
        TUsers.FieldByName('active').AsInteger := frmUserAdd.status.ItemIndex;
        TUsers.FieldByName('address_index').AsString := frmUserAdd.address_index.Text;
        // TUsers.FieldByName('country_code').AsString :=          frmUserAdd.country_code.Text;
        TUsers.FieldByName('phone_1').AsString := frmUserAdd.phone_1.Text;
        TUsers.FieldByName('phone_2').AsString := frmUserAdd.phone_2.Text;
        TUsers.FieldByName('address_line_1').AsString := frmUserAdd.address_line_1.Text;
        TUsers.FieldByName('address_line_2').AsString := frmUserAdd.address_line_2.Text;
        TUsers.Post;

        SetUserMySQL(frmUserAdd.username.Text, frmUserAdd.userpass.Text, frmUserAdd.status.ItemIndex);
      End;

    Except
    End;
End;

Procedure TfrmUsers.actUsersEditUpdate(Sender: TObject);
Begin
  actUsersEdit.Enabled := (frmMain.Usergroup.Length > 1) and (TUsers.RecordCount > 0);
End;

Procedure TfrmUsers.FormActivate(Sender: TObject);
Begin
  _Search.SetFocus;
End;

Procedure TfrmUsers.FormClose(Sender: TObject; Var Action: TCloseAction);
Begin
  Action := caFree;
End;

procedure TfrmUsers.FormCreate(Sender: TObject);
begin
  WindowState := frmMain.ws;
end;

Procedure TfrmUsers.FormShow(Sender: TObject);
Begin
  if not frmUniversal.DBConnected then
    close;

  Try
    TUsers.Active := true;
  Except
    ShowMessage('   ');
    close;
  End;
End;

Procedure TfrmUsers.TemplateGridDblClick(Sender: TObject);
Begin
  actUsersEdit.Execute;
End;

Procedure TfrmUsers._SearchChange(Sender: TObject);
Begin
  UpdateList;
End;

Procedure TfrmUsers.UpdateList;
Var
  filter: String;
Begin

  If _Search.Text <> '' Then
  Begin
    filter := filter + ' WHERE (`username` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `email` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `user_fio` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `phone_1` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `phone_2` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `address_line_1` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `address_line_2` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `usergroup` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ') ';
  End;

  TUsers.SQL.Text := 'SELECT * FROM `uni_users` ' + filter + ' ORDER BY `username`;';
  TUsers.Active := true;
End;

Procedure TfrmUsers.SetUserMySQL(username, password: string; status: integer);
var
  db, uname, req: string;
begin
  db:=frmUniversal.DatabaseConnection.Params.Values['Server'].Trim;
  username := frmUniversal.Translit(username);
  uname := '''' + username + '''@''%''';
  req := 'CREATE USER IF NOT EXISTS ' + uname + ' IDENTIFIED BY ''' + password + '''';
  ReqMySQL(req);
  //   ,     
  if status = 0 then
    ReqMySQL('REVOKE ALL ON '+db+'.* FROM ' + uname + ';');
  //   ,    
  if status = 0 then
    ReqMySQL('REVOKE GRANT OPTION ON '+db+'.* FROM ' + uname + ';');
  //  ,     
  if status = 1 then
  begin
    ReqMySQL('REVOKE GRANT OPTION ON '+db+'.* FROM ' + uname + ';');
    ReqMySQL('GRANT ALL ON '+db+'.* TO ' + uname + ';');
  end;
  //  ,     
  if status = 2 then
    ReqMySQL('GRANT ALL ON '+db+'.* TO ' + uname + ' WITH GRANT OPTION;');
  // 
  ReqMySQL('FLUSH PRIVILEGES;');
end;

Procedure TfrmUsers.ReqMySQL(req: string);
begin
  try
    frmUniversal.DatabaseConnection.ExecSQL(req);
  except
  end;
end;

End.
