Unit UserLogin;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls,
  JvExExtCtrls, JvExtComponent, DB, Registry, FireDAC.Stan.Intf,
  FireDAC.Stan.Option, FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS,
  FireDAC.Phys.Intf, FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt,
  FireDAC.Comp.DataSet, FireDAC.Comp.Client;

Type
  TfrmUserLogin = Class(TForm)
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    Label1: TLabel;
    _UserName: TComboBox;
    Label9: TLabel;
    _UserPass: TEdit;
    TUsers: TFDQuery;
    DSUsers: TDataSource;
    AutoLogon: TCheckBox;
    MyQuery1: TFDQuery;
    _server: TEdit;
    Label2: TLabel;
    _database: TEdit;
    Label3: TLabel;
    btnSave: TJvFooterBtn;
    Procedure FormActivate(Sender: TObject);
    Procedure FormShow(Sender: TObject);
    Procedure btnOkClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure AutoLogonClick(Sender: TObject);
    procedure Label9Click(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
  Private
    server, port: String;
    procedure WriteSettings;
    procedure DecodeServerPort;
    { Private declarations }
  Public
    Reg: TRegistry;
    UserGroup: String;
    { Public declarations }
  End;

Var
  frmUserLogin: TfrmUserLogin;

Implementation

Uses Main, Universal;
{$R *.dfm}

Procedure TfrmUserLogin.WriteSettings;
begin
  DecodeServerPort;

  Try
    Reg.RootKey := HKEY_CURRENT_USER;
    If Reg.OpenKey('\Software\mysoftware\orderbase2', true) Then
    Begin
      Reg.WriteBool('autologon', AutoLogon.Checked);
      Reg.WriteString('server', server);
      Reg.WriteString('port', port);
      if port = '3306' then
        Reg.DeleteValue('port');
      Reg.WriteString('userlogin', _UserName.Text);
      Reg.WriteString('database', frmUniversal.DatabaseConnection.Params.Database);
      if AutoLogon.Checked then
      begin
        Reg.WriteString('userpass', _UserPass.Text);
      end
      else
      begin
        Reg.WriteString('userpass', '');
      end;
    End;
  except
  End;
  //
end;

Procedure TfrmUserLogin.DecodeServerPort;
var
  iport: integer;
  full: string;
begin
  full := trim(_server.Text);
  server:=full;
  port := '3306';
  if pos(':', full) > 0 then
  begin
    port := copy(full, pos(':', full) + 1);
    server := copy(full, 1, pos(':', full) - 1);
    if not TryStrToInt(port, iport) then
      port := '3306';
  end;
end;

Procedure TfrmUserLogin.btnOkClick(Sender: TObject);
Var
  realpass: String;
  success: boolean;
Begin
  success := false;
  btnOk.Enabled := false;

  DecodeServerPort;

  frmUniversal.DatabaseConnection.Connected := false;
  frmUniversal.DatabaseConnection.Params.Values['Server'] := server;
  frmUniversal.DatabaseConnection.Params.Values['port'] := port;
  frmUniversal.DatabaseConnection.Params.Username := frmUniversal.Translit(trim(_UserName.Text));
  frmUniversal.DatabaseConnection.Params.Database := trim(_database.Text);
  frmUniversal.DatabaseConnection.Params.password := trim(_UserPass.Text);
  frmUniversal.DatabaseConnection.Params.Values['LoginTimeout'] := '10';

  Application.ProcessMessages;
  Try
    frmUniversal.DatabaseConnection.Connected := true;
  Except
  End;

  if frmUniversal.DBConnected then
    success := true
  else
    ShowMessage('  ');

  if success then
    WriteSettings;

  if success then
  begin
    ModalResult := mrOk;
  end;

  btnOk.Enabled := true;
End;

procedure TfrmUserLogin.AutoLogonClick(Sender: TObject);
begin
  Try
    Reg.RootKey := HKEY_CURRENT_USER;
    If Reg.OpenKey('\Software\mysoftware\orderbase2', true) Then
    Begin
      Reg.WriteBool('autologon', AutoLogon.Checked);
    End;
  except
  End;
end;

Procedure TfrmUserLogin.FormActivate(Sender: TObject);
Begin
  btnOk.SetFocus;
End;

procedure TfrmUserLogin.FormCreate(Sender: TObject);
begin
  Reg := TRegistry.Create;
end;

procedure TfrmUserLogin.FormDestroy(Sender: TObject);
begin
  Reg.Free;
end;

Procedure TfrmUserLogin.FormShow(Sender: TObject);
Begin
  btnOk.Enabled := true;

  {
    if not frmUniversal.DBConnected then
    close;
    _UserName.Items.Clear;

    Try
    TUsers.Active := true;
    TUsers.First;
    While Not TUsers.eof Do
    Begin
    _UserName.Items.Add(TUsers.FieldByName('username').AsString);
    TUsers.Next;
    End;
    Except
    // showmessage('   ');
    // close;
    End;
  }

  Try
    Reg.RootKey := HKEY_CURRENT_USER;
    If Reg.OpenKey('\Software\mysoftware\orderbase2', true) Then
    Begin
      If Reg.ValueExists('autologon') Then
        AutoLogon.Checked := Reg.ReadBool('autologon');
      If Reg.ValueExists('server') Then
        _server.Text := Reg.ReadString('server');
      If Reg.ValueExists('port') and (Reg.ReadString('server') <> '3306') Then
        _server.Text := _server.Text + ':' + Reg.ReadString('port');

      If Reg.ValueExists('database') Then
        _database.Text := Reg.ReadString('database');
      If Reg.ValueExists('userlogin') Then
        _UserName.Text := Reg.ReadString('userlogin');
      If Reg.ValueExists('userpass') Then
        _UserPass.Text := Reg.ReadString('userpass');
    End;
  Finally
  End;
End;

procedure TfrmUserLogin.btnSaveClick(Sender: TObject);
begin
  WriteSettings;
end;

procedure TfrmUserLogin.Label9Click(Sender: TObject);
begin
  _UserPass.PasswordChar := #0;
end;

End.
