unit Universal;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, IdHashMessageDigest,
  idHash, Clipbrd, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Data.DB,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Error, FireDAC.UI.Intf, FireDAC.Phys.Intf, FireDAC.Stan.Def,
  FireDAC.Stan.Pool, FireDAC.Stan.Async, FireDAC.Phys, FireDAC.VCLUI.Wait,
  FireDAC.Stan.Param, FireDAC.DatS, FireDAC.DApt.Intf, FireDAC.DApt,
  FireDAC.Comp.DataSet, FireDAC.Comp.Client, FireDAC.Phys.MySQL, math,
  FireDAC.Phys.MySQLDef, FireDAC.Comp.UI, Vcl.ExtCtrls;

type
  TfrmUniversal = class(TForm)
    DatabaseConnection: TFDConnection;
    DatabaseQuery1: TFDQuery;
    FilebaseQuery1: TFDQuery;
    DatabaseQuery2: TFDQuery;
    FDPhysMySQLDriverLink1: TFDPhysMySQLDriverLink;
    MyQuery1: TFDQuery;
    FDQuery1: TFDQuery;
    FDGUIxWaitCursor1: TFDGUIxWaitCursor;
    TimerUpdateTotal: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure DatabaseConnectionAfterConnect(Sender: TObject);
    procedure TimerUpdateTotalTimer(Sender: TObject);
  private
    MyFile: TMemoryStream;
    { Private declarations }
  public
    filebaseerror: string;
    title: string;
    TableArray: Tstrings;
    maxSize: integer;
    TotalQuery: Tstrings;
    function DBConnected: Boolean;
    function FBConnected: Boolean;
    function FileSaveToFB(FileName: string): string; Overload;
    function FileSaveToFB(sourceStream: TMemoryStream; fext: string): string; Overload;
    function FileGetByName(FileName: string): TMemoryStream;
    procedure FileGetByNameToFile(intFileName, extFilename: string);
    procedure SendMessage(myText, myTitle, myRecipients: string);
    procedure UpdateFieldHardwareList(project_no: integer);
    function Translit(s: string): string;
    function RemoveUnusedFile(FileName: string): Boolean;
    function UpdateProjectFromBase(project_no, system_no: integer; fields: string; price_no: integer): integer;
    procedure RecalcOverpriceForProject(project_no: integer; activeonly: Boolean);
    procedure RecalcOverpriceForSystem(system_no: integer);
    procedure UpdateTotalQuery(system_no: integer);
    procedure StringToHWD(strinp: string; var h, w, d: integer);
    procedure DetectGabaritesForSystem(system_no: integer);
    procedure DetectGabaritesForProject(project_no: integer; activeonly: Boolean);
    { Public declarations }
  end;

var
  frmUniversal: TfrmUniversal;

implementation

{$R *.dfm}

uses Main, Project;

procedure TfrmUniversal.DatabaseConnectionAfterConnect(Sender: TObject);
var
  packetsize: integer;
begin
  packetsize := 1024 * 1024 * 1024; // maxSize
  DatabaseConnection.ExecSQL('SET GLOBAL max_allowed_packet=' + packetsize.ToString + ';');
end;

{
  procedure TfrmUniversal.DatabaseConnectionConnectionLost(Sender: TObject; Component: TComponent;
  ConnLostCause: TConnLostCause; var RetryMode: TRetryMode);
  begin
  //RetryMode := rmReconnectExecute;
  end;

  procedure TfrmUniversal.DatabaseConnectionError(Sender: TObject; E: EDAError; var Fail: Boolean);
  begin
  Fail := false;
  frmMain.userstatus := E.Message;
  // ShowMessage(E.Message);
  end;
}
Function TfrmUniversal.FBConnected: Boolean;
begin
  {
    if not FilebaseConnection.Connected and (frmSettings.fb_basename <> '') then
    Try
    if Length(frmSettings.fb_basename.trim) > 1 then
    begin
    FilebaseConnection.params.Database := frmSettings.fb_basename.trim;
    FilebaseConnection.params.username := frmSettings.fb_username;
    FilebaseConnection.params.Values['Server'] := frmSettings.fb_server;
    FilebaseConnection.params.password := frmSettings.fb_password;
    FilebaseConnection.params.Values['port'] := frmSettings.fb_port.ToString;
    end
    else
    begin
    FilebaseConnection.params.Database := frmSettings.db_basename.trim;
    FilebaseConnection.params.username := frmSettings.db_username;
    FilebaseConnection.params.Values['Server'] := frmSettings.db_server;
    FilebaseConnection.params.password := frmSettings.db_password;
    FilebaseConnection.params.Values['port'] := frmSettings.db_port.ToString;
    end;

    // FilebaseConnection.SpecificOptions.Values['ConnectionTimeOut'] := '60';
    if Length(FilebaseConnection.params.Database) > 0 then
    FilebaseConnection.Connected := true;
    Except
    End;
    result := DatabaseConnection.Connected;
  }
end;

Function TfrmUniversal.DBConnected: Boolean;
begin
  result := DatabaseConnection.Connected;
end;

procedure TfrmUniversal.FormCreate(Sender: TObject);
begin
  title := frmMain.caption;
  maxSize := 20971520; // 20mb
  TotalQuery := TStringList.Create;

  TableArray := TStringList.Create;
  // TableArray.Add
  // ('uni_hardwarefiles;filename varchar(32);fileinfo text;lastupdate text;');
  TableArray.Add
    ('uni_customerdetail;parent int(11);name varchar(100);email varchar(100);user_fio varchar(200);user_job varchar(200);country_code varchar(10);phone_1 varchar(20);phone_2 varchar(20);'
    + 'address_index varchar(20);address_line_1 varchar(100);address_line_2 varchar(100);submissions varchar(20);lastlogin date;kind varchar(20);comment text;web varchar(200);owner varchar(100);');
  TableArray.Add('uni_customerkinds;name varchar(100);');
  TableArray.Add
    ('uni_customers;parent int(11);parentcustomer int(11);name varchar(100);name_uri varchar(100);web varchar(100);inn varchar(100);kpp varchar(100);bank text;owner varchar(100);email varchar(100);user_fio varchar(200);'
    + 'user_job varchar(200);country_code varchar(10);phone_1 varchar(20);phone_2 varchar(20);address_index varchar(20);address_town varchar(100);address_oblast varchar(100);address_line_1 varchar(100);address_line_2 varchar(100);'
    + 'submissions varchar(20);lastlogin date;kind varchar(20);comment text;');
  TableArray.Add('uni_customertree;parent int(11);name varchar(100);icon_no int(11);');
  TableArray.Add
    ('uni_developers;name varchar(100);email varchar(100);user_fio varchar(200);user_job varchar(200);country_code varchar(10);phone_1 varchar(20);phone_2 varchar(20);address_index varchar(20);address_line_1 varchar(100);address_line_2 varchar(100);'
    + 'submissions varchar(20);lastlogin date;kind varchar(20);comment text;');
  TableArray.Add('uni_files;filename varchar(200);filepath varchar(200);published varchar(200);update datetime;');
  TableArray.Add
    ('uni_hardware;kind int(11);article varchar(200);name varchar(200);comment varchar(200);price float(9,2);pricebuy float(9,2);valuta varchar(3);file varchar(200);developer varchar(100);lastupdate date;modules float(3,1);discount float(3,2);'
    + 'kinddesc varchar(100);imagepath varchar(50);details varchar(50);nds int(11);');
  TableArray.Add
    ('uni_hardwareparams;parent int(11);kind_no varchar(10);title varchar(100);left int(11);top int(11);width int(11);height int(11);value varchar(200);values text;');
  TableArray.Add
    ('uni_logs;table varchar(100);table_rec_no int(11);action varchar(100);user varchar(100);hostname varchar(100);');
  TableArray.Add
    ('uni_parameters;parent int(11);kind_no varchar(10);title varchar(100);left int(11);top int(11);width int(11);height int(11);value varchar(200);values text;');
  TableArray.Add
    ('uni_projectatt;project_no int(11);system_no int(11);name varchar(200);article varchar(200);comment varchar(200);developer varchar(200);file varchar(200);price float(9,2);valuta varchar(3);count int(11);modules float(3,1);lastupdate date;');
  TableArray.Add
    ('uni_projecthardware;project_no int(11);system_no int(11);orderby int(11);name varchar(200);article varchar(200);comment varchar(200);developer varchar(200);file varchar(100);price float(9,2);valuta varchar(3);'
    + 'count int(11);modules float(3,1);kinddesc varchar(100);buydiscount float(9,2);salediscount float(9,2);imagepath varchar(100);details text;');
  TableArray.Add
    ('uni_projectparams;parent int(11);kind_no varchar(10);title varchar(100);left int(11);top int(11);width int(11);height int(11);value varchar(200);values text;');
  TableArray.Add
    ('uni_projects;name varchar(200);datestart date;dateend date;dateupdate date;dateprotect date;owner_customer varchar(200);owner_customer_manager varchar(200);owner_customer_director varchar(200);owner_engineer varchar(200);owner_manager varchar(200);'
    + 'options varchar(10);info text;cost float(9,2);state varchar(200);pnum int(11);cursUSD float(9,2);cursEUR float(9,2);desc varchar(200);placement varchar(200);dogovor_no varchar(50);');
  TableArray.Add
    ('uni_templates;name varchar(100);parent int(11);unit_sizeimage int(11);unit_sizethumb int(11);template_folders text;template_units text;');
  TableArray.Add
    ('uni_templatesfields;parent int(11);kind varchar(10);name varchar(100);description varchar(200);defaultvalue varchar(100);defaultvalues text;');
  TableArray.Add
    ('uni_users;boss_id int(11);username varchar(100);userpass varchar(20);active int(11);email varchar(100);usergroup varchar(20);user_fio varchar(200);country_code varchar(10);phone_1 varchar(20);phone_2 varchar(20);'
    + 'address_index varchar(20);address_line_1 varchar(100);address_line_2 varchar(100);submissions varchar(20);lastlogin date;');
  TableArray.Add
    ('uni_valuta;valuta_code varchar(3);valuta_buy float(9,2);valuta_sale float(9,2);valuta_HTML varchar(100);');
  TableArray.Add
    ('uni_messages;sender varchar(100);recipient varchar(100);send datetime;received datetime;detail_id int(11);status int(11);');
  TableArray.Add('uni_messages_detail;title varchar(200);detail text;');
  //
end;

procedure TfrmUniversal.FormDestroy(Sender: TObject);
begin
  TotalQuery.free;
  TableArray.free;
end;

function TfrmUniversal.FileSaveToFB(FileName: string): string;
var
  sourceStream: TFileStream;
  sf, fext: string;
  idmd5: TIdHashMessageDigest5;
  md5sum, newfilename: string;
  FileSize: integer;
  tablename: string;
begin
  newfilename := '';
  sf := ExtractFileName(FileName);
  fext := ExtractFileExt(FileName);
  filebaseerror := '';
  tablename := 'files';
  //
  try
    sourceStream := TFileStream.Create(FileName, fmOpenRead OR fmShareDenyWrite);
    FileSize := sourceStream.Size;
    sourceStream.Seek(0, soFromBeginning);
    idmd5 := TIdHashMessageDigest5.Create;
    md5sum := idmd5.HashStreamAsHex(sourceStream);
    newfilename := md5sum + fext;
    idmd5.free;
    sourceStream.free;
  except
    newfilename := '     ';
    result := newfilename;
    exit;
  end;

  tablename := 'files_' + copy(md5sum, 1, 2);

  if (FileSize > maxSize) then
  begin
    newfilename := '  ';
    result := newfilename;
    exit;
  end
  else
  begin
    try
      FilebaseQuery1.SQL.text := 'SELECT * FROM `' + tablename + '` WHERE `name`=:name;';
      FilebaseQuery1.ParamByName('name').AsString := newfilename;
      FilebaseQuery1.active := true;
      if (FilebaseQuery1.RecordCount > 0) then
      begin
        //   
        FilebaseQuery1.SQL.text := 'DELETE FROM `' + tablename + '` WHERE `name`=:name;';
        FilebaseQuery1.ParamByName('name').AsString := newfilename;
        FilebaseQuery1.Execute;
      end;
      //
      try
        // else
        begin
          //  
          FilebaseQuery1.SQL.text := 'INSERT INTO `' + tablename + '` (`name`,`file`) VALUES(:name,:file);';
          FilebaseQuery1.ParamByName('name').AsString := newfilename;
          FilebaseQuery1.ParamByName('file').LoadFromFile(FileName, ftBlob);
          FilebaseQuery1.ExecSQL;
        end;
      except
        newfilename := '     ';
      end;
    except
      newfilename := '     ';
    end;
  end;

  result := newfilename;
end;

function TfrmUniversal.FileSaveToFB(sourceStream: TMemoryStream; fext: string): string;
var
  sf: string;
  idmd5: TIdHashMessageDigest5;
  md5sum, newfilename: string;
  FileSize: integer;
  tablename: string;
begin
  newfilename := '';
  // sf := ExtractFileName(FileName);
  // fext := ExtractFileExt(FileName);
  filebaseerror := '';
  tablename := 'files';
  FileSize := sourceStream.Size;
  if FileSize = 0 then
  begin
    newfilename := '  ';
    result := newfilename;
    exit;
  end;

  //
  try
    sourceStream.Seek(0, soFromBeginning);
    idmd5 := TIdHashMessageDigest5.Create;
    md5sum := idmd5.HashStreamAsHex(sourceStream);
    newfilename := md5sum + '.' + fext;
    idmd5.free;
  except
    newfilename := '     ';
    result := newfilename;
    exit;
  end;

  tablename := 'files_' + copy(md5sum, 1, 2);

  if (FileSize > maxSize) then
  begin
    newfilename := '  ';
    result := newfilename;
    exit;
  end
  else
  begin
    try
      FilebaseQuery1.SQL.text := 'SELECT * FROM `' + tablename + '` WHERE `name`=:name;';
      FilebaseQuery1.ParamByName('name').AsString := newfilename;
      FilebaseQuery1.active := true;
      if (FilebaseQuery1.RecordCount > 0) then
      begin
        //   , 
        FilebaseQuery1.SQL.text := 'DELETE FROM `' + tablename + '` WHERE `name`=:name;';
        FilebaseQuery1.ParamByName('name').AsString := newfilename;
        FilebaseQuery1.ExecSQL;
      end;

      //  
      FilebaseQuery1.SQL.text := 'INSERT INTO `' + tablename + '` (`name`,`file`) VALUES(:name,:file);';
      FilebaseQuery1.ParamByName('name').AsString := newfilename;
      FilebaseQuery1.ParamByName('file').LoadFromStream(sourceStream, ftBlob);
      FilebaseQuery1.ExecSQL;
    except
      newfilename := '     ';
    end;
  end;

  result := newfilename;
end;

function TfrmUniversal.FileGetByName(FileName: string): TMemoryStream;
var
  // myfile: TMemoryStream;
  // folder, ff, storefile: string;
  BlobStream: TStream;
  tablename: string;
begin
  //   
  try
    MyFile.Clear;
  except
  end;

  tablename := 'files';

  {
    if FileName.Length > 10 then
    try
    FilebaseQuery1.active := false;
    FilebaseQuery1.SQL.text := 'SELECT `file` FROM `files` WHERE `name`=' + QuotedStr(FileName) + ';';
    FilebaseQuery1.active := true;
    if (FilebaseQuery1.RecordCount > 0) then
    begin
    //   
    BlobStream := FilebaseQuery1.CreateBlobStream(FilebaseQuery1.FieldByName('file'), TBlobStreamMode.bmRead);
    if (BlobStream.Size > 0) then
    begin
    MyFile.Position := 0;
    MyFile.LoadFromStream(BlobStream);
    ShowMessage(MyFile.Size.ToString);
    end;
    BlobStream.Free;
    end;
    except
    ShowMessage('error TfrmUniversal.FileGetByName1');
    end;
  }

  if FileName.Length > 10 then
    try
      tablename := 'files_' + copy(FileName, 1, 2);
      FilebaseQuery1.active := false;
      FilebaseQuery1.SQL.text := 'SELECT `file` FROM `' + tablename + '` WHERE `name`=' + QuotedStr(FileName) + ';';
      FilebaseQuery1.active := true;
      if (FilebaseQuery1.RecordCount > 0) then
      begin
        //   
        BlobStream := FilebaseQuery1.CreateBlobStream(FilebaseQuery1.FieldByName('file'), TBlobStreamMode.bmRead);
        if (BlobStream.Size > 0) then
        begin
          MyFile.Position := 0;
          MyFile.LoadFromStream(BlobStream);
          showmessage(MyFile.Size.ToString);
        end;
        BlobStream.free;
      end;
    except
      showmessage('error TfrmUniversal.FileGetByName2');
    end;

  result := MyFile;
end;

procedure TfrmUniversal.FileGetByNameToFile(intFileName, extFilename: string);
var
  // myfile: TMemoryStream;
  // folder, ff, storefile: string;
  BlobStream: TStream;
  FileStream: TFileStream;
  tablename: string;
begin

  tablename := 'files';

  { if intFileName.Length > 10 then
    try
    FilebaseQuery1.active := false;
    FilebaseQuery1.SQL.text := 'SELECT `file` FROM `files` WHERE `name`=' + QuotedStr(intFileName) + ';';
    FilebaseQuery1.active := true;
    if (FilebaseQuery1.RecordCount > 0) then
    begin
    //   
    BlobStream := FilebaseQuery1.CreateBlobStream(FilebaseQuery1.FieldByName('file'), TBlobStreamMode.bmRead);
    if (BlobStream.Size > 0) then
    begin
    FileStream := TFileStream.Create(extFilename, fmCreate);
    FileStream.CopyFrom(BlobStream, BlobStream.Size);
    FileStream.Free;
    end;
    BlobStream.Free;
    end;
    except
    ShowMessage('error TfrmUniversal.FileGetByNameToFile1');
    end;
  }

  if intFileName.Length > 10 then
    try
      tablename := 'files_' + copy(intFileName, 1, 2);
      FilebaseQuery1.active := false;
      FilebaseQuery1.SQL.text := 'SELECT `file` FROM `' + tablename + '` WHERE `name`=' + QuotedStr(intFileName) + ';';
      FilebaseQuery1.active := true;
      if (FilebaseQuery1.RecordCount > 0) then
      begin
        //   
        BlobStream := FilebaseQuery1.CreateBlobStream(FilebaseQuery1.FieldByName('file'), TBlobStreamMode.bmRead);
        if (BlobStream.Size > 0) then
        begin
          FileStream := TFileStream.Create(extFilename, fmCreate);
          FileStream.CopyFrom(BlobStream, BlobStream.Size);
          FileStream.free;
        end;
        BlobStream.free;
      end;
    except
      showmessage('error TfrmUniversal.FileGetByNameToFile2');
    end;

end;

procedure TfrmUniversal.SendMessage(myText, myTitle, myRecipients: string);
var
  mes_id: integer;
begin
  if myText.Length > 1 then
  begin
    //  
    DatabaseQuery1.SQL.text := 'INSERT INTO `uni_messages_detail` (`title`,`detail`) VALUES (:title,:detail)';
    DatabaseQuery1.ParamByName('title').AsString := myTitle;
    DatabaseQuery1.ParamByName('detail').AsString := myText;
    DatabaseQuery1.Execute;
    DatabaseQuery1.SQL.text := 'SELECT LAST_INSERT_ID() AS `rec_no`;';
    DatabaseQuery1.active := true;
    mes_id := DatabaseQuery1.FieldByName('rec_no').AsInteger;
    // ,  

    if myRecipients = '' then
    begin
      //   
      DatabaseQuery1.SQL.text := 'SELECT `user_fio` FROM `uni_users` WHERE `user_fio`<>:sender;';
      DatabaseQuery1.ParamByName('sender').AsString := frmMain.username;
      DatabaseQuery1.active := true;
      while not DatabaseQuery1.Eof do
      begin
        // user found
        DatabaseQuery2.SQL.text :=
          'INSERT INTO `uni_messages` (`sender`,`recipient`,`detail_id`,`send`,`status`) VALUES (:sender,:recipient,:detail_id,now(),0)';
        DatabaseQuery2.ParamByName('sender').AsString := frmMain.username;
        DatabaseQuery2.ParamByName('recipient').AsString := DatabaseQuery1.FieldByName('user_fio').AsString;
        DatabaseQuery2.ParamByName('detail_id').AsString := mes_id.ToString;
        DatabaseQuery2.Execute;
        //
        DatabaseQuery1.Next;
      end;
    end
    else
    begin
      //  
      DatabaseQuery1.SQL.text := 'SELECT `user_fio` FROM `uni_users` WHERE `user_fio`=:recipient;';
      DatabaseQuery1.ParamByName('recipient').AsString := myRecipients;
      DatabaseQuery1.active := true;
      if DatabaseQuery1.RecordCount > 0 then
      begin
        // user found
        DatabaseQuery2.SQL.text :=
          'INSERT INTO `uni_messages` (`sender`,`recipient`,`detail_id`,`send`,`status`) VALUES (:sender,:recipient,:detail_id,now(),0)';
        DatabaseQuery2.ParamByName('sender').AsString := frmMain.username;
        DatabaseQuery2.ParamByName('recipient').AsString := myRecipients;
        DatabaseQuery2.ParamByName('detail_id').AsString := mes_id.ToString;
        DatabaseQuery2.Execute;
      end
      else
        showmessage('  ');
    end;
  end;

end;

procedure TfrmUniversal.UpdateFieldHardwareList(project_no: integer);
var
  lst: string;
begin
  lst := '';
  if DBConnected then
    try
      DatabaseQuery1.SQL.text :=
        'SELECT `name` FROM `uni_projecthardware` WHERE `project_no`=:project_no ORDER BY `orderby`,`rec_no`;';
      DatabaseQuery1.ParamByName('project_no').AsInteger := project_no;
      DatabaseQuery1.active := true;
      while not DatabaseQuery1.Eof do
      begin
        if lst.Length > 0 then
          lst := lst + ',';
        lst := lst + DatabaseQuery1.FieldByName('name').AsString;
        DatabaseQuery1.Next;
      end;

      DatabaseQuery1.SQL.text := 'UPDATE `uni_projects` SET `hardwarelist`=:hardwarelist WHERE `rec_no`=:project_no;';
      DatabaseQuery1.ParamByName('hardwarelist').AsString := lst;
      DatabaseQuery1.ParamByName('project_no').AsInteger := project_no;
      DatabaseQuery1.Execute;

    except
      showmessage('error frmUniversal.UpdateFieldHardwareList');
    end;
end;

function TfrmUniversal.Translit(s: string): string;
const
  rus: string = '';
  lat: array [1 .. 33] of string = ('a', 'b', 'v', 'g', 'd', 'e', 'yo', 'zh', 'z', 'i', 'y', 'k', 'l', 'm', 'n', 'o',
    'p', 'r', 's', 't', 'u', 'f', 'h', 'ts', 'ch', 'sh', 'shch', '_', 'y', '_', 'e', 'yu', 'ya');
var
  p, i, l: integer;
begin
  s := widelowercase(s);
  result := '';
  l := Length(s);
  for i := 1 to l do
  begin
    p := Pos(s[i], rus);
    if p < 1 then
      result := result + s[i]
    else
      result := result + lat[p];
  end;
end;

function TfrmUniversal.RemoveUnusedFile(FileName: string): Boolean;
var
  fnd: Boolean;
  postfix: string;
begin
  //    ,     
  result := false;
  fnd := false;
  postfix := copy(FileName, 1, 2);
  try
    frmUniversal.DatabaseQuery1.SQL.text := 'SELECT `rec_no` from `uni_hardware` WHERE `file`=:file;';
    frmUniversal.DatabaseQuery1.ParamByName('file').AsString := FileName;
    frmUniversal.DatabaseQuery1.active := true;
    if frmUniversal.DatabaseQuery1.RecordCount > 0 then
      fnd := true;

    frmUniversal.DatabaseQuery1.SQL.text := 'SELECT `rec_no` from `uni_projecthardware` WHERE `file`=:file;';
    frmUniversal.DatabaseQuery1.ParamByName('file').AsString := FileName;
    frmUniversal.DatabaseQuery1.active := true;
    if frmUniversal.DatabaseQuery1.RecordCount > 0 then
      fnd := true;

    frmUniversal.DatabaseQuery1.SQL.text := 'SELECT `rec_no` from `uni_projectatt` WHERE `file`=:file;';
    frmUniversal.DatabaseQuery1.ParamByName('file').AsString := FileName;
    frmUniversal.DatabaseQuery1.active := true;
    if frmUniversal.DatabaseQuery1.RecordCount > 0 then
      fnd := true;

    frmUniversal.DatabaseQuery1.SQL.text := 'SELECT `rec_no` from `uni_systemsdetail` WHERE `file`=:file;';
    frmUniversal.DatabaseQuery1.ParamByName('file').AsString := FileName;
    frmUniversal.DatabaseQuery1.active := true;
    if frmUniversal.DatabaseQuery1.RecordCount > 0 then
      fnd := true;

    if not fnd then
    begin
      frmUniversal.DatabaseQuery1.SQL.text := 'DELETE FROM `files_' + postfix + '` WHERE `name`=:file;';
      frmUniversal.DatabaseQuery1.ParamByName('file').AsString := FileName;
      frmUniversal.DatabaseQuery1.ExecSQL;
      result := true;
    end;
  except
  end;
end;

function TfrmUniversal.UpdateProjectFromBase(project_no, system_no: integer; fields: string; price_no: integer)
  : integer;
var
  SQL, s: string;
  Splitted: TArray<String>;
begin
  //           
  result := 0;
  if project_no < 0 then
    exit;

  Splitted := fields.Split([',']);

  //    
  if price_no < 0 then
    try
      SQL := 'UPDATE uni_projecthardware, uni_hardware SET ';
      SQL := SQL + ' uni_projecthardware.lastupdate=now(), uni_projecthardware.username=:username';
      for s in Splitted do
      begin
        SQL := SQL + ', uni_projecthardware.' + s + '=uni_hardware.' + s;
      end;

      SQL := SQL + ' WHERE uni_projecthardware.article=uni_hardware.article';
      SQL := SQL + ' AND uni_projecthardware.project_no=:project_no';

      //  
      if system_no = 0 then
      begin
        //    
        SQL := SQL +
          ' AND (SELECT active FROM uni_projectsystems WHERE uni_projectsystems.rec_no=uni_projecthardware.system_no)';
      end;
      if system_no > 0 then
      begin
        //   
        SQL := SQL + ' AND uni_projecthardware.system_no=' + IntToStr(system_no);
      end;
      SQL := SQL + ' AND uni_hardware.price>0;';

      MyQuery1.SQL.text := SQL;
      MyQuery1.ParamByName('project_no').AsInteger := project_no;
      MyQuery1.ParamByName('username').AsString := frmMain.username;
      //    ,  
      MyQuery1.Execute;
      result := MyQuery1.RowsAffected;

    except
      Clipboard.SetTextBuf(Pchar(SQL));
      showmessage(' .     ');
    end;

  //     
  if price_no > -1 then
    try
      // 'SELECT `name` FROM `uni_pricelist` ORDER BY `dt` DESC;';

      SQL := 'UPDATE uni_projecthardware, uni_prices SET ';
      SQL := SQL + ' uni_projecthardware.lastupdate=now(), uni_projecthardware.username=:username';
      for s in Splitted do
      begin
        SQL := SQL + ', uni_projecthardware.' + s + '=uni_prices.' + s;
      end;

      SQL := SQL + ' WHERE uni_projecthardware.article=uni_prices.article';
      SQL := SQL + ' AND uni_projecthardware.project_no=:project_no AND uni_prices.pricelist=:priceno';

      //  
      if system_no = 0 then
      begin
        //    
        SQL := SQL +
          ' AND (SELECT active FROM uni_projectsystems WHERE uni_projectsystems.rec_no=uni_projecthardware.system_no)';
      end;
      if system_no > 0 then
      begin
        //   
        SQL := SQL + ' AND uni_projecthardware.system_no=' + IntToStr(system_no);
      end;
      SQL := SQL + ' AND uni_prices.price>0;';

      MyQuery1.SQL.text := SQL;
      MyQuery1.ParamByName('project_no').AsInteger := project_no;
      MyQuery1.ParamByName('username').AsString := frmMain.username;
      MyQuery1.ParamByName('priceno').AsInteger := price_no;
      //    ,  
      MyQuery1.Execute;
      result := MyQuery1.RowsAffected;

    except
      Clipboard.SetTextBuf(Pchar(SQL));
      showmessage(' .     ');
    end;

  // RecalcOverpriceForProject(project_no);
end;

Procedure TfrmUniversal.RecalcOverpriceForSystem(system_no: integer);
var
  myQuery: TFDQuery;
  SQL: string;
Begin
  if system_no < 0 then
    exit;

  myQuery := TFDQuery.Create(self);
  myQuery.Connection := DatabaseConnection;

  SQL := '';
  try
    SQL := SQL +
      'UPDATE `uni_projectsystems` SET `price`=(SELECT SUM(price*count) FROM `uni_projecthardware` WHERE `system_no`=:system_no LIMIT 1) WHERE `rec_no`=:system_no;';
     SQL := SQL +
      'UPDATE `uni_projectsystems` SET `total`=`price`*(1+`overprice`/ 100) WHERE `rec_no`=:system_no AND overprice_kind=0;';
     SQL := SQL +
      'UPDATE `uni_projectsystems` SET `total`=`price`+`overprice` WHERE `rec_no`=:system_no AND overprice_kind=1;';

    myQuery.SQL.text := SQL;
    myQuery.ParamByName('system_no').AsInteger := system_no;
    myQuery.ExecSQL;
  except
    showmessage('RecalcOverpriceForSystem ERR');
  end;

  myQuery.free;
  //
End;

Procedure TfrmUniversal.RecalcOverpriceForProject(project_no: integer; activeonly: Boolean);
Begin
  if project_no < 0 then
    exit;

  FDQuery1.SQL.text := 'SELECT `rec_no` FROM uni_projectsystems WHERE project_no=:project_no';
  if activeonly then
    FDQuery1.SQL.text := 'SELECT `rec_no` FROM uni_projectsystems WHERE project_no=:project_no and active=1';
  FDQuery1.ParamByName('project_no').AsInteger := project_no;
  FDQuery1.active := true;
  while not FDQuery1.Eof do
  begin
    UpdateTotalQuery(FDQuery1.FieldByName('rec_no').AsInteger);
    FDQuery1.Next;
  end;
  //
End;

Procedure TfrmUniversal.UpdateTotalQuery(system_no: integer);
begin
  if TotalQuery.IndexOf(system_no.ToString) < 0 then
    TotalQuery.Add(system_no.ToString);

  TimerUpdateTotal.Enabled := false;
  TimerUpdateTotal.Enabled := true;
end;

procedure TfrmUniversal.TimerUpdateTotalTimer(Sender: TObject);
var
  system_no: integer;
begin
  if TotalQuery.Count > 0 then
  begin
    //      
    system_no := -1;
    TryStrToInt(TotalQuery[0], system_no);
    TotalQuery.Delete(0);
    frmUniversal.RecalcOverpriceForSystem(system_no);
    frmMain.caption := ' : ' + TotalQuery.Count.ToString;
  end;

  //    
  if TotalQuery.Count = 0 then
  begin
    TimerUpdateTotal.Enabled := false;
    frmMain.caption := title;

    if (ActiveMDIChild is TfrmProject) then
      (ActiveMDIChild as TfrmProject).TPrSystems.Refresh;
  end;

  // Application.Title := round(Random(999999)).ToString + '/' + TotalQuery.Count.ToString;
end;

procedure TfrmUniversal.StringToHWD(strinp: string; var h, w, d: integer);
var
  cp, m: integer;
  prev: Boolean;
  R: array [1 .. 3] of string;
begin
  //       ' 12x12338'
  if Length(strinp) < 3 then
    exit;

  m := 0;
  prev := false;
  R[1] := '';
  R[2] := '';
  R[3] := '';

  for cp := Length(strinp) downto 0 do
  begin
    if strinp[cp] in ['0' .. '9'] then
    begin
      if not prev then
        Inc(m);
      prev := true;
      if m in [1 .. 3] then
        R[m] := strinp[cp] + R[m];
    end
    else
    begin
      prev := false;
    end;
  end;

  d := 0;
  w := 0;
  h := 0;
  TryStrToInt(R[1], d);
  TryStrToInt(R[2], w);
  TryStrToInt(R[3], h);
end;

Procedure TfrmUniversal.DetectGabaritesForSystem(system_no: integer);
var
  h, w, d: integer;
  ha, wa, da: integer;
  cnt: integer;
  n: string;
Begin
  if system_no < 0 then
    exit;

  ha := 0;
  wa := 0;
  da := 0;

  try
    MyQuery1.SQL.text := 'SELECT `name`,`kinddesc`,`count` FROM `uni_projecthardware` WHERE `system_no`=:system_no';
    MyQuery1.ParamByName('system_no').AsInteger := system_no;
    MyQuery1.active := true;
    while not MyQuery1.Eof do
    begin
      if AnsiLowerCase(MyQuery1.FieldByName('kinddesc').AsString) = '' then
      begin
        n := MyQuery1.FieldByName('name').AsString;
        cnt := MyQuery1.FieldByName('count').AsInteger;
        d := 0;
        w := 0;
        h := 0;
        StringToHWD(n, h, w, d);
        if (h > 0) and (w > 0) and (d > 0) then
        begin
          ha := max(ha, h);
          wa := w * cnt + wa;
          da := max(da, d);
        end;
      end;
      MyQuery1.Next;
    end;

  except
    showmessage('DetectGabaritesForSystem ERR 1');
  end;

  try
    if ha > 0 then
    begin
      MyQuery1.SQL.text :=
        'UPDATE `uni_projectsystems` SET cab_h=:cab_h, cab_w=:cab_w, cab_d=:cab_d WHERE `rec_no`=:system_no';
      MyQuery1.ParamByName('system_no').AsInteger := system_no;
      MyQuery1.ParamByName('cab_h').AsInteger := ha;
      MyQuery1.ParamByName('cab_w').AsInteger := wa;
      MyQuery1.ParamByName('cab_d').AsInteger := da;
      MyQuery1.ExecSQL;
      MyQuery1.Close;
    end;

  except
    showmessage('DetectGabaritesForSystem ERR 2');
  end;

End;

Procedure TfrmUniversal.DetectGabaritesForProject(project_no: integer; activeonly: Boolean);
var
  myQuery: TFDQuery;
Begin
  if project_no < 0 then
    exit;

  myQuery := TFDQuery.Create(self);
  myQuery.Connection := DatabaseConnection;

  myQuery.SQL.text := 'SELECT `rec_no` FROM uni_projectsystems WHERE project_no=:project_no';
  if activeonly then
    myQuery.SQL.text := 'SELECT `rec_no` FROM uni_projectsystems WHERE project_no=:project_no and active=1';
  myQuery.ParamByName('project_no').AsInteger := project_no;
  myQuery.active := true;
  while not myQuery.Eof do
  begin
    DetectGabaritesForSystem(myQuery.FieldByName('rec_no').AsInteger);
    myQuery.Next;
  end;
  //
  myQuery.free;
End;

end.
