unit TotalUpdate;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt, Data.DB,
  FireDAC.Comp.DataSet, FireDAC.Comp.Client, Vcl.StdCtrls, JvExStdCtrls,
  JvButton, JvCtrls, JvFooter, Vcl.ExtCtrls, JvExExtCtrls, JvExtComponent;

type
  TfrmTotalUpdate = class(TForm)
    JvFooter1: TJvFooter;
    btnStop: TJvFooterBtn;
    btnClose: TJvFooterBtn;
    GroupBox1: TGroupBox;
    UpdateGarb: TCheckBox;
    UpdateTotal: TCheckBox;
    FindArea: TGroupBox;
    UpdateCurrent: TRadioButton;
    UpdateActive: TRadioButton;
    UpdateAll: TRadioButton;
    lblInfo: TLabel;
    btnStart: TJvFooterBtn;
    procedure btnOkClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
  private
    project_no, system_no: integer;
    s1, s2, s3: array of integer;
    cp: integer;
    function MustStop(i: integer): boolean;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmTotalUpdate: TfrmTotalUpdate;

implementation

{$R *.dfm}

uses Main, Universal;

procedure TfrmTotalUpdate.btnOkClick(Sender: TObject);
begin
  lblInfo.Caption := '';
end;

procedure TfrmTotalUpdate.btnStartClick(Sender: TObject);
var
  i: integer;
begin
  // frmUniversal.DetectGabaritesForSystem(TPrSystems.FieldByName('rec_no').AsInteger)
  cp := 0;
  btnStart.Enabled := false;
  btnStop.Enabled := true;
  i := 0;

  if UpdateCurrent.Checked then
  begin
    lblInfo.Tag := 1;
    if UpdateGarb.Checked then
      frmUniversal.DetectGabaritesForSystem(s1[0]);
    if MustStop(i) then
      exit;
    if UpdateTotal.Checked then
      frmUniversal.RecalcOverpriceForSystem(s1[0]);
    if MustStop(i) then
      exit;
  end;

  if UpdateActive.Checked then
  begin
    lblInfo.Tag := length(s2);
    for i := 0 to length(s2) - 1 do
    begin
      if UpdateGarb.Checked then
        frmUniversal.DetectGabaritesForSystem(s2[i]);
      if MustStop(i) then
        exit;
      if UpdateTotal.Checked then
        frmUniversal.RecalcOverpriceForSystem(s2[i]);
      if MustStop(i) then
        exit;
    end;
  end;

  if UpdateAll.Checked then
  begin
    lblInfo.Tag := length(s3);
    for i := 0 to length(s3) - 1 do
    begin
      if UpdateGarb.Checked then
        frmUniversal.DetectGabaritesForSystem(s3[i]);
      if MustStop(i) then
        exit;
      if UpdateTotal.Checked then
        frmUniversal.RecalcOverpriceForSystem(s3[i]);
      if MustStop(i) then
        exit;
    end;
  end;

  btnStart.Enabled := true;
  btnStop.Enabled := false;
  lblInfo.Caption := '';
end;

function TfrmTotalUpdate.MustStop(i: integer): boolean;
begin
  lblInfo.Caption := ': ' + (i + 1).ToString + '  ' + lblInfo.Tag.ToString;
  Application.ProcessMessages;
  result := not btnStop.Enabled;
end;

procedure TfrmTotalUpdate.btnStopClick(Sender: TObject);
begin
  btnStart.Enabled := true;
  btnStop.Enabled := false;
  lblInfo.Caption := '';
end;

procedure TfrmTotalUpdate.FormShow(Sender: TObject);
var
  MyQuery: TFDQuery;
  r: integer;
begin
  btnStart.Enabled := true;
  btnStop.Enabled := false;
  lblInfo.Caption := '';
  cp := 0;

  //     
  project_no := frmMain.current_projectno;
  system_no := frmMain.current_projectsystemno;

  if project_no < 0 then
    close;

  try
    setlength(s1, 1);
    s1[0] := system_no;
    setlength(s2, 0);
    setlength(s3, 0);

    MyQuery := TFDQuery.Create(self);
    MyQuery.Connection := frmUniversal.DatabaseConnection;

    MyQuery.SQL.text := 'SELECT `rec_no`,`active` FROM uni_projectsystems WHERE project_no=:project_no';
    MyQuery.ParamByName('project_no').AsInteger := project_no;
    MyQuery.active := true;
    while not MyQuery.Eof do
    begin
      r := MyQuery.FieldByName('rec_no').AsInteger;

      if (MyQuery.FieldByName('active').AsBoolean = true) then
      begin
        setlength(s2, length(s2) + 1);
        s2[length(s2) - 1] := r;
      end;

      setlength(s3, length(s3) + 1);
      s3[length(s3) - 1] := r;

      MyQuery.Next;
    end;
    //
    MyQuery.free;

    UpdateActive.Caption := '   (' + length(s2).ToString + ')';
    UpdateAll.Caption := '   (' + length(s3).ToString + ')';
  except
    UpdateActive.Caption := '  ';
    UpdateAll.Caption := '  ';
    btnStart.Enabled := false;
  end;

end;

end.
