unit TemplateList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, JvExGrids, JvStringGrid, ExtCtrls, FMTBcd, SqlExpr, DB, Menus,
  StdActns, ActnList, JvMenus, DBGrids, JvExDBGrids, JvDBGrid, DBClient,
  Provider, ComCtrls, StdCtrls, JvExControls, JvDBLookup, JvComponentBase,
  JvDBGridExport, JvDialogs, 
   JvExStdCtrls, JvRichEdit, JvDBRichEdit, JvExComCtrls,
  JvComCtrls, Uni, Mask, JvExMask, JvSpin, JvDBSpinEdit, IniFiles;

type
  TfrmTemplates = class(TForm)
    PanelLeft: TPanel;
    TemplateGrid: TJvDBGrid;
    PopupMenu: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    Actions: TActionList;
    actTemplateAdd: TAction;
    actTemplateEdit: TAction;
    actTemplateDelete: TAction;
    MainMenu: TMainMenu;
    N12: TMenuItem;
    mTemplateAdd: TMenuItem;
    mTemplateEdit: TMenuItem;
    mTemplateDelete: TMenuItem;
    StatusBar: TStatusBar;
    PanelRight: TPanel;
    SaveDialog: TJvSaveDialog;
    TTemplate: TFDTable;
    DSTemplate: TDataSource;
    Pages: TJvPageControl;
    TabSheet1: TTabSheet;
    TabSheetCategories: TTabSheet;
    JvDBRichEdit1: TJvDBRichEdit;
    TabSheet6: TTabSheet;
    JvDBRichEdit6: TJvDBRichEdit;
    Panel7: TPanel;
    Panel8: TPanel;
    TabSheetUnits: TTabSheet;
    Panel5: TPanel;
    TabSheet7: TTabSheet;
    JvDBRichEdit7: TJvDBRichEdit;
    JvDBRichEdit2: TJvDBRichEdit;
    Splitter1: TSplitter;
    Panel6: TPanel;
    JvDBRichEdit3: TJvDBRichEdit;
    JvDBRichEdit4: TJvDBRichEdit;
    Splitter2: TSplitter;
    Panel3: TPanel;
    JvDBRichEdit5: TJvDBRichEdit;
    actTemplateDublicate: TAction;
    N4: TMenuItem;
    mTemplateDublicate: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    JvDBSpinEdit1: TJvDBSpinEdit;
    JvDBSpinEdit2: TJvDBSpinEdit;
    actTemplateSave: TAction;
    actTemplateLoad: TAction;
    N8: TMenuItem;
    mTemplateLoad: TMenuItem;
    N9: TMenuItem;
    actLoad2: TMenuItem;
    mTemplateSave: TMenuItem;
    N11: TMenuItem;
    MySQLConnection: TFDConnection;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure actTemplateAddExecute(Sender: TObject);
    procedure actTemplateDeleteExecute(Sender: TObject);
    procedure actTemplateEditExecute(Sender: TObject);
    procedure TTemplateAfterScroll(DataSet: TDataSet);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure actTemplateSaveExecute(Sender: TObject);
  private
    { Private declarations }
  public
    f_captions, f_visible, f_width: TStringList;
    tunnelupload: string;
    procedure ExportToExcel;
    procedure ReTranslate;
    { Public declarations }
  end;

var
  frmTemplates: TfrmTemplates;

implementation

uses Main, TemplateAdd, EffectDelete, EffectEdit, Settings, LanguageSelect;
{$R *.dfm}

procedure TfrmTemplates.FormActivate(Sender: TObject);
begin
  if frmMain.firstwindow then
  begin
    WindowState := wsMaximized;
    frmMain.firstwindow := false;
  end;
end;

procedure TfrmTemplates.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TfrmTemplates.FormCreate(Sender: TObject);
begin
  f_captions := TStringList.Create;
  f_visible := TStringList.Create;
  f_width := TStringList.Create;
end;

procedure TfrmTemplates.FormDestroy(Sender: TObject);
begin
  f_captions.Free;
  f_visible.Free;
  f_width.Free;
end;

procedure TfrmTemplates.FormShow(Sender: TObject);
begin
  try
    MySQLConnection.Database := frmSettings.Database;
    MySQLConnection.username := frmSettings.username;
    MySQLConnection.server := frmSettings.server;
    MySQLConnection.password := frmSettings.password;
    MySQLConnection.port := frmSettings.port;
    MySQLConnection.Options.Charset := frmSettings.Charset;
    MySQLConnection.Options.UseUnicode := frmSettings.Unicode;
    if frmSettings.ConnectKind = 1 then
    begin
      MySQLConnection.HttpOptions.username := frmSettings.tunnelusername;
      MySQLConnection.HttpOptions.password := frmSettings.tunnelpassword;
      MySQLConnection.HttpOptions.url := frmSettings.tunnelmysql;
      MySQLConnection.Options.Protocol := mpHttp;
    end
    else
    begin
      MySQLConnection.Options.Protocol := mpDefault;
    end;
    tunnelupload := frmSettings.tunnelupload;
    MySQLConnection.Connected := true;
  except
    showmessage('     .  ');
    Close;
  end;

  if MySQLConnection.Connected then
    try
      PanelLeft.Visible := true;
      PanelRight.Visible := true;
      TTemplate.Active := true;
    except
      showmessage('   ');
      Close;
    end;
end;

procedure TfrmTemplates.TTemplateAfterScroll(DataSet: TDataSet);
var
  rec_no: integer;
begin
  if TTemplate.Active then
  begin
    rec_no := TTemplate.FieldByName('rec_no').AsInteger;
    StatusBar.Panels[0].Text := inttostr(rec_no);
  end;
end;

procedure TfrmTemplates.actTemplateAddExecute(Sender: TObject);
var
  Description: string;
begin
  if frmTemplateAdd.ShowModal = mrOk then
  begin
    Description := frmTemplateAdd.Description.Text;
    TTemplate.Append;
    TTemplate.FieldByName('name').AsString := Description;
    TTemplate.Post;
    TTemplate.Refresh;
  end;
end;

procedure TfrmTemplates.actTemplateDeleteExecute(Sender: TObject);
begin
  if frmEffectDelete.ShowModal = mrOk then
  begin
    TTemplate.Delete;
    TTemplate.Refresh;
  end;
end;

procedure TfrmTemplates.actTemplateEditExecute(Sender: TObject);
begin
  frmEffectEdit.Description.Text := TTemplate.FieldByName('name').AsString;
  if frmEffectEdit.ShowModal = mrOk then
  begin
    TTemplate.Edit;
    TTemplate.FieldByName('name').AsString := frmEffectEdit.Description.Text;
    TTemplate.Post;
  end;
end;

procedure TfrmTemplates.actTemplateSaveExecute(Sender: TObject);
var
  i, z: integer;
  fn: string;
  f_exp: TIniFile;
  f_name: string;
  f_str: TstringStream;
begin
  if SaveDialog.Execute then
  begin
    fn := SaveDialog.FileName;
    f_exp := TIniFile.Create(fn);
    for i := 0 to TemplateGrid.SelectedRows.Count - 1 do
    begin
      TemplateGrid.DataSource.DataSet.Bookmark := TemplateGrid.SelectedRows[i];
      f_name := TTemplate.FieldByName('name').AsString;
      for z := 0 to TTemplate.FieldCount - 1 do
      begin
        // f_str := TstringStream.Create(TTemplate.Fields[z].AsString);
        // f_exp.WriteBinaryStream(f_name, TTemplate.Fields[z].FullName, f_str);
        f_exp.WriteString(f_name, TTemplate.Fields[z].FullName,
          TTemplate.Fields[z].AsString);
        // f_str.Free;
      end;
    end;
  end;
end;

procedure TfrmTemplates.ExportToExcel;
begin
  if TTemplate.Active then
  begin
    if SaveDialog.Execute() then
      try
        { JvDBGridExcelExport1.FileName := SaveDialog.FileName;
          JvDBGridExcelExport1.ExportGrid; }
      except
      end;
  end
  else
    showmessage('   ');
end;

procedure TfrmTemplates.ReTranslate;
var
  i: Integer;
begin
  Caption := frmSettings.projectname + ' / ' + frmLanguageSelect.TranslateString
    ('frmUsers', '');
  frmLanguageSelect.TranslateForm(self);

  { // Tables
    for i := 0 to CatalogUnits.Columns.Count - 1 do
    CatalogUnits.Columns[i].Title.Caption := frmLanguageSelect.TranslateString
    ('CatalogUnits_' + inttostr(i), CatalogUnits.Columns[i].Title.Caption);
  }
end;

end.
