Unit SystemsOpts;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Grids, DBGrids, JvExDBGrids, JvDBGrid, DB,
  Menus, JvMenus, ActnList, Vcl.ExtCtrls, Vcl.StdCtrls,
  System.Actions, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.Client, FireDAC.Comp.DataSet;

Type
  TfrmSystemsOpt = Class(TForm)
    TemplateGrid: TJvDBGrid;
    StatusBar: TStatusBar;
    DSTemlate: TDataSource;
    TTemplate: TFDTable;
    PopupMenu: TPopupMenu;
    N1: TMenuItem;
    Actions: TActionList;
    actDeleteRecord: TAction;
    N2: TMenuItem;
    N3: TMenuItem;
    PanelTop: TPanel;
    Label1: TLabel;
    KindList: TComboBox;
    actAdd: TAction;
    actEdit: TAction;
    actAdd1: TMenuItem;
    N4: TMenuItem;
    MyQuery1: TFDQuery;
    Procedure FormShow(Sender: TObject);
    Procedure N1Click(Sender: TObject);
    Procedure actDeleteRecordExecute(Sender: TObject);
    Procedure actDeleteRecordUpdate(Sender: TObject);
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    procedure KindListChange(Sender: TObject);
    procedure actEditUpdate(Sender: TObject);
    procedure actEditExecute(Sender: TObject);
    procedure actAddExecute(Sender: TObject);
    procedure TemplateGridDblClick(Sender: TObject);
  Private
    procedure UpdateKindList;
    { Private declarations }
  Public
    { Public declarations }
  End;

Var
  frmSystemsOpt: TfrmSystemsOpt;

Implementation

Uses Main, SystemsOptAdd, KindSystems, Universal;

{$R *.dfm}

Procedure TfrmSystemsOpt.actDeleteRecordExecute(Sender: TObject);
Begin
  TTemplate.Delete;
End;

Procedure TfrmSystemsOpt.actDeleteRecordUpdate(Sender: TObject);
Begin
  actDeleteRecord.Enabled := (frmMain.usergroup.Length > 9) and TTemplate.Active And (TTemplate.RecNo > 0) and
    (TTemplate.RecordCount > 0);
End;

procedure TfrmSystemsOpt.actEditUpdate(Sender: TObject);
begin
  actEdit.Enabled := (frmMain.usergroup.Length > 9) and TTemplate.Active And (TTemplate.RecNo > 0) and
    (TTemplate.RecordCount > 0);
end;

Procedure TfrmSystemsOpt.FormClose(Sender: TObject; Var Action: TCloseAction);
Begin
  TTemplate.Active := false;
End;

Procedure TfrmSystemsOpt.FormShow(Sender: TObject);
Begin

  if not frmUniversal.DBConnected then
    close;

  Try
    // THardware.Active := true;
    TTemplate.Active := true;
  Except
    showmessage('   ?');
    // Close;
  End;
  //
  UpdateKindList;
End;

procedure TfrmSystemsOpt.KindListChange(Sender: TObject);
begin
  //
  if (KindList.Text = '') then
  begin
    TTemplate.Filtered := false;
  end
  else
  begin
    TTemplate.Filtered := true;
    TTemplate.Filter := 'kind=' + QuotedStr(KindList.Text);
    TTemplate.Refresh;
  end;
end;

Procedure TfrmSystemsOpt.UpdateKindList;
Begin
  KindList.Items.Clear;
  try
    MyQuery1.SQL.Text := 'SELECT `kind` FROM `uni_systemstemplates` GROUP BY `kind`';
    MyQuery1.Active := true;
    while not MyQuery1.eof do
    begin
      KindList.Items.add(MyQuery1.Fields[0].AsString);
      MyQuery1.next;
    end;
  except
  end;
End;

Procedure TfrmSystemsOpt.N1Click(Sender: TObject);
Begin
  UpdateKindList;
  TTemplate.Active := true;
  TTemplate.Refresh;
End;

procedure TfrmSystemsOpt.TemplateGridDblClick(Sender: TObject);
begin
  actEdit.Execute;
end;

procedure TfrmSystemsOpt.actEditExecute(Sender: TObject);
begin
  frmSystemsOptAdd.kind.Text := TTemplate.FieldByName('kind').AsString;
  frmSystemsOptAdd.name.Text := TTemplate.FieldByName('name').AsString;
  frmSystemsOptAdd.temlate_id.Text := TTemplate.FieldByName('temlate_id').AsString;
  frmSystemsOptAdd.autofill.Text := TTemplate.FieldByName('autofill').AsString;
  if frmSystemsOptAdd.ShowModal = mrOk then
    try
      TTemplate.Edit;
      TTemplate.FieldByName('kind').AsString := frmSystemsOptAdd.kind.Text;
      TTemplate.FieldByName('name').AsString := frmSystemsOptAdd.name.Text;
      TTemplate.FieldByName('temlate_id').AsString := frmSystemsOptAdd.temlate_id.Text;
      TTemplate.FieldByName('autofill').AsString := frmSystemsOptAdd.autofill.Text;
      TTemplate.Post;
    except
    end;
end;

procedure TfrmSystemsOpt.actAddExecute(Sender: TObject);
begin
  frmSystemsOptAdd.kind.Text := KindList.Text;
  frmSystemsOptAdd.name.Text := '';
  frmSystemsOptAdd.temlate_id.Text := '#???#';
  frmSystemsOptAdd.autofill.Text := '';
  if frmSystemsOptAdd.ShowModal = mrOk then
    try
      TTemplate.Append;
      TTemplate.FieldByName('kind').AsString := frmSystemsOptAdd.kind.Text;
      TTemplate.FieldByName('name').AsString := frmSystemsOptAdd.name.Text;
      TTemplate.FieldByName('temlate_id').AsString := frmSystemsOptAdd.temlate_id.Text;
      TTemplate.FieldByName('autofill').AsString := frmSystemsOptAdd.autofill.Text;
      TTemplate.Post;
    except
    end;
end;

End.
