Unit SystemsAdd;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls,
  JvExExtCtrls, JvExtComponent, ActnList, Mask, JvExMask, JvSpin, JvEdit,
  System.Actions, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, Data.DB, FireDAC.Comp.DataSet,
  FireDAC.Comp.Client, Vcl.ComCtrls, Vcl.Samples.Spin, System.Math;

Type
  TfrmSystemsAdd = Class(TForm)
    footer: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    Label1: TLabel;
    JvFooterBtn3: TJvFooterBtn;
    QuerySRC: TFDQuery;
    TimerAutoFill: TTimer;
    JvFooterBtn2: TJvFooterBtn;
    UseActive: TCheckBox;
    Label6: TLabel;
    Label2: TLabel;
    GroupParameters: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    current: TEdit;
    strength: TEdit;
    entries: TEdit;
    protection: TEdit;
    kind: TComboBox;
    construction: TComboBox;
    voltage_secondary: TComboBox;
    voltage: TComboBox;
    GroupNumbers: TGroupBox;
    zav_pre: TEdit;
    zav_post: TEdit;
    GroupCab: TGroupBox;
    cab_w: TEdit;
    cab_d: TEdit;
    cab_h: TEdit;
    Label12: TLabel;
    PassportDate: TDateTimePicker;
    Label13: TLabel;
    rb_percents: TRadioButton;
    rb_abs: TRadioButton;
    zav: TEdit;
    OverPrice: TSpinEdit;
    Counter: TSpinEdit;
    QueryInfo: TFDQuery;
    editName: TComboBox;
    QueryDST: TFDQuery;
    editTag: TComboBox;
    HardCounterLabel: TLabel;
    HardCounter: TSpinEdit;
    TimerCheck: TTimer;
    Procedure actOkExecute(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
    Procedure JvFooterBtn3Click(Sender: TObject);
    procedure EditEnter(Sender: TObject);
    procedure editNameChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure kindChange(Sender: TObject);
    procedure TimerAutoFillTimer(Sender: TObject);
    procedure JvFooterBtn2Click(Sender: TObject);
    procedure TimerCheckTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  Private
    procedure NameChange;
    procedure FillKinds;
    function GetMaxOrderBy: integer;
    procedure ShowCaption;
    function TableToTitle(tablename: string): string;
    procedure CopyHardware(Multiply: integer);
    procedure ShowDataFromBase;
    procedure ShowDataFromProject;
    procedure DoCreate(count: integer);
    procedure DoEdit(count: integer);
    function CreateNotExists: string;
    procedure MultiplyEnable(xmode: boolean);
    { Private declarations }
  Public
    SystemsList: TStrings;
    TagList: TStrings;
    CurrentName, CurrentTag: string;
    set_orderby: integer;
    Project_no: integer;
    //  
    SRC_tablename, DST_tablename: string;
    //  ,   
    SRC_systemno, DST_systemno: integer;
    //     " + "
    DST_systemno_user: integer;
    operation: string;
    Procedure Clear;
    procedure SystemsListRebuild;
    { Public declarations }
  End;

Var
  frmSystemsAdd: TfrmSystemsAdd;

Implementation

{$R *.dfm}

uses Main;

Procedure TfrmSystemsAdd.Clear;
Begin
  editName.items.Clear;
  editTag.items.Clear;
  //
  CurrentName := '';
  Counter.Value := 1;
  editName.Text := '';
  editTag.Text := '';
  construction.Text := '';
  kind.Text := '';
  voltage.Text := '';
  current.Text := '';
  protection.Text := '';
  entries.Text := '';
  strength.Text := '';
  voltage_secondary.Text := '';
  UseActive.Checked := true;
  OverPrice.Value := 0;
  cab_w.Text := '';
  cab_h.Text := '';
  cab_d.Text := '';
  zav_pre.Text := '';
  zav.Text := '';
  zav_post.Text := '';
  rb_percents.Checked := true;
  rb_abs.Checked := false;
  PassportDate.DateTime := now;
End;

Procedure TfrmSystemsAdd.FormActivate(Sender: TObject);
Begin
  editName.SetFocus;
  FillKinds;
End;

procedure TfrmSystemsAdd.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  TimerCheck.Enabled := false;
end;

procedure TfrmSystemsAdd.FormCreate(Sender: TObject);
begin
  SRC_tablename := 'uni_systems';
  DST_tablename := 'uni_systems';
  SystemsList := TStringList.Create;
  TagList := TStringList.Create;
end;

procedure TfrmSystemsAdd.FormDestroy(Sender: TObject);
begin
  SystemsList.Free;
  TagList.Free;
end;

function TfrmSystemsAdd.GetMaxOrderBy: integer;
begin
  result := 0;
  if Project_no < 0 then
    exit;

  QueryInfo.SQL.Text := 'SELECT max(`orderby`) as mx FROM uni_projectsystems WHERE `project_no`=' + IntToStr(Project_no)
    + ' ORDER BY `orderby`';
  QueryInfo.Active := true;
  result := QueryInfo.FieldByName('mx').AsInteger;
  QueryInfo.Active := false;
end;

procedure TfrmSystemsAdd.JvFooterBtn2Click(Sender: TObject);
begin
  TimerAutoFill.Enabled := false;
  TimerAutoFill.Enabled := true;
end;

Procedure TfrmSystemsAdd.JvFooterBtn3Click(Sender: TObject);
Begin
  Clear;
End;

procedure TfrmSystemsAdd.kindChange(Sender: TObject);
begin
  if Pos('', Caption) > 0 then
  begin
    TimerAutoFill.Enabled := false;
    TimerAutoFill.Enabled := true;
  end;
end;

procedure TfrmSystemsAdd.EditEnter(Sender: TObject);
begin
  if Sender is TEdit then
    (Sender as TEdit).SelectAll;
end;

procedure TfrmSystemsAdd.editNameChange(Sender: TObject);
begin
  //    
  TimerCheck.Enabled := false;
  if (operation = 'copy') or (operation = 'add') then
  begin
    TimerCheck.Enabled := true;
  end;
end;

procedure TfrmSystemsAdd.NameChange;
var
  i: integer;
  fnd: boolean;
  res: boolean;
begin
  res := true;

  if DST_tablename = 'uni_projectsystems' then
  begin
    QueryInfo.SQL.Text :=
      'SELECT `rec_no` FROM `uni_projectsystems` WHERE `project_no`=:project_no AND name=:name AND tag=:tag;';
    QueryInfo.ParamByName('project_no').AsInteger := Project_no;
    QueryInfo.ParamByName('name').AsString := trim(editName.Text);
    QueryInfo.ParamByName('tag').AsString := trim(editTag.Text);
    QueryInfo.Active := true;
    if QueryInfo.RecordCount > 0 then
    begin
      DST_systemno := QueryInfo.FieldByName('rec_no').AsInteger;
      if operation = 'add' then
        res := false;
    end
    else
    begin
      DST_systemno := -1;
    end;
    ShowCaption;
  end;

  if trim(editName.Text) = '' then
    res := false;

  if (operation = 'edit') and (DST_systemno < 0) then
    res := false;

  btnOk.Enabled := res;

end;

procedure TfrmSystemsAdd.SystemsListRebuild;
var
  n, t: string;
begin
  SystemsList.Clear;
  TagList.Clear;
  try
    QueryInfo.SQL.Text :=
      'SELECT `name`,`tag` FROM `uni_projectsystems` WHERE `project_no`=:project_no ORDER BY `orderby`;';
    QueryInfo.ParamByName('project_no').AsInteger := Project_no;
    QueryInfo.Active := true;
    while not QueryInfo.Eof do
    begin
      n := QueryInfo.FieldByName('name').AsString.trim;
      if SystemsList.IndexOf(n) < 0 then
        if length(n) > 0 then
          SystemsList.Add(n);
      t := QueryInfo.FieldByName('tag').AsString.trim;
      if TagList.IndexOf(t) < 0 then
        if length(t) > 0 then
          TagList.Add(t);
      QueryInfo.Next;
    end;
  except
  end;
end;

Procedure TfrmSystemsAdd.CopyHardware(Multiply: integer);
Var
  // SQL, flds, pars: String;
  orderby: integer;
Begin
  if DST_systemno < 0 then
    exit;

  if Multiply < 1 then
    exit;

  //         
  try
  orderby := 0;
  if (DST_systemno > -1) and (DST_tablename = 'uni_projectsystems') then
    begin
      QueryDST.SQL.Text :=
        'SELECT max(`orderby`) FROM `uni_projecthardware` WHERE `system_no`=:system_no AND `project_no`=:project_no';
      QueryDST.ParamByName('project_no').AsInteger := Project_no;
      QueryDST.ParamByName('system_no').AsInteger := DST_systemno;
      QueryDST.Active := true;
      if QueryDST.RecordCount > 0 then
      begin
        orderby := max(orderby, QueryDST.Fields[0].AsInteger);
      end;
    end;

  //
  if SRC_tablename = 'uni_systems' then
  begin
    QuerySRC.SQL.Text :=
      'SELECT name,kinddesc,article,comment,developer,file,price,valuta,count,modules,modules*18 as modules2 FROM `uni_systemsdetail` WHERE `system_no`=:system_no ORDER BY `orderby`;';
    QuerySRC.ParamByName('system_no').AsInteger := SRC_systemno;
    QuerySRC.Active := true;
  end;

  if SRC_tablename = 'uni_projectsystems' then
  begin
    QuerySRC.SQL.Text :=
      'SELECT name,kinddesc,article,comment,developer,file,price,valuta,count,modules,modules2 FROM `uni_projecthardware` WHERE `system_no`=:system_no ORDER BY `orderby`;';
    QuerySRC.ParamByName('system_no').AsInteger := SRC_systemno;
    QuerySRC.Active := true;
  end;

  if DST_tablename = 'uni_systems' then
  begin
    if QuerySRC.RecordCount > 0 then
    begin
      // try
      QueryDST.Connection.StartTransaction;
      while not QuerySRC.Eof do
      begin
        inc(orderby);
        QueryDST.SQL.Text :=
          'INSERT INTO `uni_systemsdetail` (orderby,system_no,name,kinddesc,article,comment,developer,file,price,valuta,count,modules,modules2)'
          + ' VALUES (:orderby,:system_no,:name,:kinddesc,:article,:comment,:developer,:file,:price,:valuta,:count,:modules,:modules2);';
        QueryDST.ParamByName('orderby').AsInteger := orderby;
        QueryDST.ParamByName('system_no').AsInteger := DST_systemno;
        QueryDST.ParamByName('name').AsString := QuerySRC.FieldByName('name').AsString;
        QueryDST.ParamByName('kinddesc').AsString := QuerySRC.FieldByName('kinddesc').AsString;
        QueryDST.ParamByName('article').AsString := QuerySRC.FieldByName('article').AsString;
        QueryDST.ParamByName('developer').AsString := QuerySRC.FieldByName('developer').AsString;
        QueryDST.ParamByName('comment').AsString := QuerySRC.FieldByName('comment').AsString;
        QueryDST.ParamByName('file').AsString := QuerySRC.FieldByName('file').AsString;
        QueryDST.ParamByName('price').Value := QuerySRC.FieldByName('price').Value;
        QueryDST.ParamByName('valuta').AsString := QuerySRC.FieldByName('valuta').AsString;
        QueryDST.ParamByName('count').AsInteger := QuerySRC.FieldByName('count').AsInteger * Multiply;
        QueryDST.ParamByName('modules').Value := QuerySRC.FieldByName('modules').Value;
        QueryDST.ParamByName('modules2').Value := QuerySRC.FieldByName('modules2').Value;
        QueryDST.ExecSQL;

        QuerySRC.Next;
      end;
      QueryDST.Connection.Commit;
      QueryDST.Close;
      // except
      // ShowMessage(' frmSystemsAdd.CopyHardware 3');
      // end;
    end;
  end;

  if DST_tablename = 'uni_projectsystems' then
  begin
    if QuerySRC.RecordCount > 0 then
    begin
      // try
      QueryDST.Connection.StartTransaction;
      while not QuerySRC.Eof do
      begin
        inc(orderby);
        QueryDST.SQL.Text :=
          'INSERT INTO `uni_projecthardware` (orderby,project_no,system_no,name,kinddesc,article,comment,developer,file,price,valuta,count,modules,modules2)'
          + ' VALUES (:orderby,:project_no,:system_no,:name,:kinddesc,:article,:comment,:developer,:file,:price,:valuta,:count,:modules,:modules2);';
        QueryDST.ParamByName('orderby').AsInteger := orderby;
        QueryDST.ParamByName('project_no').AsInteger := Project_no;
        QueryDST.ParamByName('system_no').AsInteger := DST_systemno;
        QueryDST.ParamByName('name').AsString := QuerySRC.FieldByName('name').AsString;
        QueryDST.ParamByName('kinddesc').AsString := QuerySRC.FieldByName('kinddesc').AsString;
        QueryDST.ParamByName('article').AsString := QuerySRC.FieldByName('article').AsString;
        QueryDST.ParamByName('developer').AsString := QuerySRC.FieldByName('developer').AsString;
        QueryDST.ParamByName('comment').AsString := QuerySRC.FieldByName('comment').AsString;
        QueryDST.ParamByName('file').AsString := QuerySRC.FieldByName('file').AsString;
        QueryDST.ParamByName('price').AsString := QuerySRC.FieldByName('price').AsString;
        QueryDST.ParamByName('valuta').AsString := QuerySRC.FieldByName('valuta').AsString;
        QueryDST.ParamByName('count').AsInteger := QuerySRC.FieldByName('count').AsInteger * Multiply;
        QueryDST.ParamByName('modules').Value := QuerySRC.FieldByName('modules').Value;
        QueryDST.ParamByName('modules2').Value := QuerySRC.FieldByName('modules2').Value;
        QueryDST.ExecSQL;

        QuerySRC.Next;
      end;
      QueryDST.Connection.Commit;
      QueryDST.Close;
    end;
  end;

       except
      ShowMessage(' frmSystemsAdd.CopyHardware');
      end;

End;

procedure TfrmSystemsAdd.TimerAutoFillTimer(Sender: TObject);
const
  _kind: array [0 .. 6] of string = ('', '', '', '', '', '', '');
  _construction: array [0 .. 6] of string = ('', '', '', '', '',
    '', '');
  _voltage: array [0 .. 6] of string = ('380', '380', '380', '380', '220', '380', '380');
  _current: array [0 .. 6] of string = ('1000', '630', '63', '63', '63', '63', '250');
  _protection: array [0 .. 6] of string = ('20/00', '31', '31', '31', '41', '54', '54');
  _entries: array [0 .. 6] of string = ('2', '2', '1', '1', '1', '1', '1');
  _voltage_secondary: array [0 .. 6] of string = ('220', '220', '', '', '', '220', '220');
  _strength: array [0 .. 6] of string = ('16', '16', '4,5', '4,5', '4,5', '4,5', '16');
var
  i: integer;
begin
  //   
  TimerAutoFill.Enabled := false;

  {
    i := kind.Items.IndexOf(kind.Text);
    if i > -1 then
    begin
    construction.Text := _construction[i];
    voltage.Text := _voltage[i];
    current.Text := _current[i];
    protection.Text := _protection[i];
    entries.Text := _entries[i];
    strength.Text := _strength[i];
    end;
  }

  try
    QueryInfo.SQL.Text := 'SELECT * FROM `uni_systemstemplates` WHERE `kind`=:kind';
    QueryInfo.ParamByName('kind').AsString := trim(kind.Text);
    QueryInfo.Active := true;
    while not QueryInfo.Eof do
    begin
      construction.Text := QueryInfo.FieldByName('construction').AsString;
      voltage.Text := QueryInfo.FieldByName('voltage').AsString;
      current.Text := QueryInfo.FieldByName('current').AsString;
      protection.Text := QueryInfo.FieldByName('protection').AsString;
      entries.Text := QueryInfo.FieldByName('entries').AsString;
      strength.Text := QueryInfo.FieldByName('strength').AsString;
      voltage_secondary.Text := QueryInfo.FieldByName('voltage_secondary').AsString;
      QueryInfo.Next;
    end;
  except
  end;

end;

procedure TfrmSystemsAdd.TimerCheckTimer(Sender: TObject);
begin
  NameChange;
end;

procedure TfrmSystemsAdd.FillKinds;
begin
  kind.items.Clear;
  try
    QueryInfo.SQL.Text := 'SELECT `kind` FROM `uni_systemstemplates` GROUP BY `kind`';
    QueryInfo.Active := true;
    while not QueryInfo.Eof do
    begin
      kind.items.Add(QueryInfo.Fields[0].AsString);
      QueryInfo.Next;
    end;
  except
  end;
end;

function TfrmSystemsAdd.TableToTitle(tablename: string): string;
begin
  result := '';
  if tablename = 'uni_projectsystems' then
    result := ' ' + Project_no.ToString;
  if tablename = 'uni_systems' then
    result := '';
end;

procedure TfrmSystemsAdd.ShowCaption;
var
  title: string;
  SRC_title, DST_title: string;
begin
  //   
  title := '';

  if operation = 'edit' then
  begin
    title := ' . ';
    title := title + TableToTitle(DST_tablename) + ' (' + DST_systemno.ToString + ')';
  end;

  if operation = 'copy' then
  begin
    title := ' . ';
    title := title + TableToTitle(SRC_tablename) + ' (' + SRC_systemno.ToString + ') > ';
    title := title + TableToTitle(DST_tablename) + ' (' + DST_systemno.ToString + ')';
  end;

  if operation = 'add' then
  begin
    title := ' . ';
    title := title + TableToTitle(DST_tablename);
  end;

  Caption := title;
end;

procedure TfrmSystemsAdd.ShowDataFromBase;
begin
  //    uni_systems
  QuerySRC.SQL.Text := 'SELECT * FROM uni_systems WHERE `rec_no`=:system_no;';
  QuerySRC.ParamByName('system_no').AsInteger := SRC_systemno;
  QuerySRC.Active := true;
  if QuerySRC.RecordCount < 1 then
    exit;

  //   
  CurrentName := QuerySRC.FieldByName('name').AsString;
  editName.Text := QuerySRC.FieldByName('name').AsString;
  CurrentTag := QuerySRC.FieldByName('tag').AsString;
  editTag.Text := QuerySRC.FieldByName('tag').AsString;
  construction.Text := QuerySRC.FieldByName('construction').AsString;
  kind.Text := QuerySRC.FieldByName('kind').AsString;
  voltage.Text := QuerySRC.FieldByName('voltage').AsString;
  current.Text := QuerySRC.FieldByName('current').AsString;
  protection.Text := QuerySRC.FieldByName('protection').AsString;
  entries.Text := QuerySRC.FieldByName('entries').AsString;
  voltage_secondary.Text := QuerySRC.FieldByName('voltage_secondary').AsString;
  strength.Text := QuerySRC.FieldByName('strength').AsString;

  OverPrice.Value := QuerySRC.FieldByName('overprice').AsInteger;
  PassportDate.DateTime := QuerySRC.FieldByName('zav_date').AsDateTime;
  zav_pre.Text := QuerySRC.FieldByName('zav_pre').AsString;
  zav.Text := QuerySRC.FieldByName('zav').AsString;
  zav_post.Text := QuerySRC.FieldByName('zav_post').AsString;
  cab_h.Text := QuerySRC.FieldByName('cab_h').AsString;
  cab_w.Text := QuerySRC.FieldByName('cab_w').AsString;
  cab_d.Text := QuerySRC.FieldByName('cab_d').AsString;

  rb_percents.Checked := (QuerySRC.FieldByName('overprice_kind').AsInteger = 0);
  rb_abs.Checked := (QuerySRC.FieldByName('overprice_kind').AsInteger = 1);
end;

procedure TfrmSystemsAdd.ShowDataFromProject;
begin
  //    uni_projectsystems
  QuerySRC.SQL.Text := 'SELECT * FROM uni_projectsystems WHERE `project_no`=:project_no AND `rec_no`=:system_no;';
  QuerySRC.ParamByName('project_no').AsInteger := Project_no;
  QuerySRC.ParamByName('system_no').AsInteger := SRC_systemno;
  QuerySRC.Active := true;
  if QuerySRC.RecordCount < 1 then
    exit;

  //     
  Counter.Value := QuerySRC.FieldByName('count').AsInteger;
  UseActive.Checked := QuerySRC.FieldByName('active').AsBoolean;
  set_orderby := QuerySRC.FieldByName('orderby').AsInteger;
  //   
  editName.Text := QuerySRC.FieldByName('name').AsString;
  CurrentName := editName.Text;
  construction.Text := QuerySRC.FieldByName('construction').AsString;
  kind.Text := QuerySRC.FieldByName('kind').AsString;
  voltage.Text := QuerySRC.FieldByName('voltage').AsString;
  current.Text := QuerySRC.FieldByName('current').AsString;
  protection.Text := QuerySRC.FieldByName('protection').AsString;
  entries.Text := QuerySRC.FieldByName('entries').AsString;
  voltage_secondary.Text := QuerySRC.FieldByName('voltage_secondary').AsString;
  strength.Text := QuerySRC.FieldByName('strength').AsString;
  editTag.Text := QuerySRC.FieldByName('tag').AsString;
  CurrentTag := editTag.Text;

  OverPrice.Value := QuerySRC.FieldByName('overprice').AsInteger;
  PassportDate.DateTime := QuerySRC.FieldByName('zav_date').AsDateTime;
  zav_pre.Text := QuerySRC.FieldByName('zav_pre').AsString;
  zav.Text := QuerySRC.FieldByName('zav').AsString;
  zav_post.Text := QuerySRC.FieldByName('zav_post').AsString;
  cab_h.Text := QuerySRC.FieldByName('cab_h').AsString;
  cab_w.Text := QuerySRC.FieldByName('cab_w').AsString;
  cab_d.Text := QuerySRC.FieldByName('cab_d').AsString;

  rb_percents.Checked := (QuerySRC.FieldByName('overprice_kind').AsInteger = 0);
  rb_abs.Checked := (QuerySRC.FieldByName('overprice_kind').AsInteger = 1);

end;

procedure TfrmSystemsAdd.FormShow(Sender: TObject);
var
  i: integer;
begin
  btnOk.Enabled := true;
  frmSystemsAdd.Height := 480;
  //  
  Clear;
  SystemsListRebuild;
  set_orderby := 0;

  //    ,  
  try
    if (SRC_tablename = 'uni_systems') and (SRC_systemno > -1) then
      ShowDataFromBase;
    if (SRC_tablename = 'uni_projectsystems') and (Project_no > -1) and (SRC_systemno > -1) then
      ShowDataFromProject;
    editName.items.Add(editName.Text);
    editTag.items.Add(editTag.Text);
  except
    ShowMessage('  ');
  end;

  editName.items.AddStrings(SystemsList);
  for i := 0 to SystemsList.count - 1 do
  begin
    if editName.items.IndexOf(SystemsList[i]) < 0 then
      editName.items.Add(SystemsList[i]);
  end;

  editTag.items.AddStrings(TagList);
  for i := 0 to TagList.count - 1 do
  begin
    if editTag.items.IndexOf(TagList[i]) < 0 then
      editTag.items.Add(TagList[i]);
  end;

  MultiplyEnable(false);
  if (SRC_tablename = DST_tablename) and (SRC_systemno = DST_systemno) then
  begin
    operation := 'edit';
  end
  else if SRC_tablename <> '' then
  begin
    operation := 'copy';
    //     
    MultiplyEnable(true);
  end
  else if DST_systemno < 0 then
  begin
    operation := 'add';
  end;

  ShowCaption; //   

  if (SRC_tablename = 'uni_systems') and (DST_tablename = 'uni_projectsystems') then
  begin
    editName.Text := frmMain.current_projectsystemname;
    editTag.Text := frmMain.current_projectsystemtag;
    //  
    frmSystemsAdd.Height := 145;
  end;

  // 
  if PassportDate.DateTime < now - 3650 then
    PassportDate.DateTime := now;

  NameChange;
end;

Procedure TfrmSystemsAdd.actOkExecute(Sender: TObject);
var
  count: integer;
  r: string;
Begin
  editName.Text := trim(editName.Text);
  editTag.Text := trim(editTag.Text);
  If (length(editName.Text) = 0) Then
    exit;

  btnOk.Enabled := false;

  if (Project_no > -1) then
    set_orderby := GetMaxOrderBy + 1;

  if (operation = 'edit') then
  begin
    //  
    DoEdit(Counter.Value);
  end;

  if (operation = 'copy') then
  begin
    // 
    //   
    if (DST_systemno > -1) then
      if (MessageDlg(' .    ?', mtCustom, [mbYes, mbCancel], 0) <> mrYes) then
        exit;

    if (SRC_tablename = DST_tablename) AND (SRC_systemno = DST_systemno) then
    begin
      ShowMessage('   .   ');
      exit;
    end;

    r := CreateNotExists;

    if (r = 'cancel') then
    begin
      btnOk.Enabled := true;
      exit;
    end;

    Application.ProcessMessages;

    if (r = 'new') then
      DoEdit(Counter.Value);

    CopyHardware(HardCounter.Value);

  end;

  if (operation = 'add') then
  begin
    //  
    DoCreate(Counter.Value);
  end;

  frmMain.current_projectsystemno := DST_systemno;
  Application.ProcessMessages;

  btnOk.Enabled := true;
  ModalResult := mrOk;
End;

function TfrmSystemsAdd.CreateNotExists: string;
var
  systemname, tagname: string;
  useproject: boolean;
begin
  result := 'cancel';
  useproject := DST_tablename <> 'uni_systems';
  //            DST_systemno
  //    
  systemname := trim(editName.Text);
  tagname := trim(editTag.Text);

  //       ,  ,   
  try
    QueryDST.SQL.Text := 'SELECT `rec_no` FROM `' + DST_tablename + '` WHERE `name`=:name AND `tag`=:tag';
    if useproject then
    begin
      QueryDST.SQL.Add(' AND  `project_no`=:project_no');
      QueryDST.ParamByName('project_no').AsInteger := Project_no;
    end;
    QueryDST.ParamByName('name').AsString := systemname;
    QueryDST.ParamByName('tag').AsString := tagname;
    QueryDST.Active := true;
    //       
    if QueryDST.RecordCount > 0 then
    begin
      // ,   
      DST_systemno := QueryDST.FieldByName('rec_no').AsInteger;
      result := 'old';
      exit;
    end;
  except
  end;

  //   ,   .     
  if (SRC_tablename <> DST_tablename) then
    if (MessageDlg('  . ?', mtCustom, [mbYes, mbCancel], 0) <> mrYes) then
      exit;

  //   ,   
  try
    if useproject then
    begin
      QueryDST.SQL.Text := 'INSERT INTO `' + DST_tablename + '` (project_no,name,tag,orderby)' +
        ' VALUES (:project_no,:name,:tag,:orderby)';
      QueryDST.ParamByName('project_no').AsInteger := Project_no;
      QueryDST.ParamByName('name').AsString := systemname;
      QueryDST.ParamByName('tag').AsString := tagname;
      QueryDST.ParamByName('orderby').AsInteger := set_orderby;
    end
    else
    begin
      QueryDST.SQL.Text := 'INSERT INTO `' + DST_tablename + '` (name,tag)' + ' VALUES (:name,:tag)';
      QueryDST.ParamByName('name').AsString := systemname;
      QueryDST.ParamByName('tag').AsString := tagname;
    end;
    QueryDST.ExecSQL;

    //     
    QueryDST.SQL.Text := 'SELECT `rec_no` FROM `' + DST_tablename + '` WHERE `name`=:name AND `tag`=:tag';
    if useproject then
    begin
      QueryDST.SQL.Add(' AND `project_no`=:project_no');
      QueryDST.ParamByName('project_no').AsInteger := Project_no;
    end;
    QueryDST.ParamByName('name').AsString := systemname;
    QueryDST.ParamByName('tag').AsString := tagname;
    QueryDST.Active := true;

    if QueryDST.RecordCount > 0 then
    begin
      //    
      DST_systemno := QueryDST.FieldByName('rec_no').AsInteger;
      result := 'new';
    end;
  except
    ShowMessage('   ');
  end;

end;

Procedure TfrmSystemsAdd.DoEdit(count: integer);
var
  f: double;
begin
  if DST_systemno < 0 then
    exit;
  //
  try
    QueryDST.SQL.Text := 'UPDATE ' + DST_tablename + ' SET ' +
      'name=:name,construction=:construction,kind=:kind,voltage=:voltage,current=:current,protection=:protection,entries=:entries,voltage_secondary=:voltage_secondary,strength=:strength,tag=:tag,'
      + 'overprice=:overprice,zav_date=:zav_date,zav_pre=:zav_pre,zav=:zav,zav_post=:zav_post' +
      ' WHERE `rec_no`=:systemno LIMIT 1;';
    QueryDST.ParamByName('systemno').AsInteger := DST_systemno;

    QueryDST.ParamByName('name').AsString := trim(editName.Text);
    QueryDST.ParamByName('construction').AsString := construction.Text;
    QueryDST.ParamByName('kind').AsString := kind.Text;
    QueryDST.ParamByName('voltage').AsString := voltage.Text;
    QueryDST.ParamByName('current').AsString := current.Text;
    QueryDST.ParamByName('protection').AsString := protection.Text;
    QueryDST.ParamByName('entries').AsString := entries.Text;
    QueryDST.ParamByName('voltage_secondary').AsString := voltage_secondary.Text;
    QueryDST.ParamByName('strength').AsString := strength.Text;
    QueryDST.ParamByName('tag').AsString := editTag.Text;
    QueryDST.ParamByName('overprice').AsInteger := OverPrice.Value;
    QueryDST.ParamByName('zav_date').AsDateTime := PassportDate.DateTime;
    QueryDST.ParamByName('zav_pre').AsString := zav_pre.Text;
    QueryDST.ParamByName('zav').AsString := zav.Text;
    QueryDST.ParamByName('zav_post').AsString := zav_post.Text;
    QueryDST.ExecSQL;
  except
    ShowMessage(' frmSystemsAdd.SaveAfterCopy 1');
  end;

  try
    QueryDST.SQL.Text := 'UPDATE ' + DST_tablename + ' SET ' + 'cab_w=:cab_w,cab_h=:cab_h,cab_d=:cab_d' +
      ' WHERE `rec_no`=:systemno LIMIT 1;';
    QueryDST.ParamByName('systemno').AsInteger := DST_systemno;
    QueryDST.ParamByName('cab_w').AsString := cab_w.Text;
    QueryDST.ParamByName('cab_h').AsString := cab_h.Text;
    QueryDST.ParamByName('cab_d').AsString := cab_d.Text;
    QueryDST.ExecSQL;
  except
    // ShowMessage(' frmSystemsAdd.SaveAfterCopy 2');
  end;

  //   
  if (DST_tablename = 'uni_projectsystems') and (Project_no > -1) then
    try
      QueryDST.SQL.Text := 'UPDATE ' + DST_tablename +
        ' SET project_no=:project_no,count=:count,active=:active,overprice_kind=:overprice_kind WHERE `rec_no`=:systemno LIMIT 1;';
      QueryDST.ParamByName('systemno').AsInteger := DST_systemno;
      QueryDST.ParamByName('project_no').AsInteger := Project_no;
      QueryDST.ParamByName('count').AsInteger := count;
      QueryDST.ParamByName('active').AsBoolean := UseActive.Checked;
      if rb_abs.Checked then
        QueryDST.ParamByName('overprice_kind').AsInteger := 1
      else
        QueryDST.ParamByName('overprice_kind').AsInteger := 0;

      QueryDST.ExecSQL;

      if rb_abs.Checked then
        QueryDST.SQL.Text := 'UPDATE ' + DST_tablename + ' SET total=price+:overprice WHERE `rec_no`=:systemno LIMIT 1;'
      else
        QueryDST.SQL.Text := 'UPDATE ' + DST_tablename +
          ' SET total=price*(1+:overprice/100) WHERE `rec_no`=:systemno LIMIT 1;';
      QueryDST.ParamByName('overprice').AsFloat := OverPrice.Value;
      QueryDST.ParamByName('systemno').AsInteger := DST_systemno;
      QueryDST.ExecSQL;

    except
      ShowMessage(' frmSystemsAdd.SaveAfterCopy 3');
    end;
end;

Procedure TfrmSystemsAdd.DoCreate(count: integer);
begin
  try
    QueryDST.SQL.Text := 'INSERT INTO ' + DST_tablename + ' (name,orderby) VALUES (:name,:orderby)';
    QueryDST.ParamByName('name').AsString := trim(editName.Text);
    QueryDST.ParamByName('orderby').AsInteger := set_orderby;
    QueryDST.ExecSQL;

    QueryDST.SQL.Text := 'SELECT LAST_INSERT_ID() as ID';
    QueryDST.Active := true;
    DST_systemno := QueryDST.FieldByName('ID').AsInteger;

    // DST_systemno 
  except
    ShowMessage(' frmSystemsAdd.DoCreate');
  end;
  //     
  DoEdit(1);
end;

Procedure TfrmSystemsAdd.MultiplyEnable(xmode: boolean);
begin
  HardCounterLabel.visible := xmode;
  HardCounter.visible := xmode;
  HardCounter.Value := 1;
end;

End.
