unit ReportSelect;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, JvExStdCtrls, JvButton,
  JvCtrls, JvFooter, Vcl.ExtCtrls, JvExExtCtrls, JvExtComponent, Data.DB,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client;

type
  TfrmReportSelect = class(TForm)
    Label1: TLabel;
    ListReports: TListBox;
    Footer: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    TTemplate: TFDQuery;
    TTemplaterec_no: TIntegerField;
    TTemplatekind: TStringField;
    TTemplatename: TStringField;
    TTemplatestore: TBlobField;
    TTemplateproject_no: TIntegerField;
    TTemplatedefaultext: TStringField;
    procedure FormShow(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure ListReportsDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    reportkind, reportname: string;
    { Public declarations }
  end;

var
  frmReportSelect: TfrmReportSelect;

implementation

{$R *.dfm}

uses  Main, Universal;

procedure TfrmReportSelect.btnOkClick(Sender: TObject);
begin
  if ListReports.ItemIndex > -1 then
  begin
    reportname := ListReports.Items[ListReports.ItemIndex];
    ModalResult := mrOk;
  end;
end;

procedure TfrmReportSelect.FormShow(Sender: TObject);
begin
  if not frmUniversal.DBConnected then
    close;
  ListReports.Clear;
  try
    TTemplate.SQL.Text :=
      'SELECT * FROM `uni_docparts` WHERE `project_no`=0 AND (`kind`=' +
      QuotedStr(reportkind) + ' OR `kind`="");';
    TTemplate.Active := true;
    while not TTemplate.Eof do
    begin
      ListReports.Items.Add(TTemplate.FieldByName('name').AsString);
      TTemplate.Next;
    end;
  except
  end;
end;

procedure TfrmReportSelect.ListReportsDblClick(Sender: TObject);
begin
  btnOk.Click;
end;

end.
