﻿unit ProjectSummary;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, tmsUFlxFormats,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ComCtrls, Vcl.Grids, Vcl.DBGrids,
  JvExDBGrids, JvDBGrid, Data.DB, Vcl.Menus, JvMenus, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client,
  JvDBGridExport, JvComponentBase, ShellAPI, JvFormPlacement,
  AdvUtil, AdvObj, BaseGrid, AdvGrid, DBAdvGrid, tmsAdvGridExcel, Vcl.StdCtrls,
  Vcl.ExtCtrls;

type
  TfrmProjectSummary = class(TForm)
    pmPrHardware: TPopupMenu;
    TPrHardware: TFDQuery;
    DSPrHardware: TDataSource;
    StatusBar: TStatusBar;
    HTMLExport: TJvDBGridHTMLExport;
    SaveHTMLDialog: TSaveDialog;
    SaveXLSDialog: TSaveDialog;
    CSVExport: TJvDBGridCSVExport;
    SaveCSVDialog: TSaveDialog;
    mXLS: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    m1: TMenuItem;
    m2: TMenuItem;
    m3: TMenuItem;
    // XLSExportDBGrid1: TXLSExportDBGrid;
    // XLSExportFile1: TXLSExportFile;
    m0: TMenuItem;
    FormStorage: TJvFormStorage;
    N3: TMenuItem;
    XLSemail1: TMenuItem;
    N4: TMenuItem;
    ExportXML: TJvDBGridExcelExport;
    HardwareGrid: TDBAdvGrid;
    AdvGridExcelIO1: TAdvGridExcelIO;
    PanelHeader: TPanel;
    Label2: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TPrHardwareAfterOpen(DataSet: TDataSet);
    procedure mHTMLClick(Sender: TObject);
    procedure mXLSClick(Sender: TObject);
    procedure mCSVClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure m1Click(Sender: TObject);
    procedure m2Click(Sender: TObject);
    procedure m3Click(Sender: TObject);
    procedure m0Click(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure XLSemail1Click(Sender: TObject);
    procedure AdvGridExcelIO1CellFormat(Sender: TAdvStringGrid; const GridCol, GridRow, XlsCol, XlsRow: Integer;
      const Value: WideString; var Format: TFlxFormat);
    procedure HardwareGridGetFloatFormat(Sender: TObject; ACol, ARow: Integer; var IsFloat: Boolean;
      var FloatFormat: string);
    procedure HardwareGridGetFormat(Sender: TObject; ACol: Integer; var AStyle: TSortStyle;
      var aPrefix, aSuffix: string);
    procedure HardwareGridClickSort(Sender: TObject; ACol: Integer);
    procedure AdvGridExcelIO1ExportColumnFormat(Sender: TObject; GridCol, GridRow, XlsCol, XlsRow: Integer;
      const Value: WideString; var ExportCellAsString: Boolean);
  private
    FSortISWorking: Boolean;
    procedure Recalc;
    { Private declarations }
  public
    _Project_no: Integer;
    _Project_name: string;
    SQLOrder: string;
    { Public declarations }
  end;

var
  frmProjectSummary: TfrmProjectSummary;

implementation

{$R *.dfm}

uses Main, Universal, Mail;

procedure TfrmProjectSummary.AdvGridExcelIO1CellFormat(Sender: TAdvStringGrid;
  const GridCol, GridRow, XlsCol, XlsRow: Integer; const Value: WideString; var Format: TFlxFormat);
begin
  if (GridCol = 1) then
    Format.Format := '@';
  if (GridCol = 2) then
    Format.Format := '@';
  if (GridCol = 3) then
    Format.Format := '@';
  if (GridCol = 4) then
    Format.Format := '0';
  if (GridCol = 5) then
    Format.Format := '#,##0.00';
  if (GridCol = 6) then
    Format.Format := '#,##0.00';
  if (GridCol = 7) then
    Format.Format := '@';
end;

procedure TfrmProjectSummary.AdvGridExcelIO1ExportColumnFormat(Sender: TObject;
  GridCol, GridRow, XlsCol, XlsRow: Integer; const Value: WideString; var ExportCellAsString: Boolean);
begin
  case GridCol of
    0:
      ExportCellAsString := true;
    1:
      ExportCellAsString := true;
    3:
      ExportCellAsString := true;
    4:
      ExportCellAsString := false;
    5:
      ExportCellAsString := false;
    6:
      ExportCellAsString := false;
    7:
      ExportCellAsString := true;
  end;
end;

procedure TfrmProjectSummary.FormActivate(Sender: TObject);
begin
  Recalc;
end;

procedure TfrmProjectSummary.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TfrmProjectSummary.FormCreate(Sender: TObject);
// var  FormatBr: TFormatSettings;
begin
  {
    FormatBr := TFormatSettings.Create;
    FormatBr.DecimalSeparator := ',';
    System.SysUtils.FormatSettings := FormatBr;
  }
  // SQLOrder := '`developer`';

end;

procedure TfrmProjectSummary.FormShow(Sender: TObject);
begin
  if not frmUniversal.DBConnected then
    close;
end;

procedure TfrmProjectSummary.HardwareGridClickSort(Sender: TObject; ACol: Integer);
begin
  try
    try
      if FSortISWorking then
        Exit;
      FSortISWorking := true;

      if ACol < 0 then
      begin
        HardwareGrid.BeginUpdate;
        HardwareGrid.SortSettings.Column := ACol;
        Application.ProcessMessages;
        HardwareGrid.QSort;
        HardwareGrid.EndUpdate;
      end;
    except
      on e: Exception do
      begin
        // log the error
      end;
    end;
  finally
    FSortISWorking := false;
  end;
end;

procedure TfrmProjectSummary.HardwareGridGetFloatFormat(Sender: TObject; ACol, ARow: Integer; var IsFloat: Boolean;
  var FloatFormat: string);
begin
  // FloatFormat := '%.2f';
end;

procedure TfrmProjectSummary.HardwareGridGetFormat(Sender: TObject; ACol: Integer; var AStyle: TSortStyle;
  var aPrefix, aSuffix: string);
begin
  case ACol of
    0:
      AStyle := TSortStyle.ssAlphabetic;
    1:
      AStyle := TSortStyle.ssAlphabetic;
    3:
      AStyle := TSortStyle.ssAlphabetic;
    4:
      AStyle := TSortStyle.ssNumeric;
    5:
      AStyle := TSortStyle.ssFinancial;
    6:
      AStyle := TSortStyle.ssFinancial;
    7:
      AStyle := TSortStyle.ssAlphabetic;
  end;
end;

procedure TfrmProjectSummary.mHTMLClick(Sender: TObject);
begin
  SaveHTMLDialog.FileName := _Project_name + '.html';
  If SaveHTMLDialog.Execute Then
  Begin
    HTMLExport.Caption := 'Проект: ' + _Project_name;
    HTMLExport.DocTitle := 'Проект: ' + _Project_name;
    HTMLExport.FileName := SaveHTMLDialog.FileName;
    HTMLExport.ExportGrid;
    If FileExists(HTMLExport.FileName) Then
      ShellExecute(Handle, 'open', pchar(frmMain.extensions.Values[ExtractFileExt(HTMLExport.FileName)] + ' ' +
        HTMLExport.FileName), Nil, Nil, SW_SHOWNORMAL);
  End;
end;

procedure TfrmProjectSummary.mCSVClick(Sender: TObject);
begin
  SaveCSVDialog.FileName := _Project_name + '.csv';
  If SaveCSVDialog.Execute Then
  Begin
    CSVExport.Caption := 'Проект: ' + _Project_name;
    // CSVExport.DocTitle := 'Проект: ' + _Project_name;
    CSVExport.FileName := SaveCSVDialog.FileName;
    CSVExport.ExportGrid;
    If FileExists(CSVExport.FileName) Then
      ShellExecute(Handle, 'open', pchar(frmMain.extensions.Values[ExtractFileExt(CSVExport.FileName)] + ' ' +
        CSVExport.FileName), Nil, Nil, SW_SHOWNORMAL);
  End;
end;

procedure TfrmProjectSummary.Recalc;
var
  scnt: string;
begin
  { SQLOrder := GridPrHardware.SortedField;
    if GridPrHardware.SortMarker = smDown then
    SQLOrder := SQLOrder + ' desc'; }
  // SQLOrder := 'orderby';
  SQLOrder := 'developer';

  TPrHardware.Active := false;
  scnt := '(SELECT `count` FROM uni_projectsystems WHERE `rec_no`=uni_projecthardware.system_no LIMIT 1)';
  TPrHardware.SQL.Text := 'SELECT `kinddesc`,`name`,`article`,SUM(`count`*' + scnt +
    ') as `count2`,`price`,SUM(`count`*' + scnt +
    ')*`price` as `total`,`developer` FROM uni_projecthardware WHERE `project_no`=' + IntToStr(_Project_no) +
    ' AND `system_no` IN (SELECT `rec_no` FROM uni_projectsystems WHERE `project_no`=' + IntToStr(_Project_no) +
    ' AND `active`=true) GROUP BY `name`,`price` ORDER BY ' + SQLOrder + ';';
  TPrHardware.Active := true;

end;

procedure TfrmProjectSummary.TPrHardwareAfterOpen(DataSet: TDataSet);
begin
  (TPrHardware.FieldByName('price') As TFloatField).DisplayFormat := ',0.00';
  (TPrHardware.FieldByName('total') As TFloatField).DisplayFormat := ',0.00';

  //
  HardwareGrid.ColWidths[0] := 0;

  HardwareGrid.ColumnByFieldName['kinddesc'].Header := 'Тип';
  HardwareGrid.ColumnByFieldName['name'].Header := 'Наименование';
  HardwareGrid.ColumnByFieldName['count2'].Header := 'Количество';

  HardwareGrid.ColumnByFieldName['price'].Header := 'Стоимость';
  HardwareGrid.ColumnByFieldName['total'].Header := 'Итого';
  HardwareGrid.ColumnByFieldName['article'].Header := 'Артикул';
  HardwareGrid.ColumnByFieldName['developer'].Header := 'Производитель';

  HardwareGrid.ColumnByFieldName['count2'].Alignment:=taCenter;
  HardwareGrid.ColumnByFieldName['developer'].Alignment:=taCenter;

  try
    HardwareGrid.SelectRange(1, 1, 1, 1);
  except

  end;

  HardwareGridClickSort(self, 4);
end;

procedure TfrmProjectSummary.XLSemail1Click(Sender: TObject);
var
  tmpfile: string;
  cnt: Integer;
begin
  tmpfile := frmMain.ComputerInfo.Folders.Temp + '\' + _Project_name + '.xls';
  cnt := 0;

  while FileExists(tmpfile) do
  begin

    try
      DeleteFile(tmpfile);
    except
    end;

    if FileExists(tmpfile) then
    begin
      inc(cnt);
      tmpfile := frmMain.ComputerInfo.Folders.Temp + '\' + _Project_name + '_' + cnt.tostring + '.xls';
    end;
  end;

  // Сохраняем в Excel
  // tmpfile := 'd:\1.xls';
  AdvGridExcelIO1.Options.ExportShowInExcel := false;
  AdvGridExcelIO1.XLSExport(tmpfile);

  If FileExists(tmpfile) Then
  begin
    frmMail.FileList.Items.Clear;
    frmMail.FileList.Items.Add(tmpfile);
    frmMail.ShowModal;
  end;

end;

procedure TfrmProjectSummary.mXLSClick(Sender: TObject);
var
  e: string;
begin
  SaveXLSDialog.FileName := _Project_name + '.xls';

  If SaveXLSDialog.Execute Then
  Begin
    // HardwareGrid.SaveToXLS(SaveXLSDialog.FileName);
    AdvGridExcelIO1.Options.ExportShowInExcel := false;
    AdvGridExcelIO1.XLSExport(SaveXLSDialog.FileName);
    // Сохраняем в Excel
    If FileExists(SaveXLSDialog.FileName) Then
    begin
      e := frmMain.extensions.Values[ExtractFileExt(SaveXLSDialog.FileName)];
      if trim(e) <> '' then
      begin
        ShellExecute(Handle, 'open', pchar(e + ' ' + SaveXLSDialog.FileName), Nil, Nil, SW_SHOWNORMAL);
      end
      else
      begin
        ShellExecute(Handle, 'open', pchar(SaveXLSDialog.FileName), Nil, Nil, SW_SHOWNORMAL);
      end
    end;
  End;

end;

procedure TfrmProjectSummary.N3Click(Sender: TObject);
begin
  // GridPrHardware.SortedField := 'developer';
  Recalc;
end;

procedure TfrmProjectSummary.m0Click(Sender: TObject);
begin
  // GridPrHardware.SortedField := 'orderby';
  Recalc;
end;

procedure TfrmProjectSummary.m1Click(Sender: TObject);
begin
  // GridPrHardware.SortedField := 'name';
  Recalc;
end;

procedure TfrmProjectSummary.m2Click(Sender: TObject);
begin
  // GridPrHardware.SortedField := 'kinddesc,name';
  Recalc;
end;

procedure TfrmProjectSummary.m3Click(Sender: TObject);
begin
  // GridPrHardware.SortedField := 'article';
  Recalc;
end;

{ Тип
  Наименование
  Количество
  Стоимость
  Итого
  Артикул
  Производитель }
end.
