unit PriceUpdate;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, JvExStdCtrls, JvButton,
  JvCtrls, JvFooter, Vcl.ExtCtrls, JvExExtCtrls, JvExtComponent,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, Data.DB, FireDAC.Comp.DataSet,
  FireDAC.Comp.Client;

type
  TfrmPriceUpdate = class(TForm)
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    UpdateCurrent: TRadioButton;
    UpdateActive: TRadioButton;
    UpdateAll: TRadioButton;
    UpdateCertificates: TCheckBox;
    UpdatePrice: TCheckBox;
    UpdateTech: TCheckBox;
    ListPrices: TComboBox;
    Label1: TLabel;
    MyQuery: TFDQuery;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListPricesChange(Sender: TObject);
  private
    function GetPriceList: tstringlist;
    procedure UpdateButtons;
    { Private declarations }
  public
    pricelist: tstringlist;
    { Public declarations }
  end;

var
  frmPriceUpdate: TfrmPriceUpdate;

implementation

{$R *.dfm}

procedure TfrmPriceUpdate.FormCreate(Sender: TObject);
begin
  pricelist := tstringlist.Create;
end;

procedure TfrmPriceUpdate.FormDestroy(Sender: TObject);
begin
  pricelist.free;
end;

procedure TfrmPriceUpdate.FormShow(Sender: TObject);
begin
  ListPrices.Text := '';
  ListPrices.Items := GetPriceList;
  UpdateButtons;
  btnOk.SetFocus;
end;

function TfrmPriceUpdate.GetPriceList: tstringlist;
var
  item: string;
begin
  MyQuery.SQL.Text := 'SELECT `name` FROM `uni_pricelist` ORDER BY `dt` DESC;';
  MyQuery.Active := true;
  pricelist.Clear;
  while not MyQuery.eof do
  begin
    // item := MyQuery.FieldByName('name').AsString + ' [' + MyQuery.FieldByName('counter').AsString + '] / ' +      MyQuery.FieldByName('username').AsString + ' / ' + DateTimeToStr(MyQuery.FieldByName('dt').AsDateTime);
    item := MyQuery.FieldByName('name').AsString;
    pricelist.Add(item);
    MyQuery.next;
  end;
  result := pricelist;
end;

procedure TfrmPriceUpdate.ListPricesChange(Sender: TObject);
begin
  UpdateButtons;
end;

procedure TfrmPriceUpdate.UpdateButtons;
begin
  UpdateCertificates.Visible := length(ListPrices.Text) = 0;
  UpdateTech.Visible := length(ListPrices.Text) = 0;
end;

end.
