Unit OrderChange;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls,
  JvExExtCtrls, JvExtComponent, ComCtrls, JvExComCtrls, JvDateTimePicker,
  ActnList, DB, Project, System.Actions, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet,
  FireDAC.Comp.Client;

Type
  TfrmOrderChange = Class(TForm)
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    GroupBoxPeriod: TGroupBox;
    Label5: TLabel;
    Label4: TLabel;
    _dateEnd: TJvDateTimePicker;
    _dateStart: TJvDateTimePicker;
    GroupBoxContragents: TGroupBox;
    Label10: TLabel;
    Label9: TLabel;
    Label1: TLabel;
    _Customers: TComboBox;
    _Engineers: TComboBox;
    _Managers: TComboBox;
    TProjects: TFDQuery;
    TProjectsrec_no: TIntegerField;
    TProjectsname: TStringField;
    TProjectsdatestart: TDateField;
    TProjectsdateend: TDateField;
    TProjectsowner_customer: TStringField;
    TProjectsowner_engineer: TStringField;
    TProjectsowner_manager: TStringField;
    TProjectsoptions: TStringField;
    TProjectsdateupdate: TDateField;
    Actions: TActionList;
    actChange: TAction;
    MyQuery: TFDQuery;
    Label8: TLabel;
    _Name: TEdit;
    Label2: TLabel;
    _Description: TEdit;
    Procedure FormShow(Sender: TObject);
    Procedure actChangeUpdate(Sender: TObject);
    Procedure actChangeExecute(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
  Private
    { Private declarations }
  Public
    Project_no: Integer;
    Project_name: String;
    Project_description: String;
    Project_customer: String;
    Project_engineer: String;
    Project_manager: String;
    Project_datestart: tdatetime;
    Project_dateend: tdatetime;
    { Public declarations }
  End;

Var
  frmOrderChange: TfrmOrderChange;

Implementation

Uses Main;

{$R *.dfm}

Procedure TfrmOrderChange.actChangeExecute(Sender: TObject);
Begin
  Project_name := _Name.Text;
  Project_description := _Description.Text;
  Project_customer := _Customers.Text;
  Project_engineer := _Engineers.Text;
  Project_manager := _Managers.Text;
  Project_datestart := _dateStart.Date;
  Project_dateend := _dateEnd.Date;

  modalresult := mrOk;
End;

Procedure TfrmOrderChange.actChangeUpdate(Sender: TObject);
Begin
  actChange.Enabled := (_Name.Text <> '') And (_Customers.Text <> '') And
    (_Engineers.Text <> '') And (_Managers.Text <> '');
End;

Procedure TfrmOrderChange.FormActivate(Sender: TObject);
Begin
  _Name.ReadOnly := (frmMain.usergroup.Length < 5);
  _Description.ReadOnly := (frmMain.usergroup.Length < 5);
  _Customers.Enabled := (frmMain.usergroup.Length > 1);
  _Engineers.Enabled := (frmMain.usergroup.Length > 1);
  _Managers.Enabled := (frmMain.usergroup.Length > 1);
  _dateStart.Enabled := (frmMain.usergroup.Length > 1);
  _dateEnd.Enabled := (frmMain.usergroup.Length > 1);
  try
    btnOk.SetFocus;
  except
  end;
End;

Procedure TfrmOrderChange.FormShow(Sender: TObject);
Begin
  _Name.Text := Project_name;
  _Description.Text := Project_description;
  _Customers.Text := Project_customer;
  _Engineers.Text := Project_engineer;
  _Managers.Text := Project_manager;
  _dateStart.Date := Project_datestart;
  _dateEnd.Date := Project_dateend;
  //
  Try
    // 
    _Customers.Items.Clear;
    MyQuery.SQL.Text :=
      'SELECT `name` FROM `uni_customers` GROUP BY `name` ORDER BY `name`;';
    MyQuery.Active := true;
    If MyQuery.Active Then
      While Not MyQuery.Eof Do
      Begin
        If MyQuery.FieldByName('name').AsString <> '' Then
          _Customers.Items.Add(MyQuery.FieldByName('name').AsString);
        MyQuery.Next;
      End;
    // 
    _Engineers.Items.Clear;
    MyQuery.SQL.Text := 'SELECT `user_fio` FROM `uni_users` WHERE `usergroup`='
      + QuotedStr('') + ' GROUP BY `user_fio` ORDER BY `user_fio`;';
    MyQuery.Active := true;
    If MyQuery.Active Then
      While Not MyQuery.Eof Do
      Begin
        If MyQuery.FieldByName('user_fio').AsString <> '' Then
          _Engineers.Items.Add(MyQuery.FieldByName('user_fio').AsString);
        MyQuery.Next;
      End;
    // 
    _Managers.Items.Clear;
    MyQuery.SQL.Text := 'SELECT `user_fio` FROM `uni_users` WHERE `usergroup`='
      + QuotedStr('') + ' GROUP BY `user_fio` ORDER BY `user_fio`;';
    MyQuery.Active := true;
    If MyQuery.Active Then
      While Not MyQuery.Eof Do
      Begin
        If MyQuery.FieldByName('user_fio').AsString <> '' Then
          _Managers.Items.Add(MyQuery.FieldByName('user_fio').AsString);
        MyQuery.Next;
      End;
  Except
  End;

End;

End.
