unit ObjectsList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, JvExGrids, JvStringGrid, ExtCtrls, FMTBcd, SqlExpr, DB, Menus,
  StdActns, ActnList, JvMenus, DBGrids, JvExDBGrids, JvDBGrid, DBClient,
  Provider, ComCtrls, StdCtrls, JvExControls, JvDBLookup, JvComponentBase,
  JvDBGridExport, JvDialogs;

type
  TfrmObjectsList = class(TForm)
    Panel4: TPanel;
    GridObj: TJvDBGrid;
    PopupMenu: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    Actions: TActionList;
    actObjectsTree: TAction;
    actObjectsList: TAction;
    actObjectsFilterEdit: TAction;
    actObjectsFilters: TAction;
    actExit: TAction;
    WindowCascade1: TWindowCascade;
    WindowTileHorizontal1: TWindowTileHorizontal;
    WindowTileVertical1: TWindowTileVertical;
    WindowMinimizeAll1: TWindowMinimizeAll;
    WindowArrangeAll1: TWindowArrange;
    HelpAbout1: TAction;
    actSettings_Database: TAction;
    WindowClose1: TWindowClose;
    actAdd: TAction;
    actEdit: TAction;
    actDelete: TAction;
    MainMenu: TMainMenu;
    N12: TMenuItem;
    N15: TMenuItem;
    N14: TMenuItem;
    N13: TMenuItem;
    StatusBar: TStatusBar;
    Panel1: TPanel;
    TableFilters: TSQLTable;
    TableFiltersrec_no: TIntegerField;
    TableFiltersdesc: TStringField;
    TableFilterssql: TMemoField;
    DSPFilters: TDataSetProvider;
    CDSFilters: TClientDataSet;
    CDSFiltersrec_no: TIntegerField;
    CDSFiltersdesc: TStringField;
    CDSFilterssql: TMemoField;
    DSFilters: TDataSource;
    DSPObj: TDataSetProvider;
    CDSObj: TClientDataSet;
    DSObj: TDataSource;
    QueryObj: TSQLQuery;
    TableFiltersf_captions: TStringField;
    TableFiltersf_visible: TStringField;
    TableFiltersf_width: TStringField;
    CDSFiltersf_captions: TStringField;
    CDSFiltersf_visible: TStringField;
    CDSFiltersf_width: TStringField;
    TableFilterssql_params: TMemoField;
    TableFilterssql_values: TMemoField;
    SaveDialog: TJvSaveDialog;
    JvDBGridExcelExport1: TJvDBGridExcelExport;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure JvDBLookupCombo1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    procedure RenewFilters;
    procedure Translate;
    { Private declarations }
  public
    f_captions,f_visible,f_width: TStringList;
    procedure ExportToExcel;
    { Public declarations }
  end;

var
  frmObjectsList: TfrmObjectsList;

implementation

uses Main;

{$R *.dfm}

procedure TfrmObjectsList.FormActivate(Sender: TObject);
begin
    RenewFilters;
end;

procedure TfrmObjectsList.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    Action := caFree;
end;

procedure TfrmObjectsList.FormCreate(Sender: TObject);
begin
    f_captions:=TStringList.Create;
    f_visible:=TStringList.Create;
    f_width:=TStringList.Create;
end;

procedure TfrmObjectsList.FormDestroy(Sender: TObject);
begin
    f_captions.Free;
    f_visible.Free;
    f_width.Free;
end;

procedure TfrmObjectsList.JvDBLookupCombo1Change(Sender: TObject);
begin
    QueryObj.SQL.Text:=CDSFilters.FieldByName('sql').AsString;
    if (QueryObj.SQL.Text<>'') then
      try
      if not QueryObj.Active then QueryObj.Active:=true;
      QueryObj.Refresh;
      if not CDSObj.Active then CDSObj.Active:=true;
      CDSObj.Refresh;
      except
      end;
    Translate;
end;

procedure TfrmObjectsList.RenewFilters;
begin
    //   
    if not CDSFilters.Active then CDSFilters.Active:=true;
    CDSFilters.Refresh;
    if not TableFilters.Active then TableFilters.Active:=true;
    TableFilters.Refresh;
end;


procedure TfrmObjectsList.Translate;
var i: integer;
   c,v: string;
   w: integer;
begin
    //        
    f_captions.text:=stringReplace(CDSFilters.FieldByName('f_captions').AsString,';',#13#10,[rfReplaceAll]);
    f_visible.text:=stringReplace(CDSFilters.FieldByName('f_visible').AsString,';',#13#10,[rfReplaceAll]);
    f_width.text:=stringReplace(CDSFilters.FieldByName('f_width').AsString,';',#13#10,[rfReplaceAll]);
    //     
    for i:=0 to GridObj.Columns.Count-1 do
    begin
      c:='';v:='';w:=0;
      if f_captions.Count>i then c:=f_captions[i];
      if f_visible.Count>i then v:=f_visible[i];
      if f_width.Count>i then TryStrToInt(f_width[i],w);
      //      
      GridObj.Columns[i].Title.Caption:=c;
      if w>0 then GridObj.Columns[i].Width:=w else GridObj.Columns[i].Width:=100;
      if (v='0') or (v='false') then GridObj.Columns[i].Visible:=false;
      GridObj.Columns[i].Title.Alignment:=taCenter;
    end;
end;

procedure TfrmObjectsList.ExportToExcel;
begin
   if CDSObj.Active and (CDSObj.RecordCount>0) then
     begin
     if SaveDialog.Execute() then
        try
        JvDBGridExcelExport1.FileName:=SaveDialog.FileName;
        JvDBGridExcelExport1.ExportGrid;
        except
        end;
     end
     else
      ShowMessage('   ');
end;


end.
