unit ObjectsFilters;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, JvExGrids, JvStringGrid, ExtCtrls, Menus, StdActns, ActnList,
  JvMenus, DB, DBTables, JvDataSource, DBGrids, JvExDBGrids, JvDBGrid, FMTBcd,
  SqlExpr, DBClient, Provider, ComCtrls;

type
  TfrmObjectsFilters = class(TForm)
    Panel4: TPanel;
    TablePMenu: TPopupMenu;
    Actions: TActionList;
    actAdd: TAction;
    actEdit: TAction;
    actDelete: TAction;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    JvDBGrid1: TJvDBGrid;
    StatusBar: TStatusBar;
    TableFilters: TSQLTable;
    DSPFilters: TDataSetProvider;
    CDSFilters: TClientDataSet;
    DSFilters: TDataSource;
    TableFiltersrec_no: TIntegerField;
    TableFiltersdesc: TStringField;
    TableFilterssql: TMemoField;
    CDSFiltersrec_no: TIntegerField;
    CDSFiltersdesc: TStringField;
    CDSFilterssql: TMemoField;
    MainMenu: TMainMenu;
    N12: TMenuItem;
    N15: TMenuItem;
    N14: TMenuItem;
    N13: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure actAddExecute(Sender: TObject);
    procedure actEditExecute(Sender: TObject);
    procedure actDeleteExecute(Sender: TObject);
    procedure CDSFiltersAfterPost(DataSet: TDataSet);
    procedure actAddUpdate(Sender: TObject);
    procedure actEditUpdate(Sender: TObject);
    procedure actDeleteUpdate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure CDSFiltersAfterDelete(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmObjectsFilters: TfrmObjectsFilters;

implementation

uses Main, FilterAdd, FilterDelete;

{$R *.dfm}

procedure TfrmObjectsFilters.actAddExecute(Sender: TObject);
begin
    frmFilterAdd.Desc.Text := '';
    frmFilterAdd.SQL.Text := 'SELECT * FROM `obj_eff`';
    frmFilterAdd.Caption := '  ()';
    if frmFilterAdd.ShowModal=mrOk then
      begin
      CDSFilters.Append;
      CDSFilters.FieldByName('desc').AsString := frmFilterAdd.Desc.Text;
      CDSFilters.FieldByName('sql').AsString := frmFilterAdd.SQL.Text;
      CDSFilters.Post;
      end;
end;

procedure TfrmObjectsFilters.actAddUpdate(Sender: TObject);
begin
    actAdd.Enabled:=(CDSFilters.Active);
end;

procedure TfrmObjectsFilters.actDeleteExecute(Sender: TObject);
begin
    if frmFilterDelete.ShowModal=mrOk then
      begin
      CDSFilters.Delete;
      end;
end;

procedure TfrmObjectsFilters.actDeleteUpdate(Sender: TObject);
begin
    actDelete.Enabled:=(CDSFilters.Active and (CDSFilters.RecordCount>0) and (CDSFilters.RecNo>0));
end;

procedure TfrmObjectsFilters.actEditExecute(Sender: TObject);
begin
    frmFilterAdd.Caption := '  ()';
    frmFilterAdd.Desc.Text := CDSFilters.FieldByName('desc').AsString;
    frmFilterAdd.SQL.Text := CDSFilters.FieldByName('sql').AsString;
    if frmFilterAdd.ShowModal=mrOk then
      begin
      CDSFilters.Edit;
      CDSFilters.FieldByName('desc').AsString := frmFilterAdd.Desc.Text;
      CDSFilters.FieldByName('sql').AsString := frmFilterAdd.SQL.Text;
      CDSFilters.Post;
      end;
end;

procedure TfrmObjectsFilters.actEditUpdate(Sender: TObject);
begin
    actEdit.Enabled:=(CDSFilters.Active and (CDSFilters.RecordCount>0) and (CDSFilters.RecNo>0));
end;

procedure TfrmObjectsFilters.CDSFiltersAfterDelete(DataSet: TDataSet);
begin
  CDSFilters.ApplyUpdates(0);
end;

procedure TfrmObjectsFilters.CDSFiltersAfterPost(DataSet: TDataSet);
begin
  CDSFilters.ApplyUpdates(0);
  CDSFilters.Refresh;
end;

procedure TfrmObjectsFilters.FormActivate(Sender: TObject);
begin
    try
    if not CDSFilters.Active then CDSFilters.Active:=true;
    except
    end;
end;

procedure TfrmObjectsFilters.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

end.
