unit LanguageSelect;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, xmldom, XMLIntf, msxmldom, XMLDoc, Menus,
  ActnList, Registry, JvComponentBase, JvSearchFiles;

type
  TfrmLanguageSelect = class(TForm)
    LanguageList: TListBox;
    Panel1: TPanel;
    btnOk: TButton;
    XMLDocument1: TXMLDocument;
    SearchXMLFiles: TJvSearchFiles;
    procedure FormShow(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure LanguageListDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    procedure SetLanguage(NewLang: string);
    procedure TranslateForm(MyForm: TForm);
    function TranslateString(Name, Default: string): string;
    function GetLocaleInformation(Flag: Integer): string;

  var
    language: string;
    DBFile: string;
    { Public declarations }
  end;

var
  frmLanguageSelect: TfrmLanguageSelect;

implementation

uses Main;

{$R *.dfm}

procedure TfrmLanguageSelect.btnOkClick(Sender: TObject);
begin
  if LanguageList.ItemIndex > -1 then
  begin
    if LanguageList.Items[LanguageList.ItemIndex] <> '' then
      SetLanguage(LanguageList.Items[LanguageList.ItemIndex]);
    Modalresult := mrOk;
  end;
end;

procedure TfrmLanguageSelect.FormCreate(Sender: TObject);
begin
  language := GetLocaleInformation(LOCALE_SENGLANGUAGE);
end;

procedure TfrmLanguageSelect.FormDestroy(Sender: TObject);
begin
  if XMLDocument1.Active then
    try
      XMLDocument1.SaveToFile(DBFile);
    except
    end;
  XMLDocument1.Active := false;
end;

procedure TfrmLanguageSelect.FormShow(Sender: TObject);
var
  i: Integer;
  dn: string;
begin
  LanguageList.Clear;
  SearchXMLFiles.RootDirectory := ExtractFilePath(Application.ExeName);
  if SearchXMLFiles.Search then
  begin
    for i := 0 to SearchXMLFiles.Files.Count - 1 do
    begin
      dn := ExtractFilename(SearchXMLFiles.Files[i]);
      dn := Copy(dn, 0, pos('.', dn) - 1);
      LanguageList.Items.Add(dn);
    end;
  end;
  LanguageList.ItemIndex := LanguageList.Items.IndexOf(language);
end;

procedure TfrmLanguageSelect.LanguageListDblClick(Sender: TObject);
begin
  btnOkClick(self);
end;

procedure TfrmLanguageSelect.SetLanguage(NewLang: string);
begin
  if XMLDocument1.Active then
    try
      XMLDocument1.SaveToFile(DBFile);
    except
    end;

  XMLDocument1.Active := false;
  DBFile := ExtractFilePath(Application.ExeName) + NewLang + '.xml';
  if not FileExists(DBFile) then
  begin
    XMLDocument1.LoadFromXML
      ('<?xml version="1.0" encoding="UTF-8"?><UniCatalog />');
    language := NewLang;
  end
  else
  begin
    try
      XMLDocument1.LoadFromFile(DBFile);
      language := NewLang;
    except
      ShowMessage(DBFile + ' incorrect');
    end;
  end;

  try
    XMLDocument1.Active := true;
    XMLDocument1.Encoding := 'UTF-8';
    XMLDocument1.Version := '1.0';
  except
  end;
  DBFile := ExtractFilePath(Application.ExeName) + language + '.xml';
  frmMain.SaveSettings;
end;

function TfrmLanguageSelect.TranslateString(Name, Default: string): string;
var
  cur: string;
begin
  result := Default;
  if XMLDocument1.Active then
  begin
    cur := XMLDocument1.DocumentElement.ChildNodes[Name].Text;
    if cur <> '' then
    begin
      result := cur;
    end
    else
    begin
      XMLDocument1.DocumentElement.ChildNodes[Name].Text := Default;
    end;
  end;
end;

procedure TfrmLanguageSelect.TranslateForm(MyForm: TForm);
var
  i, z: Integer;
begin
  if XMLDocument1.Active then
  begin
    for i := 0 to MyForm.ComponentCount - 1 do
      if MyForm.Components[i].Tag > 0 then
      begin
        //    TAG>0  
        if MyForm.Components[i].ClassName = 'TMenuItem' then
          (MyForm.Components[i] as TMenuItem).Caption :=
            TranslateString(MyForm.Components[i].Name,
            (MyForm.Components[i] as TMenuItem).Caption);

        if MyForm.Components[i].ClassName = 'TLabel' then
          (MyForm.Components[i] as TLabel).Caption :=
            TranslateString(MyForm.Components[i].Name,
            (MyForm.Components[i] as TLabel).Caption);

        if MyForm.Components[i].ClassName = 'TAction' then
        begin
          (MyForm.Components[i] as TAction).Caption :=
            TranslateString(MyForm.Components[i].Name,
            (MyForm.Components[i] as TAction).Caption);
          (MyForm.Components[i] as TAction).Hint :=
            (MyForm.Components[i] as TAction).Caption;
        end;

        if MyForm.Components[i].ClassName = 'TButton' then
          (MyForm.Components[i] as TButton).Caption :=
            TranslateString(MyForm.Components[i].Name,
            (MyForm.Components[i] as TButton).Caption);

        if MyForm.Components[i].ClassName = 'TComboBox' then
        begin
          (MyForm.Components[i] as TComboBox).Text :=
            TranslateString(MyForm.Components[i].Name,
            (MyForm.Components[i] as TComboBox).Text);
          for z := 0 to (MyForm.Components[i] as TComboBox).Items.Count - 1 do
          begin
            (MyForm.Components[i] as TComboBox).Items[z] :=
              TranslateString(MyForm.Components[i].Name + IntToStr(z),
              (MyForm.Components[i] as TComboBox).Items[z]);
          end;

        end;

      end;
  end;
end;

function TfrmLanguageSelect.GetLocaleInformation(Flag: Integer): string;
var
  pcLCA: array [0 .. 20] of Char;
begin
  if GetLocaleInfo(LOCALE_SYSTEM_DEFAULT, Flag, pcLCA, 19) <= 0 then
    pcLCA[0] := #0;
  result := pcLCA;
end;

end.
