unit ImportToProject;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, JvExStdCtrls, JvButton,
  JvCtrls, JvFooter, JvExExtCtrls, JvExtComponent, Vcl.Grids, Vcl.DBGrids,
  JvExDBGrids, JvDBGrid, Vcl.ComCtrls, JvExComCtrls, JvDBTreeView, JvComCtrls,
  Vcl.Mask, JvExMask, JvToolEdit, Vcl.ExtCtrls, Vcl.Menus, Vcl.ActnList,
  Data.DB, JvDataSource, JvMemoryDataset, ExcelXP, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client,
  OleServer, Excel2000, XLSFile, XLSFormat, XLSRects, System.Actions;

type
  TfrmImportToProject = class(TForm)
    Panel1: TPanel;
    Label5: TLabel;
    ExcelFilenameEdit: TJvFilenameEdit;
    Pages: TJvPageControl;
    TabCategory: TTabSheet;
    Label11: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    lblPrice: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    lbl_name: TLabel;
    lbl_article: TLabel;
    lbl_price: TLabel;
    lbl_developer: TLabel;
    lbl_comment: TLabel;
    Label6: TLabel;
    _article: TEdit;
    _comment: TEdit;
    _developer: TEdit;
    _price: TEdit;
    _name: TEdit;
    _PageNo: TEdit;
    TabSheet3: TTabSheet;
    TemplateGrid: TJvDBGrid;
    TabSheetPreview: TTabSheet;
    PanelInfo: TPanel;
    DBGridPreview: TJvDBGrid;
    Footer: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    JvFooterBtn2: TJvFooterBtn;
    JvFooterBtn3: TJvFooterBtn;
    MemoryTable: TJvMemoryData;
    DSMemoryTable: TJvDataSource;
    THardware: TFDQuery;
    MyQuery1: TFDQuery;
    TTemplate: TFDQuery;
    DSTemplate: TDataSource;
    Actions: TActionList;
    actImport: TAction;
    actSaveToDB: TAction;
    actRemove: TAction;
    pmPreview: TPopupMenu;
    N1: TMenuItem;
    Label7: TLabel;
    _first: TEdit;
    _last: TEdit;
    Label8: TLabel;
    _count: TEdit;
    Label9: TLabel;
    lbl_count: TLabel;
    _kinddesc: TEdit;
    Label10: TLabel;
    lbl_kinddesc: TLabel;
    update_name: TCheckBox;
    update_price: TCheckBox;
    update_developer: TCheckBox;
    update_kinddesc: TCheckBox;
    procedure _articleChange(Sender: TObject);
    procedure actSaveToDBExecute(Sender: TObject);
    procedure actRemoveExecute(Sender: TObject);
    procedure actImportExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    InProgress: Boolean;
    AbortProgress: Boolean;
    procedure UpdateData;
    function DetectPosition(str: String): integer;
    function LetterNumber(Ch: Char): integer;
    function ConvertToInteger(str: String): integer;
    function MyStrToReal(input: String): real;
    { Private declarations }
  public
    xf: TXLSFile;
    Project_no, System_no: integer;
    { Public declarations }
  end;

var
  frmImportToProject: TfrmImportToProject;

implementation

{$R *.dfm}

uses Main;

Procedure TfrmImportToProject.UpdateData;
Begin
  Case DetectPosition(_article.Text) Of
    1:
      lbl_article.Caption := '  ';
    2:
      lbl_article.Caption := ' ';
    3:
      lbl_article.Caption := '    ';
  End;

  Case DetectPosition(_name.Text) Of
    1:
      lbl_name.Caption := '  ';
    2:
      lbl_name.Caption := ' ';
    3:
      lbl_name.Caption := '    ';
  End;

  Case DetectPosition(_price.Text) Of
    1:
      lbl_price.Caption := '  ';
    2:
      lbl_price.Caption := ' ';
    3:
      lbl_price.Caption := '    ';
  End;

  Case DetectPosition(_developer.Text) Of
    1:
      lbl_developer.Caption := '  ';
    2:
      lbl_developer.Caption := ' ';
    3:
      lbl_developer.Caption := '    ';
  End;

  Case DetectPosition(_comment.Text) Of
    1:
      lbl_comment.Caption := '  ';
    2:
      lbl_comment.Caption := ' ';
    3:
      lbl_comment.Caption := '    ';
  End;

  Case DetectPosition(_count.Text) Of
    1:
      lbl_count.Caption := '  ';
    2:
      lbl_count.Caption := ' ';
    3:
      lbl_count.Caption := '    ';
  End;

  Case DetectPosition(_kinddesc.Text) Of
    1:
      lbl_kinddesc.Caption := '  ';
    2:
      lbl_kinddesc.Caption := ' ';
    3:
      lbl_kinddesc.Caption := '    ';
  End;
End;

procedure TfrmImportToProject._articleChange(Sender: TObject);
begin
  UpdateData;
end;

procedure TfrmImportToProject.actImportExecute(Sender: TObject);
Var
  icid, i: integer;
  olev: OleVariant;
  cnt: integer;
  first, last: integer;
  pos_articul: integer;
  category: String;
  category_id: integer;
  pos_name, pos_price, pos_developer, pos_comment, pos_count, pos_kinddesc: integer;
  curPage: integer;
  OpenSuccess: Boolean;
var
  usedRange: TRangeRect;
begin
  //   
  AbortProgress := false;
  _article.Text := trim(_article.Text);
  _name.Text := trim(_name.Text);
  _price.Text := trim(_price.Text);
  _developer.Text := trim(_developer.Text);
  _comment.Text := trim(_comment.Text);
  _count.Text := trim(_count.Text);
  _kinddesc.Text := trim(_kinddesc.Text);
  if not trystrtoint(_PageNo.Text, curPage) then
    curPage := 0
  else
    curPage := curPage - 1;
  if curPage < 0 then
    curPage := 0;

  If (_article.Text = '') Then
  Begin
    ShowMessage('.    ');
  End
  Else If FileExists(ExcelFilenameEdit.Text) Then
  begin
    InProgress := true;
    Pages.ActivePage := TabSheetPreview;
    PanelInfo.Caption := ' ...';
    actImport.Update;
    DBGridPreview.DataSource := Nil;
    DBGridPreview.Visible := false;
    Application.ProcessMessages;

    MemoryTable.Active := true;
    MemoryTable.EmptyTable;

    OpenSuccess := false;
    try
      xf.OpenFile(ExcelFilenameEdit.Text);
      OpenSuccess := true;
    except
      OpenSuccess := false;
      ShowMessage('   .' + #13#10 + '   Office 2003  ');
    end;
    if OpenSuccess then
    begin
      xf.Workbook.Sheets[curPage].GetUsedRect(usedRange);
      cnt := usedRange.RowTo;
      // fill data to temp table
      pos_articul := ConvertToInteger(_article.Text);
      pos_name := ConvertToInteger(_name.Text);
      pos_price := ConvertToInteger(_price.Text);
      pos_developer := ConvertToInteger(_developer.Text);
      pos_comment := ConvertToInteger(_comment.Text);
      pos_count := ConvertToInteger(_count.Text);
      pos_kinddesc := ConvertToInteger(_kinddesc.Text);

      if not trystrtoint(_last.Text, last) then
        last := cnt
      else if last > cnt then
        last := cnt
      else
        last := last - 1;

      if not trystrtoint(_first.Text, first) then
        first := 0
      else if first > cnt then
        first := 0
      else
        first := first - 1;

      For i := first To last Do
      Begin
        If ((i Div 1000) = (i / 1000)) Then
          Application.ProcessMessages;
        If AbortProgress Then
          break;

        //  
        MemoryTable.Append;
        If ((i Div 100) = (i / 100)) Then
          PanelInfo.Caption := '  Excel [' + IntToStr(i) + '   ' + IntToStr(cnt) + ' ]';

        If pos_articul > -1 Then
          MemoryTable.FieldByName('article').AsString := trim(xf.Workbook.Sheets[curPage].Cells[i, pos_articul].Value)
        Else If (_article.Text <> '') Then
          MemoryTable.FieldByName('article').AsString := _article.Text;

        If pos_name > -1 Then
          MemoryTable.FieldByName('name').AsString := trim(xf.Workbook.Sheets[curPage].Cells[i, pos_name].Value)
        Else If (_name.Text <> '') Then
          MemoryTable.FieldByName('name').AsString := _name.Text;

        If pos_price > -1 Then
          MemoryTable.FieldByName('price').AsFloat :=
            MyStrToReal(trim(xf.Workbook.Sheets[curPage].Cells[i, pos_price].Value));

        If pos_count > -1 Then
          MemoryTable.FieldByName('count').AsFloat :=
            MyStrToReal(trim(xf.Workbook.Sheets[curPage].Cells[i, pos_count].Value));

        If pos_developer > -1 Then
          MemoryTable.FieldByName('developer').AsString :=
            trim(xf.Workbook.Sheets[curPage].Cells[i, pos_developer].Value)
        Else If (_developer.Text <> '') Then
          MemoryTable.FieldByName('developer').AsString := _developer.Text;

        If pos_comment > -1 Then
          MemoryTable.FieldByName('comment').AsString := trim(xf.Workbook.Sheets[curPage].Cells[i, pos_comment].Value)
        Else If (_comment.Text <> '') Then
          MemoryTable.FieldByName('comment').AsString := _comment.Text;

        If pos_kinddesc > -1 Then
          MemoryTable.FieldByName('kinddesc').AsString := trim(xf.Workbook.Sheets[curPage].Cells[i, pos_kinddesc].Value)
        Else If (_kinddesc.Text <> '') Then
          MemoryTable.FieldByName('kinddesc').AsString := _kinddesc.Text;

        MemoryTable.Post;
        If MemoryTable.FieldByName('article').AsString = '' Then
          MemoryTable.Delete;

      End;
    end;
  End
  Else
  Begin
    ShowMessage('   .        ');
  End;
  PanelInfo.Caption := '  ';
  MemoryTable.first;
  while not MemoryTable.eof do
  begin
    PanelInfo.Caption := '   [' + IntToStr(MemoryTable.RecNo) + '   ' +
      IntToStr(MemoryTable.RecordCount) + ' ]';
    Application.ProcessMessages;
    if MemoryTable.FieldByName('article').AsString <> '' then
      try
        MyQuery1.SQL.Text := 'SELECT * FROM uni_hardware WHERE `article`=' +
          QuotedStr(MemoryTable.FieldByName('article').AsString) + ';';
        MyQuery1.Active := true;
        if MyQuery1.RecordCount > 0 then
        begin
          MemoryTable.Edit;
          if update_name.Checked then
            MemoryTable.FieldByName('name').AsString := MyQuery1.FieldByName('name').AsString;
          if update_price.Checked then
            MemoryTable.FieldByName('price').AsString := MyQuery1.FieldByName('price').AsString;
          if update_developer.Checked then
            MemoryTable.FieldByName('developer').AsString := MyQuery1.FieldByName('developer').AsString;
          if update_kinddesc.Checked then
            MemoryTable.FieldByName('kinddesc').AsString := MyQuery1.FieldByName('kinddesc').AsString;
          MemoryTable.Post;
        end;
      except
      end;
    MemoryTable.Next;
  end;

  PanelInfo.Caption := '  Excel';
  DBGridPreview.DataSource := DSMemoryTable;
  DBGridPreview.Visible := true;
  InProgress := false;
end;

procedure TfrmImportToProject.actRemoveExecute(Sender: TObject);
begin
  //
end;

procedure TfrmImportToProject.actSaveToDBExecute(Sender: TObject);
Var
  cnt_old: integer;
  SQL: String;
  max_orderby: integer;
begin
  //    

  try
    MyQuery1.SQL.Text := 'SELECT max(`orderby`) as mx FROM uni_projecthardware WHERE `project_no`=' +
      IntToStr(Project_no) + ';';
    MyQuery1.Active := true;
    max_orderby := MyQuery1.FieldByName('mx').AsInteger;
    MyQuery1.Active := false;
  except
  end;
  //
  MemoryTable.first;
  cnt_old := 0;
  formatSETTINGS.DecimalSeparator := '.';
  If MemoryTable.RecordCount > 100 Then
    DBGridPreview.Visible := false;
  PanelInfo.Caption := '  ...';
  Application.ProcessMessages;
  THardware.SQL.Clear;
  While Not MemoryTable.eof Do
    Try
      If ((MemoryTable.RecNo Div 500) = (MemoryTable.RecNo / 500)) Then
      Begin
        PanelInfo.Caption := '   [' + IntToStr(MemoryTable.RecNo) + '  ' +
          IntToStr(MemoryTable.RecordCount) + ']';
        Application.ProcessMessages;
        THardware.SQL.Add('COMMIT;');
        THardware.Execute;
        cnt_old := cnt_old + THardware.RowsAffected;
        THardware.SQL.Clear;
      End;

      SQL := 'INSERT INTO `uni_projecthardware` SET `project_no`=' + IntToStr(Project_no) + ',`system_no`=' +
        IntToStr(System_no) + ',';
      // If (_name.Text <> '') Then
      SQL := SQL + '`name`=' + QuotedStr(MemoryTable.FieldByName('name').AsString) + ',';
      // If (_price.Text <> '') Then
      SQL := SQL + '`price`=' + FloatToStr(MemoryTable.FieldByName('price').AsFloat) + ',';
      // If (_developer.Text <> '') Then
      SQL := SQL + '`developer`=' + QuotedStr(MemoryTable.FieldByName('developer').AsString) + ',';
      // If (_article.Text <> '') Then
      SQL := SQL + '`article`=' + QuotedStr(MemoryTable.FieldByName('article').AsString) + ',';
      // If (_count.Text <> '') Then
      SQL := SQL + '`count`=' + FloatToStr(MemoryTable.FieldByName('count').AsInteger) + ',';
      // If (_comment.Text <> '') Then
      SQL := SQL + '`comment`=' + QuotedStr(MemoryTable.FieldByName('comment').AsString) + ',';
      // If (_kinddesc.Text <> '') Then
      SQL := SQL + '`kinddesc`=' + QuotedStr(MemoryTable.FieldByName('kinddesc').AsString) + ',';
      inc(max_orderby);
      SQL := SQL + '`orderby`=' + IntToStr(max_orderby) + ',';
      SQL := SQL + '`file`=' + QuotedStr('') + ';';
      THardware.SQL.Add(SQL);
      MemoryTable.Next;
    Except
    End;
  Try
    THardware.SQL.Add('COMMIT;');
    PanelInfo.Caption := ' ...';
    // THardware.SQL.SaveToFile('c:\temp.sql');
    Application.ProcessMessages;
    THardware.Execute;
    cnt_old := cnt_old + THardware.RowsAffected;
  Except
  End;

  DBGridPreview.Visible := true;
  PanelInfo.Caption := '  Excel';
  If (cnt_old > 0) Then
  begin
    // ShowMessage(': ' + IntToStr(cnt_old))
  end
  Else
    ShowMessage('       ');
  modalResult := mrOk;
end;

Function TfrmImportToProject.DetectPosition(str: String): integer;
Var
  i: integer;
  newpos: integer;
Begin
  If (str = '') Then
  Begin
    result := 1;
  End
  Else If trystrtoint(str, newpos) Then
  Begin
    result := 2;
  End
  Else If Length(str) > 1 Then
    result := 3
  Else
  Begin
    newpos := LetterNumber(str[1]);
    If newpos > 0 Then
      result := 2
    Else
      result := 3;
  End;
End;

Function TfrmImportToProject.LetterNumber(Ch: Char): integer;
  Function GetLN(C, F: Char): integer;
  Begin
    result := Ord(C) - Ord(F) + 1;
  End;

Begin
  Case Ch Of
    'A' .. 'Z':
      result := GetLN(Ch, 'A');
    'a' .. 'z':
      result := GetLN(Ch, 'a');
  Else
    result := 0; // ,  
  End;
End;

Function TfrmImportToProject.ConvertToInteger(str: String): integer;
Var
  i: integer;
  newpos: integer;
Begin
  If (str = '') Then
  Begin
    result := -1;
  End
  Else If trystrtoint(str, newpos) Then
  Begin
    result := newpos - 1;
  End
  Else If Length(str) > 1 Then
    result := -1
  Else
  Begin
    newpos := LetterNumber(str[1]);
    If newpos > -1 Then
      result := newpos - 1
    Else
      result := -1;
  End;
End;

Function TfrmImportToProject.MyStrToReal(input: String): real;
Var
  i, t: integer;
  o, n: String;
  tr: extended;
Begin
  For i := 1 To Length(input) Do
  Begin
    n := input[i];
    If (n = '.') Or (n = ',') Then
      o := o + ',';
    If trystrtoint(n, t) Then
      o := o + n;
  End;
  If TryStrToFloat(o, tr) Then
  Begin
    result := Round(tr * 100) / 100;
  End
  Else
    result := 0;
End;

procedure TfrmImportToProject.FormActivate(Sender: TObject);
begin
  Pages.ActivePage := TabCategory;
end;

procedure TfrmImportToProject.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  AbortProgress := true;
  frmMain.SaveSettings;
end;

procedure TfrmImportToProject.FormCreate(Sender: TObject);
begin
  xf := TXLSFile.Create;
end;

procedure TfrmImportToProject.FormDestroy(Sender: TObject);
begin
  xf.Destroy;
end;

procedure TfrmImportToProject.FormShow(Sender: TObject);
begin
  Pages.ActivePage := TabCategory;
  TTemplate.Active := true;
  InProgress := false;
  if ExcelFilenameEdit.FileName <> '' then
    if not FileExists(ExcelFilenameEdit.FileName) then
      ExcelFilenameEdit.FileName := '';
end;

end.
