unit ImportPrices;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, AdvUtil, Vcl.Grids, AdvObj, BaseGrid,
  AdvGrid, Vcl.StdCtrls, Vcl.Mask, JvExMask, JvToolEdit, Vcl.ExtCtrls,
  tmsAdvGridExcel, AdvGridColPicker, QImport3Wizard, JvCsvData, Data.DB,
  JvMemoryDataset, QImport3, QImport3XMLBased, QImport3Xlsx, QImport3XLS, QImport3Common,
  QImport3ODS, Vcl.ComCtrls, FireDAC.Stan.Intf, FireDAC.Stan.Option, QImport3XLSFile,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf, FireDAC.Comp.DataSet, FireDAC.Comp.Client, Vcl.DBGrids,
  Vcl.Menus, JvExComCtrls, JvDBTreeView, Vcl.Tabs, JvExStdCtrls, JvButton,
  JvCtrls, JvFooter, JvExExtCtrls, JvExtComponent, FireDAC.Stan.Async, Registry,
  FireDAC.DApt, System.Actions, Vcl.ActnList, AdvGridActns;

type
  TfrmImportPrices = class(TForm)
    PanelFile: TPanel;
    Label5: TLabel;
    ExcelFilenameEdit: TJvFilenameEdit;
    PanelHeader: TPanel;
    Pages: TPageControl;
    TabSheetPreview: TTabSheet;
    TabSheetResult: TTabSheet;
    pmPreview: TPopupMenu;
    mi1: TMenuItem;
    mi2: TMenuItem;
    mi3: TMenuItem;
    mi4: TMenuItem;
    mi5: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    Sheets: TTabSet;
    PanelSaveLeft: TPanel;
    PanelSaveRight: TPanel;
    CatalogTree: TJvDBTreeView;
    Label8: TLabel;
    ListPrices: TListBox;
    Label1: TLabel;
    EditPriceTag: TEdit;
    Label2: TLabel;
    Footer: TJvFooter;
    btnClose: TJvFooterBtn;
    btnImport: TJvFooterBtn;
    MyQuery: TFDQuery;
    CheckExportToPrices: TCheckBox;
    CheckNoCategory: TCheckBox;
    CheckWithCategory: TCheckBox;
    pmPrices: TPopupMenu;
    N8: TMenuItem;
    TTemplate: TFDQuery;
    DSTemplate: TDataSource;
    Panel2: TPanel;
    Button1: TButton;
    TimerUpdate: TTimer;
    PanelPreview: TPanel;
    THardware: TFDQuery;
    CheckProject: TCheckBox;
    Label3: TLabel;
    TabSheet1: TTabSheet;
    PanelArticles: TPanel;
    N9: TMenuItem;
    N10: TMenuItem;
    ActionList1: TActionList;
    AdvStringGridCopy1: TAdvStringGridCopy;
    NewGrid: TAdvStringGrid;
    pmNewArticles: TPopupMenu;
    AdvStringGridCopy11: TMenuItem;
    PreviewGrid: TAdvStringGrid;
    N11: TMenuItem;
    AdvStringGridCut1: TAdvStringGridCut;
    N14: TMenuItem;
    mi6: TMenuItem;
    CheckProjectUpdate: TCheckBox;
    AdvStringGridPaste1: TAdvStringGridPaste;
    N1: TMenuItem;
    N2: TMenuItem;
    actPreviewClear: TAction;
    N4: TMenuItem;
    TabPrices: TTabSheet;
    N3: TMenuItem;
    PriceGrid: TAdvStringGrid;
    pmPricePreview: TPopupMenu;
    N5: TMenuItem;
    procedure ExcelFilenameEditChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure PreviewGridMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PreviewGridMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ChangeKind(Sender: TObject);
    procedure SheetsChange(Sender: TObject; NewTab: Integer; var AllowChange: Boolean);
    procedure TabSheetResultResize(Sender: TObject);
    procedure btnImportClick(Sender: TObject);
    procedure OnlyCategoryClick(Sender: TObject);
    procedure PagesChange(Sender: TObject);
    procedure CheckWithCategoryClick(Sender: TObject);
    procedure CheckNoCategoryClick(Sender: TObject);
    procedure CheckExportToPricesClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnCloseClick(Sender: TObject);
    procedure N8Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TimerUpdateTimer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure N9Click(Sender: TObject);
    procedure actPreviewClearExecute(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure ListPricesDblClick(Sender: TObject);
    procedure N5Click(Sender: TObject);
  private
    filename: string;
    ext: string;

    current_projectname: string;
    current_projectno: Integer;
    current_projectsystemname: string;
    current_projectsystemno: Integer;

    procedure LoadPage(pageindex: Integer);

    procedure LoadFromXLS(pageindex: Integer);
    procedure LoadFromXLSX(pageindex: Integer);
    procedure LoadFromODS(pageindex: Integer);

    procedure DetectColumns;
    procedure ChangeExportKind;
    function GetPricesID(pricename: string): Integer;
    procedure ReadSettings;
    procedure SaveSettings;
    function Clean(val: string): string;
    procedure PriceDelete;
    function GetPriceList: tstringlist;
    procedure DoExportToPrices;
    procedure DoUpdateWithCategory;
    procedure DoUpdateWithoutCategory;
    procedure ReadLine(i: Integer);
    procedure DoUpdateProject;
    procedure CompareArticles;
    procedure PricePreview;
    { Private declarations }
  public
    pricelist: tstringlist;
    col_article, col_price, col_hardware, col_developer, col_comment, col_count: Integer;
    //   
    article, price, hardware, developer, comment, count: string;
    price_f: double;
    count_i: Integer;
    { Public declarations }
  end;

var
  frmImportPrices: TfrmImportPrices;

implementation

{$R *.dfm}

uses Main, Project, Universal, hardware;

procedure TfrmImportPrices.ExcelFilenameEditChange(Sender: TObject);
begin
  TimerUpdate.Enabled := false;
  TimerUpdate.Enabled := true;
end;

procedure TfrmImportPrices.LoadPage(pageindex: Integer);
begin
  if ext = '.xls' then
    LoadFromXLS(pageindex);
  if ext = '.xlsx' then
    LoadFromXLSX(pageindex);
  if ext = '.ods' then
    LoadFromODS(pageindex);
end;

procedure TfrmImportPrices.actPreviewClearExecute(Sender: TObject);
begin
  PreviewGrid.RowCount := PreviewGrid.FixedRows + 1;
  PreviewGrid.ClearRows(1, 1);
end;

procedure TfrmImportPrices.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmImportPrices.btnImportClick(Sender: TObject);
begin
  DetectColumns;

  if Pages.ActivePage <> TabSheetResult then
  begin
    if col_article = -1 then
    begin
      ShowMessage('    ');
    end
    else if col_price = -1 then
    begin
      ShowMessage('    ');
    end
    else
      Pages.ActivePage := TabSheetResult;
    exit;
  end;

  if Pages.ActivePage = TabSheetResult then
  begin
    if CheckExportToPrices.Checked then
      DoExportToPrices;
    if CheckWithCategory.Checked then
      DoUpdateWithCategory;
    if CheckNoCategory.Checked then
      DoUpdateWithoutCategory;
    if CheckProject.Checked then
      DoUpdateProject;
    Application.ProcessMessages;
    btnImport.Caption := ' ';
  end;
end;

procedure TfrmImportPrices.Button1Click(Sender: TObject);
begin
  PriceDelete;
end;

procedure TfrmImportPrices.ChangeKind(Sender: TObject);
var
  i: Integer;
  kind: string;
begin
  kind := (Sender as TMenuItem).Hint;

  //   , 
  for i := 0 to PreviewGrid.ColCount - 1 do
  begin
    if PreviewGrid.Cells[i, 0] = kind then
      PreviewGrid.Cells[i, 0] := '';
  end;
  // 
  PreviewGrid.Cells[PreviewGrid.Col, 0] := kind;
end;

procedure TfrmImportPrices.CheckExportToPricesClick(Sender: TObject);
begin
  ChangeExportKind;
end;

procedure TfrmImportPrices.CheckNoCategoryClick(Sender: TObject);
begin
  ChangeExportKind;
end;

procedure TfrmImportPrices.CheckWithCategoryClick(Sender: TObject);
begin
  ChangeExportKind;
end;

procedure TfrmImportPrices.PagesChange(Sender: TObject);
begin
  btnImport.Caption := '';

  NewGrid.Visible := false;

  if Pages.ActivePage <> TabPrices then
    TabPrices.TabVisible := false;

  if Pages.ActivePageIndex = 2 then
  begin
    ListPrices.Items := GetPriceList;
  end;

  if Pages.ActivePageIndex = 1 then
  begin
    btnImport.Caption := ' ...';
    CompareArticles;
  end;
  if Pages.ActivePageIndex = 0 then
  begin
    btnImport.Caption := ' ...';
  end;
  // btnImport.Visible := (Pages.ActivePageIndex = 1);
end;

procedure TfrmImportPrices.PreviewGridMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
  if Button = mbRight then
    (Sender as TStringGrid).Perform(WM_LBUTTONDOWN, 0, MakeLParam(Word(X), Word(Y)));
end;

procedure TfrmImportPrices.PreviewGridMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // pmPreview.Popup(mouse.CursorPos.X, mouse.CursorPos.Y);
end;

procedure TfrmImportPrices.SheetsChange(Sender: TObject; NewTab: Integer; var AllowChange: Boolean);
begin
  PreviewGrid.BeginUpdate;
  PreviewGrid.Visible := false;
  if NewTab > -1 then
  begin
    LoadPage(NewTab);
    PreviewGrid.Visible := true;
    PreviewGrid.EndUpdate;
  end;
end;

procedure TfrmImportPrices.TabSheetResultResize(Sender: TObject);
begin
  PanelSaveLeft.Width := TabSheetResult.Width div 2;
  PanelSaveRight.Width := TabSheetResult.Width div 2;
end;

procedure TfrmImportPrices.TimerUpdateTimer(Sender: TObject);
begin
  TimerUpdate.Enabled := false;

  if FileExists(ExcelFilenameEdit.filename) and (ExcelFilenameEdit.filename <> filename) then
  begin
    filename := ExcelFilenameEdit.Text;
    ext := ExtractFileExt(filename);
    Pages.ActivePage := TabSheetPreview;
    PreviewGrid.Visible := false;
    PreviewGrid.ColCount := 1;

    PreviewGrid.RowCount := PreviewGrid.FixedRows + 1;
    PreviewGrid.ClearRows(1, 1);

    Sheets.Tabs.Clear;
    Application.ProcessMessages;

    if ext = '.xls' then
      LoadFromXLS(-1);
    if ext = '.xlsx' then
      LoadFromXLSX(-1);
    if ext = '.ods' then
      LoadFromODS(-1);

    PreviewGrid.Visible := true;
  end;
end;

procedure TfrmImportPrices.N3Click(Sender: TObject);
begin
  PricePreview;
end;

procedure TfrmImportPrices.N5Click(Sender: TObject);
begin
  Pages.ActivePage := TabSheetResult;
  TabPrices.TabVisible := false;
end;

procedure TfrmImportPrices.PricePreview;
var
  pricelist: string;
  i, id: Integer;
begin
  if ListPrices.ItemIndex < 0 then
    exit;

  pricelist := ListPrices.Items[ListPrices.ItemIndex];
  pricelist := Copy(pricelist, 1, pos(' [', pricelist) - 1);

  id := GetPricesID(pricelist);

  i := 0;
  if id > -1 then
    try
      TabPrices.Caption := ' "' + pricelist + '"';
      TabPrices.Visible := true;
      PriceGrid.Cells[0, 0] := '';
      PriceGrid.Cells[1, 0] := '';
      PriceGrid.Cells[2, 0] := '';

      MyQuery.SQL.Text := 'SELECT * FROM `uni_prices` WHERE `pricelist`=:id;';
      MyQuery.ParamByName('id').AsInteger := id;
      MyQuery.Active := true;
      PriceGrid.RowCount := MyQuery.RecordCount + 1;
      while not MyQuery.Eof do
      begin
        inc(i);
        PriceGrid.Cells[0, i] := MyQuery.FieldByName('name').AsString;
        PriceGrid.Cells[1, i] := MyQuery.FieldByName('article').AsString;
        PriceGrid.Cells[2, i] := MyQuery.FieldByName('price').AsString;
        MyQuery.Next;
      end;
      MyQuery.Close;
    except

    end;

  TabPrices.TabVisible := true;
  Pages.ActivePage := TabPrices;
end;

procedure TfrmImportPrices.N8Click(Sender: TObject);
begin
  PriceDelete;
end;

procedure TfrmImportPrices.N9Click(Sender: TObject);
begin
  ExcelFilenameEdit.DoClick;
end;

procedure TfrmImportPrices.PriceDelete;
var
  pricelist: string;
  id: Integer;
begin
  if ListPrices.ItemIndex < 0 then
  begin
    ShowMessage('     ');
    exit;
  end;

  pricelist := ListPrices.Items[ListPrices.ItemIndex];
  pricelist := Copy(pricelist, 1, pos(' [', pricelist) - 1);

  if (MessageDlg('     `' + pricelist + '`?', mtCustom, [mbYes, mbCancel], 0) = mrYes) then
    try
      id := GetPricesID(pricelist);

      MyQuery.SQL.Text := 'DELETE FROM `uni_pricelist` WHERE `rec_no`=:id;';
      MyQuery.ParamByName('id').AsInteger := id;
      MyQuery.ExecSQL;

      MyQuery.SQL.Text := 'DELETE FROM `uni_prices` WHERE `pricelist`=:id;';
      MyQuery.ParamByName('id').AsInteger := id;
      MyQuery.ExecSQL;

      MyQuery.Close;
    except

    end;
  Application.ProcessMessages;
  ListPrices.Items := GetPriceList; //  
end;

procedure TfrmImportPrices.OnlyCategoryClick(Sender: TObject);
begin
  ChangeExportKind;
end;

procedure TfrmImportPrices.FormActivate(Sender: TObject);
begin
  current_projectname := frmMain.current_projectname;
  current_projectno := frmMain.current_projectno;
  current_projectsystemname := frmMain.current_projectsystemname;
  current_projectsystemno := frmMain.current_projectsystemno;

  if (current_projectno > -1) and (current_projectsystemno > -1) then
  begin
    CheckProject.Enabled := true;
    CheckProjectUpdate.Enabled := true;
    CheckProject.Caption := ' ' + frmMain.current_projectcaption + ' / ' + current_projectsystemname;
  end
  else
  begin
    CheckProject.Enabled := false;
    CheckProject.Checked := false;
    CheckProjectUpdate.Enabled := false;
    CheckProject.Caption := '        ';
  end
end;

procedure TfrmImportPrices.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveSettings;
  Action := caFree;
end;

procedure TfrmImportPrices.FormCreate(Sender: TObject);
begin
  WindowState := frmMain.ws;
  pricelist := tstringlist.Create;
  PreviewGrid.ColWidths[0] := 30;
  Pages.ActivePage := TabSheetPreview;
  TabPrices.TabVisible := false;
end;

procedure TfrmImportPrices.FormDestroy(Sender: TObject);
begin
  pricelist.Free;
end;

procedure TfrmImportPrices.FormShow(Sender: TObject);
begin
  ReadSettings;
  ChangeExportKind;
  try
    TTemplate.Active := true;
  except
  end;
end;

function TfrmImportPrices.Clean(val: string): string;
begin
  result := trim(val);
  result := StringReplace(result, #13, '', [rfReplaceAll]);
  result := StringReplace(result, #10, '', [rfReplaceAll]);
end;

procedure TfrmImportPrices.ReadLine(i: Integer);
begin
  article := '';
  price := '';
  hardware := '';
  developer := '';
  comment := '';
  count := '';
  if col_article > -1 then
  begin
    article := Clean(PreviewGrid.Cells[col_article, i]);
  end;
  if col_price > -1 then
  begin
    price := Clean(PreviewGrid.Cells[col_price, i]);
  end;
  if col_hardware > -1 then
    hardware := Clean(PreviewGrid.Cells[col_hardware, i]);
  if col_developer > -1 then
    developer := Clean(PreviewGrid.Cells[col_developer, i]);
  if col_comment > -1 then
    comment := Clean(PreviewGrid.Cells[col_comment, i]);
  if col_count > -1 then
    count := Clean(PreviewGrid.Cells[col_count, i]);

  if not trystrtofloat(price, price_f) then
    price_f := -1;
  if not trystrtoint(count, count_i) then
    count_i := -1;
end;

procedure TfrmImportPrices.DoExportToPrices;
var
  i: Integer;
  PricesID: Integer;
  PriceTag: string;
  cnt_old: Integer;
  SQL: string;
begin
  DetectColumns;

  //   
  if (col_article < 0) or (col_price < 0) then
  begin
    ShowMessage('   .' + #13#10 +
      '            ');
    exit;
  end;
  if PreviewGrid.RowCount < 2 then
  begin
    ShowMessage('   ');
    exit;
  end;
  PriceTag := trim(EditPriceTag.Text);
  if length(PriceTag) < 1 then
  begin
    ShowMessage('  ');
    exit;
  end;

  PricesID := GetPricesID(PriceTag);
  ListPrices.Items := GetPriceList;
  Application.ProcessMessages;

  btnImport.Enabled := false;
  btnClose.Enabled := false;

  cnt_old := 0;
  formatSETTINGS.DecimalSeparator := '.';

  THardware.SQL.Clear;
  for i := 1 to PreviewGrid.RowCount - 1 do
  begin
    if (i div 100 = i / 100) then
    begin
      btnImport.Caption := '[' + i.ToString + ' / ' + (PreviewGrid.RowCount - 1).ToString + ']';
      Application.ProcessMessages;
      THardware.SQL.Add('COMMIT;');
      THardware.Execute;
      cnt_old := cnt_old + THardware.RowsAffected;
      THardware.SQL.Clear;
    end;

    ReadLine(i);
    if price_f > -1 then
      try
        SQL := 'DELETE FROM `uni_prices` WHERE `article`=' + QuotedStr(article) + ' AND pricelist=' +
          IntToStr(PricesID) + ';';
        THardware.SQL.Add(SQL);

        SQL := 'INSERT INTO `uni_prices` (`pricelist`,`name`,`article`,`price`) VALUES(' + IntToStr(PricesID) + ',' +
          QuotedStr(hardware) + ',' + QuotedStr(article) + ',' + FloatToStr(price_f) + ');';
        THardware.SQL.Add(SQL);
      except
      end;
  end;

  Try
    THardware.SQL.Add('COMMIT;');
    Application.ProcessMessages;
    THardware.Execute;
    cnt_old := cnt_old + THardware.RowsAffected;
  Except
  End;

  btnImport.Caption := '';
  btnImport.Enabled := true;
  btnClose.Enabled := true;

  try
    MyQuery.SQL.Text :=
      'UPDATE `uni_pricelist` SET `counter`=(SELECT COUNT(*) FROM `uni_prices` WHERE `pricelist`=:PricesID),`dt`=now() WHERE `rec_no`=:PricesID;';
    MyQuery.ParamByName('PricesID').AsInteger := PricesID;
    MyQuery.ExecSQL;
    MyQuery.Close;
  except
  end;

  ListPrices.Items := GetPriceList; //  
end;

function TfrmImportPrices.GetPricesID(pricename: string): Integer;
begin
  //    
  result := -1;
  MyQuery.SQL.Text := 'SELECT * FROM `uni_pricelist` WHERE `name`=:pricename';
  MyQuery.ParamByName('pricename').AsString := pricename;
  MyQuery.Active := true;
  while not MyQuery.Eof do
  begin
    result := MyQuery.FieldByName('rec_no').AsInteger;
    MyQuery.Next;
  end;
  if result < 0 then
  begin
    //  
    MyQuery.SQL.Text := 'INSERT INTO `uni_pricelist` (`name`,`username`,`dt`) VALUES(:name,:username,:dt);';
    MyQuery.ParamByName('name').AsString := pricename;
    MyQuery.ParamByName('username').AsString := frmMain.username;
    MyQuery.ParamByName('dt').AsDateTime := now();
    MyQuery.ExecSQL;
    MyQuery.Close;

    MyQuery.SQL.Text := 'SELECT * FROM `uni_pricelist` WHERE `name`=:name;';
    MyQuery.ParamByName('name').AsString := pricename;
    MyQuery.Active := true;
    while not MyQuery.Eof do
    begin
      result := MyQuery.FieldByName('rec_no').AsInteger;
      MyQuery.Next;
    end;
  end;
end;

procedure TfrmImportPrices.DetectColumns;
var
  kind: string;
  i: Integer;
begin
  //  
  col_article := -1;
  col_price := -1;
  col_hardware := -1;
  col_developer := -1;
  col_comment := -1;
  col_count := -1;

  for i := 0 to PreviewGrid.ColCount - 1 do
  begin
    kind := PreviewGrid.Cells[i, 0];
    if kind = '' then
      col_article := i;
    if kind = '' then
      col_hardware := i;
    if kind = '' then
      col_price := i;
    if kind = '' then
      col_developer := i;
    if kind = '' then
      col_comment := i;
    if kind = '' then
      col_count := i;
  end;
end;

procedure TfrmImportPrices.ChangeExportKind;
begin
  CatalogTree.Enabled := CheckWithCategory.Checked;
  EditPriceTag.Enabled := CheckExportToPrices.Checked;
  // ListPrices.Enabled := CheckExportToPrices.Checked;
end;

function TfrmImportPrices.GetPriceList: tstringlist;
var
  item: string;
begin
  MyQuery.SQL.Text := 'SELECT * FROM `uni_pricelist` ORDER BY `dt` DESC;';
  MyQuery.Active := true;
  pricelist.Clear;
  while not MyQuery.Eof do
  begin
    item := MyQuery.FieldByName('name').AsString + ' [' + MyQuery.FieldByName('counter').AsString + '] / ' +
      MyQuery.FieldByName('username').AsString + ' / ' + DateTimeToStr(MyQuery.FieldByName('dt').AsDateTime);
    pricelist.Add(item);
    MyQuery.Next;
  end;
  result := pricelist;
end;

Procedure TfrmImportPrices.ReadSettings;
var
  i: Integer;
  tmp: tstringlist;
  Reg: TRegistry;
Begin
  Reg := TRegistry.Create;
  Try
    Reg.RootKey := HKEY_CURRENT_USER;
    If Reg.OpenKey('\Software\mysoftware\orderbase2\import', true) Then
    Begin
      If Reg.ValueExists('CheckNoCategory') Then
        CheckNoCategory.Checked := Reg.ReadBool('CheckNoCategory');
      If Reg.ValueExists('CheckWithCategory') Then
        CheckWithCategory.Checked := Reg.ReadBool('CheckWithCategory');
      If Reg.ValueExists('CheckExportToPrices') Then
        CheckExportToPrices.Checked := Reg.ReadBool('CheckExportToPrices');
      //
      If Reg.ValueExists('EditPriceTag') Then
        EditPriceTag.Text := Reg.ReadString('EditPriceTag');
    End;
  Finally
    Reg.Free;
  End;
End;

Procedure TfrmImportPrices.SaveSettings;
var
  i: Integer;
  Reg: TRegistry;
Begin
  Reg := TRegistry.Create;
  Try
    Reg.RootKey := HKEY_CURRENT_USER;
    If Reg.OpenKey('\Software\mysoftware\orderbase2\import', true) Then
    Begin
      Reg.WriteBool('CheckNoCategory', CheckNoCategory.Checked);
      Reg.WriteBool('CheckWithCategory', CheckWithCategory.Checked);
      Reg.WriteBool('CheckExportToPrices', CheckExportToPrices.Checked);
      Reg.WriteString('EditPriceTag', EditPriceTag.Text);
    End;
  Finally
    Reg.Free;
  End;
End;

Procedure TfrmImportPrices.DoUpdateWithoutCategory;
Var
  cnt_old: Integer;
  SQL: String;
  i: Integer;
Begin
  DetectColumns;

  //    
  btnImport.Enabled := false;
  btnClose.Enabled := false;

  cnt_old := 0;
  formatSETTINGS.DecimalSeparator := '.';

  THardware.SQL.Clear;
  for i := 1 to PreviewGrid.RowCount - 1 do
    Try
      if (i div 100 = i / 100) then
      begin
        btnImport.Caption := '[' + i.ToString + ' / ' + (PreviewGrid.RowCount - 1).ToString + ']';
        Application.ProcessMessages;
        THardware.SQL.Add('COMMIT;');
        THardware.Execute;
        cnt_old := cnt_old + THardware.RowsAffected;
        THardware.SQL.Clear;
      end;

      ReadLine(i);
      if price_f > -1 then
        try
          SQL := 'UPDATE `uni_hardware` SET ';
          If (hardware <> '') Then
            SQL := SQL + '`name`=' + QuotedStr(hardware) + ',';
          If (price <> '') Then
            SQL := SQL + '`price`=' + FloatToStr(price_f) + ',';
          If (developer <> '') Then
            SQL := SQL + '`developer`=' + QuotedStr(developer) + ',';
          If (comment <> '') Then
            SQL := SQL + '`comment`=' + QuotedStr(comment) + ',';
          SQL := SQL + '`lastupdate`=now()';
          SQL := SQL + ' WHERE `article`=' + QuotedStr(article) + ';';
          THardware.SQL.Add(SQL);
        except
        end;

    Except
    End;

  Try
    THardware.SQL.Add('COMMIT;');
    Application.ProcessMessages;
    THardware.Execute;
    cnt_old := cnt_old + THardware.RowsAffected;
  Except
  End;

  btnImport.Caption := '';
  btnImport.Enabled := true;
  btnClose.Enabled := true;

  if frmHardware <> nil then
    frmHardware.TimerSearchUpdate.Enabled := true;

End;

Procedure TfrmImportPrices.DoUpdateWithCategory;
Var
  i_category: Integer;
  cnt_new, cnt_old: Integer;
  hf: String;
  i: Integer;
Begin
  DetectColumns;

  //    
  btnImport.Enabled := false;
  btnClose.Enabled := false;

  cnt_new := 0;
  cnt_old := 0;

  i_category := TTemplate.FieldByName('rec_no').AsInteger;

  for i := 1 to PreviewGrid.RowCount - 1 do
    try
      if (i div 100 = i / 100) then
      begin
        btnImport.Caption := '[' + i.ToString + ' / ' + (PreviewGrid.RowCount - 1).ToString + ']';
        Application.ProcessMessages;
      end;

      ReadLine(i);
      if price_f > -1 then
      begin
        THardware.SQL.Text := 'SELECT * FROM `uni_hardware` WHERE `kind`=' + IntToStr(i_category) + ' AND `article`=' +
          QuotedStr(article) + ' LIMIT 1;';

        THardware.Active := true;
        If (THardware.RecordCount > 0) Then
        Begin
          THardware.Edit;
          THardware.FieldByName('lastupdate').AsDateTime := now();
          If (hardware <> '') Then
            THardware.FieldByName('name').AsString := hardware;
          If (price <> '') Then
            THardware.FieldByName('price').AsFloat := price_f;
          If (developer <> '') Then
            THardware.FieldByName('developer').AsString := developer;
          If (comment <> '') Then
            THardware.FieldByName('comment').AsString := comment;
          THardware.Post;
          cnt_old := cnt_old + 1;
        End
        Else
        Begin
          THardware.Append;
          THardware.FieldByName('kind').AsString := IntToStr(i_category);
          THardware.FieldByName('article').AsString := article;
          THardware.FieldByName('lastupdate').AsDateTime := now();
          If (hardware <> '') Then
            THardware.FieldByName('name').AsString := hardware;
          If (price <> '') Then
            THardware.FieldByName('price').AsFloat := price_f;
          If (developer <> '') Then
            THardware.FieldByName('developer').AsString := developer;
          If (comment <> '') Then
            THardware.FieldByName('comment').AsString := comment;
          THardware.Post;
          cnt_new := cnt_new + 1;
        End;
      End;
    except
    End;

  btnImport.Caption := '';
  btnImport.Enabled := true;
  btnClose.Enabled := true;

  if frmHardware <> nil then
    frmHardware.TimerSearchUpdate.Enabled := true;

End;

Procedure TfrmImportPrices.DoUpdateProject;
Var
  i_category: Integer;
  Fields: String;
  i: Integer;
Begin
  DetectColumns;

  //   
  if current_projectsystemno < 0 then
    ShowMessage('   -1');

  btnImport.Enabled := false;
  btnClose.Enabled := false;

  i_category := TTemplate.FieldByName('rec_no').AsInteger;

  for i := 1 to PreviewGrid.RowCount - 1 do
  begin
    if (i div 10 = i / 10) then
    begin
      btnImport.Caption := '[' + i.ToString + ' / ' + (PreviewGrid.RowCount - 1).ToString + ']';
      Application.ProcessMessages;
    end;

    ReadLine(i);
    if length(article) > 0 then
      try
        if price_f < 0 then
          price_f := 0;
        if count_i < 0 then
          count_i := 1;

        MyQuery.SQL.Text :=
          'INSERT INTO `uni_projecthardware` (`project_no`,`system_no`,`name`,`article`,`developer`,`comment`,`price`,`count`) VALUES(:project_no,:system_no,:name,:article,:developer,:comment,:price,:count);';
        MyQuery.ParamByName('project_no').AsInteger := current_projectno;
        MyQuery.ParamByName('system_no').AsInteger := current_projectsystemno;

        MyQuery.ParamByName('article').AsString := article;
        MyQuery.ParamByName('name').AsString := hardware;
        MyQuery.ParamByName('developer').AsString := developer;
        MyQuery.ParamByName('comment').AsString := comment;
        MyQuery.ParamByName('price').AsFloat := price_f;
        MyQuery.ParamByName('count').AsInteger := count_i;
        MyQuery.ExecSQL;

        // ShowMessage(article);

      except
        ShowMessage('  ...');
      End;
  End;

  btnImport.Caption := '';
  btnImport.Enabled := true;
  btnClose.Enabled := true;

  Fields := 'kind,price,valuta,file,expire,kinddesc,name,comment,developer,modules,modules2,din';
  if CheckProjectUpdate.Checked then
    frmUniversal.UpdateProjectFromBase(current_projectno, current_projectsystemno, Fields, -1);

  frmMain.MDIExists(frmMain.current_projectcaption);
End;

Procedure TfrmImportPrices.CompareArticles;
var
  i: Integer;
begin
  DetectColumns;
  if col_article < 0 then
  begin
    PanelArticles.Caption := '   ';
    NewGrid.Visible := false;
    exit;
  end;

  PanelArticles.Caption := '  ...';
  btnImport.Enabled := false;
  NewGrid.RowCount := 2;
  NewGrid.FixedRows := 1;
  NewGrid.Cells[0, 0] := '';

  for i := 1 to PreviewGrid.RowCount - 1 do
  begin
    if (i div 10 = i / 10) then
    begin
      btnImport.Caption := '[' + i.ToString + ' / ' + (PreviewGrid.RowCount - 1).ToString + ']';
      Application.ProcessMessages;
    end;

    ReadLine(i);
    if length(article) > 0 then
      try
        MyQuery.SQL.Text := 'SELECT * FROM `uni_hardware` WHERE `article`=:article;';
        MyQuery.ParamByName('article').AsString := article;
        MyQuery.Active := true;
        if MyQuery.RecordCount = 0 then
        begin
          //  ,   
          NewGrid.Cells[0, NewGrid.RowCount - 1] := article;
          NewGrid.RowCount := NewGrid.RowCount + 1;
        end;
      except
      end;
  end;

  PanelArticles.Caption := '   ';
  NewGrid.Visible := NewGrid.RowCount > 1;

  NewGrid.RowCount := NewGrid.RowCount - 1;

  btnImport.Caption := '';
  btnImport.Enabled := true;
end;

procedure TfrmImportPrices.LoadFromXLS(pageindex: Integer);
var
  XLSFile: TXLSFile;
  i: Integer;
  Sheet: TXlsWorkSheet;
  SheetIndex, ColIndex, RowIndex: Integer;
  Cell: TbiffCell;
begin
  PanelPreview.Caption := '  ...';

  XLSFile := TXLSFile.Create;
  try
    XLSFile.filename := filename;
    try
      XLSFile.Load;
    except
      PanelPreview.Caption := '  ';
      pageindex := -2;
    end;

    if pageindex = -1 then
      try
        Sheets.Tabs.Clear;
        for i := 0 to XLSFile.Workbook.WorkSheets.count - 1 do
        begin
          Sheet := XLSFile.Workbook.WorkSheets[i];
          Sheets.Tabs.Add(Sheet.name);
        end;
        if Sheets.Tabs.count > 0 then
          Sheets.TabIndex := 0;
      except
        PanelPreview.Caption := '    ';
      end;

    if pageindex > -1 then
      try
        Sheet := XLSFile.Workbook.WorkSheets[pageindex];
        PreviewGrid.ColCount := Sheet.ColCount + 1;
        PreviewGrid.RowCount := Sheet.RowCount + 1;
        PreviewGrid.Visible := false;
        Application.ProcessMessages;
        for RowIndex := 0 to XLSFile.Workbook.WorkSheets[pageindex].Rows.count - 1 do
        begin
          // Cell := Sheet.Cell[0, RowIndex]; //  
          for ColIndex := 0 to XLSFile.Workbook.WorkSheets[pageindex].Rows[RowIndex].count - 1 do
          begin
            Cell := XLSFile.Workbook.WorkSheets[pageindex].Rows[RowIndex][ColIndex];
            if not Assigned(Cell) then
              Continue;
            PreviewGrid.Cells[Cell.Col + 1, Cell.Row + 1] := Cell.AsString;
          end;
        end;
        PreviewGrid.Visible := true;
      except
        PanelPreview.Caption := '   ';
      end;

  finally
    XLSFile.Free;
  end;

end;

procedure TfrmImportPrices.ListPricesDblClick(Sender: TObject);
begin
  PricePreview;
end;

procedure TfrmImportPrices.LoadFromODS(pageindex: Integer);
var
  ODSFile: TODSFile;
  i: Integer;
  Sheet: TODSSpreadSheet;
  SheetIndex, ColIndex, RowIndex: Integer;
  Cell: TODSCell;
begin
  PanelPreview.Caption := '  ...';

  ODSFile := TODSFile.Create;
  try
    ODSFile.filename := filename;
    try
      ODSFile.Load;
    except
      PanelPreview.Caption := '  ';
      pageindex := -2;
    end;

    if pageindex = -1 then
      try
        Sheets.Tabs.Clear;
        for i := 0 to ODSFile.Workbook.Sheets.count - 1 do
        begin
          Sheet := ODSFile.Workbook.Sheets[i];
          Sheets.Tabs.Add(Sheet.name);
        end;
        if Sheets.Tabs.count > 0 then
          Sheets.TabIndex := 0;
      except
        PanelPreview.Caption := '    ';
      end;

    if pageindex > -1 then
      try
        Sheet := ODSFile.Workbook.Sheets[pageindex];
        PreviewGrid.ColCount := Sheet.ColCount + 1;
        PreviewGrid.RowCount := Sheet.RowCount + 1;
        PreviewGrid.Visible := false;
        Application.ProcessMessages;
        for RowIndex := 0 to Sheet.RowCount - 1 do
        begin
          for ColIndex := 0 to Sheet.ColCount - 1 do
          begin
            Cell := Sheet.Cell[ColIndex, RowIndex];
            if not Assigned(Cell) then
              Continue;
            PreviewGrid.Cells[ColIndex + 1, RowIndex + 1] := Cell.Value;
          end;
        end;
        PreviewGrid.Visible := true;
      except
        PanelPreview.Caption := '   ';
      end;

  finally
    ODSFile.Free;
  end;
end;

procedure TfrmImportPrices.LoadFromXLSX(pageindex: Integer);
var
  XlsxFile: TXlsxFile;
  i: Integer;
  Sheet: TXlsxWorkSheet;
  SheetIndex, ColIndex, RowIndex: Integer;
  Cell: TXlsxCell;
begin
  PanelPreview.Caption := '  ...';

  XlsxFile := TXlsxFile.Create;
  try
    XlsxFile.filename := filename;
    try
      XlsxFile.Load;
    except
      PanelPreview.Caption := '  ';
      pageindex := -2;
    end;

    if pageindex = -1 then
      try
        Sheets.Tabs.Clear;
        for i := 0 to XlsxFile.Workbook.WorkSheets.count - 1 do
        begin
          Sheet := XlsxFile.Workbook.WorkSheets[i];
          Sheets.Tabs.Add(Sheet.name);
        end;
        if Sheets.Tabs.count > 0 then
          Sheets.TabIndex := 0;
      except
        PanelPreview.Caption := '    ';
      end;

    if pageindex > -1 then
      try
        Sheet := XlsxFile.Workbook.WorkSheets[pageindex];
        PreviewGrid.ColCount := Sheet.ColCount + 1;
        PreviewGrid.RowCount := Sheet.RowCount + 1;
        PreviewGrid.Visible := false;
        Application.ProcessMessages;
        for RowIndex := 0 to Sheet.RowCount - 1 do
        begin
          PreviewGrid.Cells[0, RowIndex + 1] := IntToStr(RowIndex + 1);
          for ColIndex := 0 to Sheet.ColCount - 1 do
          begin
            Cell := Sheet.Cell[ColIndex, RowIndex]; //  
            if not Assigned(Cell) then
              Continue;
            PreviewGrid.Cells[ColIndex + 1, RowIndex + 1] := Cell.Value;
          end;
        end;
        PreviewGrid.Visible := true;
      except
        PanelPreview.Caption := '   ';
      end;

  finally
    XlsxFile.Free;
  end;

end;

end.
