unit ImportData;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB,   Grids, DBGrids, JvExDBGrids, JvDBGrid,
  ExtCtrls, StdCtrls, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.Client,
  FireDAC.Comp.DataSet;

type
  TfrmImportData = class(TForm)
    TImport: TFDTable;
    DSImport: TDataSource;
    Panel1: TPanel;
    JvDBGrid1: TJvDBGrid;
    ListParent: TListBox;
    QueryTop: TFDQuery;
    TTree: TFDTable;
    DSTree: TDataSource;
    DSUnits: TDataSource;
    TUnits: TFDTable;
    TAtt: TFDTable;
    DSAtt: TDataSource;
    Button1: TButton;
    ListParentDescription: TListBox;
    Button2: TButton;
    ListBase: TMemo;
    Label1: TLabel;
    EditReq: TEdit;
    TAttrec_no: TIntegerField;
    TAttparent: TIntegerField;
    TAttactive: TIntegerField;
    TAttkind: TStringField;
    TAttname: TStringField;
    TAttcontent: TMemoField;
    TUnitsrec_no: TIntegerField;
    TUnitskind: TIntegerField;
    TUnitsparent: TIntegerField;
    TUnitsactive: TIntegerField;
    TUnitsalias: TStringField;
    TUnitsorderby: TIntegerField;
    TUnitsname: TStringField;
    TUnitskeywords: TStringField;
    TUnitsprice: TFloatField;
    TUnitsvaluta: TStringField;
    TUnitslanguage: TStringField;
    TTreerec_no: TIntegerField;
    TTreekind: TIntegerField;
    TTreeparent: TIntegerField;
    TTreeactive: TIntegerField;
    TTreealias: TStringField;
    TTreeorderby: TIntegerField;
    TTreename: TStringField;
    TTreedescription: TMemoField;
    TTreekeywords: TStringField;
    TTreelanguage: TStringField;
    TTreesubdirs: TIntegerField;
    TTreesubunits: TIntegerField;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    procedure AddOne;
    procedure UpdateAtt(parent: integer; kind, name, content: string);
    { Private declarations }
  public
    tunnelupload: string;
    { Public declarations }
  end;

var
  frmImportData: TfrmImportData;

implementation

uses Main,Universal;
{$R *.dfm}

procedure TfrmImportData.AddOne;
var
  name, description: string;
  parent, i: integer;
  onlycategory: boolean;
begin
  //    
  ListParent.Clear;
  ListParentDescription.Clear;
  ListParent.Items.AddStrings(ListBase.Lines);
  for i := 0 to ListBase.Lines.Count - 1 do
    ListParentDescription.Items.Add('');

  name := TImport.FieldByName('name').AsString;
  description := TImport.FieldByName('longdesc').AsString;
  parent := TImport.FieldByName('parent').AsInteger;
  onlycategory := (TImport.FieldByName('iscategory').AsInteger = 1);
  if onlycategory then
  begin
    ListParent.Items.Add(name);
    ListParentDescription.Items.Add(description);
  end;
  while (parent > 0) do
  begin
    QueryTop.SQL.Text := 'SELECT * FROM ' + TImport.TableName + ' WHERE `num`='
      + inttostr(parent);
    QueryTop.Active := true;
    name := QueryTop.FieldByName('name').AsString;
    description := QueryTop.FieldByName('longdesc').AsString;
    parent := QueryTop.FieldByName('parent').AsInteger;
    ListParent.Items.insert(ListBase.Lines.Count, name);
    ListParentDescription.Items.insert(ListBase.Lines.Count, description);
  end;
  //    
  TTree.Active := true;
  //    ( )
  parent := 0;
  for i := 0 to ListParent.Items.Count - 1 do
  begin
    //  parent=parent & name=name
    if TTree.Locate('parent;name', VarArrayOf([parent, ListParent.Items[i]]
      ), []) then
    begin
      if (TTree.FieldByName('description').AsString = '') then
      begin
        TTree.Edit;
        TTree.FieldByName('description').AsString :=
          ListParentDescription.Items[i];
        TTree.Post;
      end;
      // next
      parent := TTree.FieldByName('rec_no').AsInteger;
    end
    else
    begin
      //  
      TTree.Append;
      TTree.FieldByName('parent').AsInteger := parent;
      TTree.FieldByName('name').AsString := ListParent.Items[i];
      TTree.FieldByName('description').AsString :=
        ListParentDescription.Items[i];
      TTree.FieldByName('kind').AsInteger := 0;
      TTree.FieldByName('active').AsInteger := 1;
      TTree.FieldByName('orderby').AsInteger := 0;
      TTree.FieldByName('alias').AsString :=
        frmMain.Translit(ListParent.Items[i]);
      TTree.Post;
      // next
      parent := TTree.FieldByName('rec_no').AsInteger;
    end;
  end;
  //   ( ) c parent=parent
  //     
  TUnits.Active := true;
  name := TImport.FieldByName('name').AsString;
  description := TImport.FieldByName('description').AsString;
  if not onlycategory then
  begin
    if TUnits.Locate('parent;name', VarArrayOf([parent, name]), []) then
    begin

    end
    else
    begin
      if (name = '') then
        name := 'temp' + inttostr(random(1000000) + 1000);

      TUnits.Append;
      TUnits.FieldByName('parent').AsInteger := parent;
      TUnits.FieldByName('name').AsString := name;
      TUnits.FieldByName('kind').AsInteger := 0;
      TUnits.FieldByName('active').AsInteger := 1;
      TUnits.FieldByName('orderby').AsInteger := 0;
      if TImport.FieldByName('alias').AsString <> '' then
      begin
        TUnits.FieldByName('alias').AsString :=
          frmMain.Translit(TImport.FieldByName('alias').AsString)
      end
      else
      begin
        TUnits.FieldByName('alias').AsString := frmMain.Translit(name);
      end;
      TUnits.FieldByName('keywords').AsString :=
        TImport.FieldByName('keywords').AsString;
      TUnits.FieldByName('price').AsFloat :=
        TImport.FieldByName('price').AsFloat;
      TUnits.FieldByName('valuta').AsString := 'RUB';
      TUnits.FieldByName('language').AsString :=
        TImport.FieldByName('language').AsString;
      TUnits.Post;
    end;
    TUnits.First;
    if TUnits.Locate('parent;name', VarArrayOf([parent, name]), []) then
    begin
      //  
      UpdateAtt(TUnits.FieldByName('rec_no').AsInteger, 'TEXT', '',
        TImport.FieldByName('longdesc').AsString);
      UpdateAtt(TUnits.FieldByName('rec_no').AsInteger, 'TEXT', '',
        description);
      UpdateAtt(TUnits.FieldByName('rec_no').AsInteger, 'IMAGE', '',
        '/content/' + TImport.FieldByName('screenshot').AsString);
      UpdateAtt(TUnits.FieldByName('rec_no').AsInteger, 'PREVIEW', '',
        '/content/' + TImport.FieldByName('thumbshot').AsString);
    end;

  end;
end;

procedure TfrmImportData.Button1Click(Sender: TObject);
begin
  TImport.TableName := EditReq.Text;
  TImport.Active := true;
  TAtt.Active := true;
  while not TImport.Eof do
  begin
    AddOne;
    TImport.Next;
  end;
end;

procedure TfrmImportData.Button2Click(Sender: TObject);
begin
  TTree.EmptyDataSet;
  TUnits.EmptyDataSet;
  TAtt.EmptyDataSet;
end;

procedure TfrmImportData.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TfrmImportData.FormShow(Sender: TObject);
begin
    Caption := '';
  if not frmUniversal.DBConnected then close;
end;

procedure TfrmImportData.UpdateAtt(parent: integer;
  kind, name, content: string);
begin
  //    
  // TAtt.First;
  if TAtt.Locate('parent;name;kind', VarArrayOf([parent, name, kind]), []) then
  begin
    //  content
    TAtt.Edit;
    TAtt.FieldByName('content').AsString := content;
    TAtt.FieldByName('active').AsInteger := 1;
    TAtt.Post;
  end
  else
  begin
    //  
    TAtt.Append;
    TAtt.FieldByName('parent').AsInteger := parent;
    TAtt.FieldByName('name').AsString := name;
    TAtt.FieldByName('kind').AsString := kind;
    TAtt.FieldByName('content').AsString := content;
    TAtt.FieldByName('active').AsInteger := 1;
    TAtt.Post;
  end;
end;

end.
