unit ImageProcess;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvComponentBase, JvComputerInfoEx, GDIPOBJ, Vcl.ExtCtrls;

type
  TfrmImageProcess = class(TForm)
    ComputerInfo: TJvComputerInfoEx;
    Pic: TImage;
    procedure FormCreate(Sender: TObject);
  private
    procedure DoFit(src, dst: string; fsize: integer);
    { Private declarations }
  public
    SrcFileName: string;
    DstFileNameImage: string;
    DstFileNameThumb: string;
    FitSizeImage: integer;
    FitSizeThumb: integer;
    function GetTempFile(Prefix, Extension: string): string;
    procedure DoFitAll;
    { Public declarations }
  end;

var
  frmImageProcess: TfrmImageProcess;

implementation

{$R *.dfm}

procedure TfrmImageProcess.DoFitAll;
begin
  //  2  
  DstFileNameThumb := GetTempFile('thumb', '.jpg');
  DstFileNameImage := GetTempFile('image', '.jpg');
  DoFit(SrcFileName, DstFileNameThumb, FitSizeThumb);
  DoFit(SrcFileName, DstFileNameImage, FitSizeImage);
end;

procedure TfrmImageProcess.FormCreate(Sender: TObject);
begin
  FitSizeImage := 700;
  FitSizeThumb := 200;
end;

procedure TfrmImageProcess.DoFit(src, dst: string; fsize: integer);
var
  ImageTemp: TGPImage;
  graphicsGDIPlus: TGPGraphics;
  SrcWidth, SrcHeight: integer;
  DstWidth, DstHeight: integer;
begin
  if FileExists(src) then
    try
      ImageTemp := TGPImage.Create(src);
      SrcWidth := ImageTemp.GetWidth;
      SrcHeight := ImageTemp.GetHeight;
      DstWidth := 200;
      DstHeight := 200;
      if fsize > 0 then
      begin
        if SrcWidth > SrcHeight then
        begin
          DstWidth := fsize;
          DstHeight := Round(SrcHeight / (SrcWidth / fsize));
        end
        else
        begin
          DstWidth := Round(SrcWidth / (SrcHeight / fsize));
          DstHeight := fsize;
        end;
      end;
      Pic.Width := DstWidth;
      Pic.Height := DstHeight;
      graphicsGDIPlus := TGPGraphics.Create(Pic.Canvas.Handle);
      graphicsGDIPlus.DrawImage(ImageTemp, 0, 0, DstWidth, DstHeight);
      ImageTemp.free;
      graphicsGDIPlus.free;
      Pic.Picture.SaveToFile(dst);
    except
      ShowMessage(' ImageProcess.Dofit');
    end;
end;

function TfrmImageProcess.GetTempFile(Prefix, Extension: string): string;
var
  fn, tmpdir: string;
  i: integer;
begin
  tmpdir := ComputerInfo.Folders.Temp;
  i := random(1000000);
  fn := tmpdir + '\' + Prefix + inttostr(i) + Extension;
  while FileExists(fn) do
  begin
    inc(i);
    fn := tmpdir + Prefix + inttostr(i) + Extension;
  end;
  result := fn;
end;

end.
