Unit Hardware;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, JvExDBGrids, JvDBGrid, DB,
  Menus, JvMenus, ActnList, JvExControls, JvDBLookupTreeView,
  ComCtrls, ToolWin, JvExComCtrls, JvDBTreeView, JvDBLookup, StdCtrls,
  JvExStdCtrls, JvCombobox, JvDBCombobox, JvEdit, JvDBSearchEdit, ExtCtrls,
  JvDialogs, IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient,
  IdExplicitTLSClientServerBase, JvBaseDlg, JvSelectDirectory,
  JvComponentBase, JvFormPlacement, ImgList, ShellAPI, System.Actions,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client,
  AdvSearchList, AdvSearchEdit, AdvEdit, DBAdvEd, tmsAdvGridExcel, AdvUtil,
  AdvObj, BaseGrid, AdvGrid, DBAdvGrid;

Type
  TfrmHardware = Class(TForm)
    MainMenu: TMainMenu;
    N12: TMenuItem;
    N15: TMenuItem;
    N14: TMenuItem;
    N13: TMenuItem;
    Actions: TActionList;
    actAdd: TAction;
    actEdit: TAction;
    actDelete: TAction;
    pmHardware: TPopupMenu;
    DSHardware: TDataSource;
    DSTemplate: TDataSource;
    CatalogTree: TJvDBTreeView;
    PanelSearch: TPanel;
    Label1: TLabel;
    PanelFilterCategory: TPanel;
    AllCategories: TRadioButton;
    OnlyCategory: TRadioButton;
    TTemplate: TFDQuery;
    _Search: TEdit;
    TAtt: TFDQuery;
    DSAtt: TDataSource;
    DSDefFields: TDataSource;
    TDefFields: TFDQuery;
    actSelectAll: TAction;
    actUpdate: TAction;
    actUpdate1: TMenuItem;
    Label2: TLabel;
    _SearchDeveloper: TJvComboBox;
    MyQuery1: TFDQuery;
    TreeMenu: TPopupMenu;
    MenuItem6: TMenuItem;
    actAttEdit: TAction;
    actAttSaveToFile: TAction;
    N8: TMenuItem;
    actAttSaveToFile1: TMenuItem;
    Cthnbabrfns1: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    dlgOpen: TJvOpenDialog;
    dlgSelDirectory: TJvSelectDirectory;
    dlgSave: TSaveDialog;
    actAutoSize: TAction;
    FormStorage: TJvFormStorage;
    actAttDelete: TAction;
    N9: TMenuItem;
    N10: TMenuItem;
    N11: TMenuItem;
    actFindLost: TAction;
    N16: TMenuItem;
    N17: TMenuItem;
    N18: TMenuItem;
    actMove: TAction;
    actAddCopy: TAction;
    N21: TMenuItem;
    THardware: TFDQuery;
    actAttOpen: TAction;
    N22: TMenuItem;
    actAttExpire: TAction;
    actAttExpire1: TMenuItem;
    GridDetails: TJvDBGrid;
    TimerUpdateDetails: TTimer;
    TDetails: TFDQuery;
    DSDetails: TDataSource;
    N23: TMenuItem;
    N25: TMenuItem;
    N26: TMenuItem;
    N27: TMenuItem;
    N28: TMenuItem;
    N29: TMenuItem;
    TimerSearchUpdate: TTimer;
    Panel6: TPanel;
    LabelInfo: TLabel;
    N1: TMenuItem;
    N2: TMenuItem;
    MicrosoftExcel1: TMenuItem;
    pmDetails: TPopupMenu;
    MenuItem16: TMenuItem;
    N3: TMenuItem;
    HardwareGrid: TDBAdvGrid;
    btnSearch: TButton;
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    Procedure FormShow(Sender: TObject);
    Procedure actAddExecute(Sender: TObject);
    Procedure actEditExecute(Sender: TObject);
    Procedure actDeleteExecute(Sender: TObject);
    Procedure actEditUpdate(Sender: TObject);
    Procedure actDeleteUpdate(Sender: TObject);
    Procedure AllCategoriesClick(Sender: TObject);
    Procedure THardwareAfterScroll(DataSet: TDataSet);
    Procedure _SearchChange(Sender: TObject);
    Procedure CatalogTreeChange(Sender: TObject; Node: TTreeNode);
    Procedure actAddUpdate(Sender: TObject);
    Procedure HardwareGridTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
    Procedure HardwareGridDblClick(Sender: TObject);
    Procedure actSelectAllExecute(Sender: TObject);
    Procedure actSelectAllUpdate(Sender: TObject);
    Procedure actUpdateExecute(Sender: TObject);
    Procedure actAttSaveToFileExecute(Sender: TObject);
    Procedure actAttEditExecute(Sender: TObject);
    Procedure actAttEditUpdate(Sender: TObject);
    Procedure actAttSaveToFileUpdate(Sender: TObject);
    Procedure actAutoSizeUpdate(Sender: TObject);
    Procedure actAutoSizeExecute(Sender: TObject);
    Procedure actAttDeleteUpdate(Sender: TObject);
    Procedure actAttDeleteExecute(Sender: TObject);
    Procedure PanelSearchResize(Sender: TObject);
    Procedure THardwareAfterOpen(DataSet: TDataSet);
    Procedure actFindLostExecute(Sender: TObject);
    Procedure actMoveExecute(Sender: TObject);
    Procedure actMoveUpdate(Sender: TObject);
    Procedure actAddCopyUpdate(Sender: TObject);
    Procedure actAddCopyExecute(Sender: TObject);
    procedure actAttOpenUpdate(Sender: TObject);
    procedure actAttOpenExecute(Sender: TObject);
    procedure actAttExpireUpdate(Sender: TObject);
    procedure actAttExpireExecute(Sender: TObject);
    procedure actFindLostUpdate(Sender: TObject);
    procedure HardwareGridKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure HardwareGridMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure TimerUpdateDetailsTimer(Sender: TObject);
    procedure TimerSearchUpdateTimer(Sender: TObject);
    procedure MouseWheelByOne(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
      var Handled: Boolean);
    procedure HardwareGridCellClick(Column: TColumn);
    procedure actUpdateUpdate(Sender: TObject);
    procedure HardwareGridClickSort(Sender: TObject; ACol: Integer);
    procedure _SearchKeyPress(Sender: TObject; var Key: Char);
    procedure btnSearchClick(Sender: TObject);
  Private
    procedure UpdateSelCount;
    procedure UpdateAtt;
    procedure ShowInfo;
    { Private declarations }
  Public
    tunnelupload: String;
    lastkind: Integer;
    Procedure UpdateData;
    { Public declarations }
  End;

Var
  frmHardware: TfrmHardware;

Implementation

Uses Main, HardwareAdd, HardwareDelete, FindLost, HardwareMove,
  CertificateExpireDate, Universal;

{$R *.dfm}

Procedure TfrmHardware.actAddUpdate(Sender: TObject);
Begin
  actAdd.Enabled := OnlyCategory.Checked and (frmMain.usergroup.Length > 1);
End;

Procedure TfrmHardware.actDeleteExecute(Sender: TObject);
Begin
  If frmHardwareDelete.ShowModal = mrOk Then
  Begin
    { If HardwareGrid.SelCount > 0 Then
      Begin
      HardwareGrid.SelectedRows.Delete;
      End
      Else }
    Begin
      If THardware.RecNo > 0 Then
        THardware.Delete;
    End;
    UpdateData;
  End;
End;

Procedure TfrmHardware.actDeleteUpdate(Sender: TObject);
Begin
  actDelete.Enabled := (THardware.RecNo > 0) and (frmMain.usergroup.Length > 1);
End;

Procedure TfrmHardware.actEditUpdate(Sender: TObject);
Begin
  actEdit.Enabled := (THardware.RecNo > 0) and (frmMain.usergroup.Length > 1);
End;

Procedure TfrmHardware.actMoveUpdate(Sender: TObject);
Begin
  actMove.Enabled := (THardware.RecNo > 0) and (frmMain.usergroup.Length > 1);
End;

Procedure TfrmHardware.actSelectAllExecute(Sender: TObject);
Begin
  HardwareGrid.SelectAll;
End;

Procedure TfrmHardware.actSelectAllUpdate(Sender: TObject);
Begin
  actSelectAll.Enabled := (THardware.RecordCount > 0);
End;

Procedure TfrmHardware.actUpdateExecute(Sender: TObject);
Begin
  UpdateData;
End;

procedure TfrmHardware.actUpdateUpdate(Sender: TObject);
begin
  actUpdate.Enabled := true;
end;

Procedure TfrmHardware.CatalogTreeChange(Sender: TObject; Node: TTreeNode);
Var
  TemplateNo: Integer;
Begin
  TemplateNo := TTemplate.FieldByName('rec_no').AsInteger;
  TDefFields.SQL.Text := 'SELECT * FROM `uni_templatesfields` WHERE `parent`=:parent';
  TDefFields.ParamByName('parent').AsInteger := TemplateNo;
  TDefFields.Active := true;
  //
  UpdateData;
  //
End;

Procedure TfrmHardware.FormClose(Sender: TObject; Var Action: TCloseAction);
Begin
  FormStorage.SaveFormPlacement;
  Action := caFree;
End;

procedure TfrmHardware.FormCreate(Sender: TObject);
begin
  // WindowState := frmMain.ws;
end;

Procedure TfrmHardware.FormShow(Sender: TObject);
Var
  tmp: String;
Begin
  if not frmUniversal.DBConnected then
    close;

  Try
    TTemplate.Active := true;
  Except
    showmessage('   ?');
  End;

  Try
    //  
    _SearchDeveloper.Clear;
    MyQuery1.SQL.Text := 'SELECT `developer` FROM `uni_hardware` GROUP BY `developer`;';
    MyQuery1.Active := true;
    While Not MyQuery1.eof Do
    Begin
      tmp := Trim(MyQuery1.Fields[0].AsString);
      If tmp <> '' Then
        _SearchDeveloper.Items.Add(MyQuery1.Fields[0].AsString);
      MyQuery1.Next;
    End;
  Except
  End;

  CatalogTree.Visible := OnlyCategory.Checked;
  Application.ProcessMessages;

  TimerSearchUpdate.Enabled := true;

  // user settings
  // FormStorage.RestoreFormPlacement;
End;

Procedure TfrmHardware.PanelSearchResize(Sender: TObject);
Var
  ns: Integer;
Begin
  ns := 100;
  If PanelSearch.Width > 180 Then
    ns := (PanelSearch.Width - 120);
  _Search.Width := ns;
  _SearchDeveloper.Width := ns;
End;

Procedure TfrmHardware.AllCategoriesClick(Sender: TObject);
Begin
  CatalogTree.Visible := OnlyCategory.Checked;
  Application.ProcessMessages;
  // UpdateData;
  TimerSearchUpdate.Enabled := false;
  TimerSearchUpdate.Enabled := true;
End;

procedure TfrmHardware.btnSearchClick(Sender: TObject);
begin
    TimerSearchUpdate.Enabled := false;
    UpdateData;
end;

procedure TfrmHardware.HardwareGridCellClick(Column: TColumn);
begin
  ShowInfo;
end;

procedure TfrmHardware.HardwareGridClickSort(Sender: TObject; ACol: Integer);
begin
  TimerSearchUpdate.Enabled := false;
  TimerSearchUpdate.Enabled := true;
end;

Procedure TfrmHardware.HardwareGridDblClick(Sender: TObject);
Var
  AMousePos: TPoint;
  ARow: Integer;
Begin
  //     
  AMousePos := HardwareGrid.ScreenToClient(Mouse.CursorPos);
  ARow := HardwareGrid.MouseCoord(AMousePos.X, AMousePos.Y).Y;
  If ARow = -1 Then
    Exit;
  frmMain.actProjectHardwareAdd.Execute;
End;

procedure TfrmHardware.HardwareGridKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  UpdateSelCount;
end;

procedure TfrmHardware.HardwareGridMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  UpdateSelCount;
end;

procedure TfrmHardware.MouseWheelByOne(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
  var Handled: Boolean);
var
  Direction: Shortint;
begin
  Direction := 1;
  if WheelDelta = 0 then
    Exit
  else if WheelDelta > 0 then
    Direction := -1;

  Handled := true;
  with TJvDBGrid(Sender) do
  begin
    if Assigned(DataSource) and Assigned(DataSource.DataSet) then
      DataSource.DataSet.MoveBy(Direction);
    Invalidate;
  end;
end;

Procedure TfrmHardware.THardwareAfterOpen(DataSet: TDataSet);
var
  i: Integer;
  fn, cn: string;
Begin

  (THardware.FieldByName('price') As TFloatField).DisplayFormat := ',0.00';
  (THardware.FieldByName('modules') As TFloatField).DisplayFormat := ',0.00';

  HardwareGrid.ColCount := 9;

  HardwareGrid.Columns[0].FieldName := 'kinddesc';
  HardwareGrid.Columns[0].Header := '';

  HardwareGrid.Columns[1].FieldName := 'article';
  HardwareGrid.Columns[1].Header := '';

  HardwareGrid.Columns[2].FieldName := 'name';
  HardwareGrid.Columns[2].Header := '';

  HardwareGrid.Columns[3].FieldName := 'comment';
  HardwareGrid.Columns[3].Header := '';

  HardwareGrid.Columns[4].FieldName := 'price';
  HardwareGrid.Columns[4].Header := '';

  HardwareGrid.Columns[5].FieldName := 'developer';
  HardwareGrid.Columns[5].Header := '';

  HardwareGrid.Columns[6].FieldName := 'expire'; // file
  HardwareGrid.Columns[6].Header := ' .';

  HardwareGrid.Columns[7].FieldName := 'modules';
  HardwareGrid.Columns[7].Header := '';

  HardwareGrid.Columns[8].FieldName := 'tkind';
  HardwareGrid.Columns[8].Header := '';



  // HardwareGrid.ColWidths[0] := 0;

  {
    for i := 0 to HardwareGrid.ColCount - 1 do
    begin
    cn := '';
    fn := HardwareGrid.Columns[i].FieldName;
    if fn = 'kinddesc' then
    HardwareGrid.Columns[i].Header := '';
    if fn = 'article' then
    HardwareGrid.Columns[i].Header := '';
    if fn = 'rec_no' then
    HardwareGrid.ColWidths[i] := 0;
    if fn = 'kind' then
    HardwareGrid.ColWidths[i] := 0;
    if fn = 'din' then
    HardwareGrid.ColWidths[i] := 0;
    if fn = 'username' then
    HardwareGrid.ColWidths[i] := 0;
    if fn = 'modules2' then
    HardwareGrid.ColWidths[i] := 0;
    if fn = 'expire' then
    HardwareGrid.ColWidths[i] := 0;
    if fn = 'lastupdate' then
    HardwareGrid.ColWidths[i] := 0;
    if fn = 'valuta' then
    HardwareGrid.ColWidths[i] := 0;

    if fn = 'name' then
    HardwareGrid.Columns[i].Header := '';
    if fn = 'comment' then
    HardwareGrid.Columns[i].Header := '';
    if fn = 'price' then
    HardwareGrid.Columns[i].Header := '';
    if fn = 'developer' then
    HardwareGrid.Columns[i].Header := '';
    if fn = 'file' then
    HardwareGrid.Columns[i].Header := ' .';
    if fn = 'tkind' then
    HardwareGrid.Columns[i].Header := '';
    if fn = 'modules' then
    HardwareGrid.Columns[i].Header := '';
    end;
  }

End;

Procedure TfrmHardware.ShowInfo;
Begin
  If THardware.RecNo > 0 Then
    frmMain.current_hardwareno := THardware.FieldByName('rec_no').AsInteger
  else
    frmMain.current_hardwareno := -1;

  TimerUpdateDetails.Enabled := false;
  TimerUpdateDetails.Enabled := true;
End;

Procedure TfrmHardware.THardwareAfterScroll(DataSet: TDataSet);
Begin
  ShowInfo;
End;

procedure TfrmHardware.TimerSearchUpdateTimer(Sender: TObject);
begin
  TimerSearchUpdate.Enabled := false;
  UpdateData;
end;

procedure TfrmHardware.TimerUpdateDetailsTimer(Sender: TObject);
begin
  TimerUpdateDetails.Enabled := false;
  UpdateAtt;
end;

Procedure TfrmHardware.UpdateAtt;
var
  info: string;
Begin
  info := '';
  If THardware.RecNo > 0 Then
    try
      MyQuery1.SQL.Text := 'SELECT * FROM `uni_hardware` WHERE `rec_no`=:rec_no';
      MyQuery1.ParamByName('rec_no').AsInteger := frmMain.current_hardwareno;
      MyQuery1.Active := true;
      if MyQuery1.RecordCount > 0 then
      begin
        lastkind := MyQuery1.FieldByName('kind').AsInteger;
        info := '';
        if not MyQuery1.FieldByName('lastupdate').IsNull then
          info := ' : ' + MyQuery1.FieldByName('username').AsString + ' / ' +
            DateTimeToStr(MyQuery1.FieldByName('lastupdate').AsDateTime);
      end;
    except
    end;

  frmMain.StatusBar.Panels[2].Text := info;

  TDetails.Active := false;
  If THardware.Active And (THardware.RecNo > 0) Then
  Begin
    TDetails.SQL.Text := 'SELECT * FROM `uni_attachment` WHERE parent=:rec_no';
    TDetails.ParamByName('rec_no').AsInteger := THardware.FieldByName('rec_no').AsInteger;
    TDetails.Active := true;
  End;
End;

Procedure TfrmHardware._SearchChange(Sender: TObject);
Begin
  TimerSearchUpdate.Enabled := false;
  if Length(_Search.Text) > 2 then
    TimerSearchUpdate.Enabled := true;
End;

procedure TfrmHardware._SearchKeyPress(Sender: TObject; var Key: Char);
begin
{  if (Key = #13) then
  begin
    TimerSearchUpdate.Enabled := false;
    UpdateData;
  end;
  }
end;

Procedure TfrmHardware.actEditExecute(Sender: TObject);
Var
  TemplateNo, HardwareNo: Integer;
  s1, s2: String;
Begin
  frmHardwareAdd.Caption := ' ';
  If THardware.State In [dsEdit, dsInsert] Then
    THardware.Post;
  frmHardwareAdd.Clear;
  TemplateNo := TTemplate.FieldByName('rec_no').AsInteger;
  HardwareNo := THardware.FieldByName('rec_no').AsInteger;
  frmHardwareAdd.CategoryNo := THardware.FieldByName('kind').AsInteger;
  frmHardwareAdd.HardwareNo := HardwareNo;
  frmHardwareAdd._article.Text := THardware.FieldByName('article').AsString;
  frmHardwareAdd._kinddesc.Text := THardware.FieldByName('kinddesc').AsString;
  frmHardwareAdd._name.Text := THardware.FieldByName('name').AsString;
  frmHardwareAdd._comment.Text := THardware.FieldByName('comment').AsString;
  frmHardwareAdd._developer.Text := THardware.FieldByName('developer').AsString;
  frmHardwareAdd._price.Value := THardware.FieldByName('price').AsFloat;
  frmHardwareAdd._modules.Text := FormatFloat('0.##', THardware.FieldByName('modules').AsFloat);
  frmHardwareAdd._modules2.Text := FormatFloat('0.##', THardware.FieldByName('modules2').AsFloat);

  // TAtt fill
  TAtt.SQL.Text := 'SELECT * FROM `uni_attachment` WHERE parent=' + IntToStr(HardwareNo) + ';';
  TAtt.Active := true;
  While Not TAtt.eof Do
  Begin
    frmHardwareAdd.DefTable.Append;
    frmHardwareAdd.DefTable.FieldByName('attname').AsString := TAtt.FieldByName('name').AsString;
    frmHardwareAdd.DefTable.FieldByName('attvalue').AsString := TAtt.FieldByName('content').AsString;
    frmHardwareAdd.DefTable.Post;
    TAtt.Next;
  End;
  // deffields fill
  //     
  TDefFields.SQL.Text := 'SELECT * FROM `uni_templatesfields` WHERE parent=' + IntToStr(TemplateNo) + ';';
  TDefFields.Active := true;
  While Not TDefFields.eof Do
  Begin
    s1 := TDefFields.FieldByName('name').AsString;
    s2 := TDefFields.FieldByName('defaultvalue').AsString;
    If Not frmHardwareAdd.DefTable.Locate('attname', s1, []) Then
    Begin
      frmHardwareAdd.DefTable.Append;
      frmHardwareAdd.DefTable.FieldByName('attname').AsString := s1;
      frmHardwareAdd.DefTable.FieldByName('attvalue').AsString := s2;
      frmHardwareAdd.DefTable.Post;
    End;
    TDefFields.Next;
  End;
  frmHardwareAdd.DefTable.First;

  If (THardware.RecordCount > 0) Then
    Try
      If frmHardwareAdd.ShowModal = mrOk Then
      Begin
        THardware.Edit;
        THardware.FieldByName('kind').AsInteger := frmHardwareAdd.CategoryNo;
        THardware.FieldByName('article').AsString := Trim(frmHardwareAdd._article.Text);
        THardware.FieldByName('kinddesc').AsString := Trim(frmHardwareAdd._kinddesc.Text);
        THardware.FieldByName('name').AsString := Trim(frmHardwareAdd._name.Text);
        THardware.FieldByName('comment').AsString := Trim(frmHardwareAdd._comment.Text);
        THardware.FieldByName('developer').AsString := Trim(frmHardwareAdd._developer.Text);
        THardware.FieldByName('price').AsFloat := frmHardwareAdd._price.Value;
        THardware.FieldByName('valuta').AsString := 'RUB';
        THardware.FieldByName('modules').AsFloat := StrToFloat(frmHardwareAdd._modules.Text);
        THardware.FieldByName('modules2').AsFloat := StrToFloat(frmHardwareAdd._modules2.Text);
        THardware.FieldByName('lastupdate').AsString := DateToStr(now());
        THardware.Post;
        // TAtt fill
        frmHardwareAdd.DefTable.First;
        While Not frmHardwareAdd.DefTable.eof Do
        Begin
          s1 := frmHardwareAdd.DefTable.FieldByName('attname').AsString;
          s2 := frmHardwareAdd.DefTable.FieldByName('attvalue').AsString;
          If TAtt.Locate('name', s1, []) Then
          Begin
            TAtt.Edit;
            TAtt.FieldByName('content').AsString := s2;
            TAtt.Post;
          End
          Else If s1 <> '' Then
          Begin
            TAtt.Append;
            TAtt.FieldByName('parent').AsInteger := HardwareNo;
            TAtt.FieldByName('name').AsString := s1;
            TAtt.FieldByName('content').AsString := s2;
            TAtt.Post;
          End;
          frmHardwareAdd.DefTable.Next;
        End;
        //
      End
    Except
    End;
End;

Procedure TfrmHardware.actAddCopyUpdate(Sender: TObject);
Begin
  actAddCopy.Enabled := (THardware.RecNo > 0) and (frmMain.usergroup.Length > 1);
End;

Procedure TfrmHardware.actAddExecute(Sender: TObject);
Var
  TemplateNo, HardwareNo: Integer;
  s1, s2: String;
Begin
  frmHardwareAdd.Caption := ' ';
  If THardware.State In [dsEdit, dsInsert] Then
    THardware.Post;
  frmHardwareAdd.Clear;
  frmHardwareAdd.CategoryNo := TTemplate.FieldByName('rec_no').AsInteger;
  frmHardwareAdd.HardwareNo := -1;
  TemplateNo := TTemplate.FieldByName('rec_no').AsInteger;

  // deffields fill
  //     
  TDefFields.SQL.Text := 'SELECT * FROM `uni_templatesfields` WHERE parent=' + IntToStr(TemplateNo) + ';';
  TDefFields.Active := true;
  While Not TDefFields.eof Do
  Begin
    s1 := TDefFields.FieldByName('name').AsString;
    s2 := TDefFields.FieldByName('defaultvalue').AsString;
    If Not frmHardwareAdd.DefTable.Locate('attname', s1, []) Then
    Begin
      frmHardwareAdd.DefTable.Append;
      frmHardwareAdd.DefTable.FieldByName('attname').AsString := s1;
      frmHardwareAdd.DefTable.FieldByName('attvalue').AsString := s2;
      frmHardwareAdd.DefTable.Post;
    End;
    TDefFields.Next;
  End;
  frmHardwareAdd.DefTable.First;

  If frmHardwareAdd.ShowModal = mrOk Then
  Begin
    THardware.Append;
    THardware.FieldByName('kind').AsInteger := frmHardwareAdd.CategoryNo;
    THardware.FieldByName('article').AsString := Trim(frmHardwareAdd._article.Text);
    THardware.FieldByName('kinddesc').AsString := Trim(frmHardwareAdd._kinddesc.Text);
    THardware.FieldByName('name').AsString := Trim(frmHardwareAdd._name.Text);
    THardware.FieldByName('comment').AsString := Trim(frmHardwareAdd._comment.Text);
    THardware.FieldByName('developer').AsString := Trim(frmHardwareAdd._developer.Text);
    THardware.FieldByName('price').AsFloat := frmHardwareAdd._price.Value;
    THardware.FieldByName('modules').AsFloat := StrToFloat(frmHardwareAdd._modules.Text);
    THardware.FieldByName('modules2').AsFloat := StrToFloat(frmHardwareAdd._modules2.Text);
    THardware.FieldByName('valuta').AsString := 'RUB';
    THardware.FieldByName('lastupdate').AsString := DateToStr(now());
    THardware.Post;
    HardwareNo := THardware.FieldByName('rec_no').AsInteger;
    // TAtt fill
    frmHardwareAdd.DefTable.First;
    If HardwareNo > 0 Then
    Begin
      TAtt.SQL.Text := 'SELECT * FROM `uni_attachment` WHERE parent=' + IntToStr(HardwareNo) + ';';
      TAtt.Active := true;
      While Not frmHardwareAdd.DefTable.eof Do
      Begin
        s1 := frmHardwareAdd.DefTable.FieldByName('attname').AsString;
        s2 := frmHardwareAdd.DefTable.FieldByName('attvalue').AsString;
        If TAtt.Locate('name', s1, []) Then
        Begin
          TAtt.Edit;
          TAtt.FieldByName('content').AsString := s2;
          TAtt.Post;
        End
        Else If s1 <> '' Then
        Begin
          TAtt.Append;
          TAtt.FieldByName('parent').AsInteger := HardwareNo;
          TAtt.FieldByName('name').AsString := s1;
          TAtt.FieldByName('content').AsString := s2;
          TAtt.Post;
        End;
        frmHardwareAdd.DefTable.Next;
      End;
    End;
    //

  End
End;

Procedure TfrmHardware.HardwareGridTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
Begin
  UpdateData;
End;

Procedure TfrmHardware.actAttDeleteExecute(Sender: TObject);
var
  buttonSelected: Integer;
Begin
  buttonSelected := MessageDlg(' ?', mtCustom, [mbYes, mbCancel], 0);
  if (buttonSelected = mrYes) then
  begin
    Try
      THardware.DisableControls;
      THardware.Edit;
      THardware.FieldByName('file').AsString := '';
      THardware.Post;
    Except
      // showmessage('  7264');
    End;
    THardware.EnableControls;
  end;

End;

Procedure TfrmHardware.actAttDeleteUpdate(Sender: TObject);
Var
  res: Boolean;
Begin
  res := false;
  If (THardware.RecNo > 0) Then
  Begin
    //  
    res := Length(THardware.FieldByName('file').AsString) > 0;
  End;
  actAttDelete.Enabled := res;
End;

Procedure TfrmHardware.actAttEditExecute(Sender: TObject);
Var
  fn, newfilename: String;
  cnt, i: Integer;
  bm: TBookmark;
  d: String;
Begin
  {
    cnt := HardwareGrid.SelectedRows.Count;
    If cnt > 1 Then
    dlgOpen.Title := '   ' + IntToStr(cnt) + ' '
    Else
  }
  dlgOpen.Title := ' ';

  //  
  If dlgOpen.Execute Then
  Begin
    fn := dlgOpen.FileName;
    If FileExists(fn) Then
    Begin
      newfilename := frmUniversal.FileSaveToFB(fn);
    End;
  End;

  //   
  If pos(' ', newfilename) < 1 Then
  Begin
    Try
      THardware.DisableControls;
      THardware.Edit;
      THardware.FieldByName('file').AsString := newfilename;
      THardware.Post;
    Except
      // showmessage('  7264');
    End;
    THardware.EnableControls;
  End;

End;

Procedure TfrmHardware.actAttEditUpdate(Sender: TObject);
Begin
  // actAttEdit.Enabled := (THardware.RecNo > 0) and (frmMain.usergroup.Length > 1);
End;

procedure TfrmHardware.actAttExpireExecute(Sender: TObject);
var
  certfile: string;
  certdate: TDateTime;
  SQL: string;
begin
  frmCertificateExpireDate.UseExpire.Checked := not THardware.FieldByName('expire').IsNull;
  if not THardware.FieldByName('expire').IsNull then
    frmCertificateExpireDate.EditExpireDate.Date := THardware.FieldByName('expire').AsDateTime
  else
    frmCertificateExpireDate.EditExpireDate.Date := now();

  if frmCertificateExpireDate.ShowModal = mrOk then
  begin
    certfile := THardware.FieldByName('file').AsString;
    certdate := frmCertificateExpireDate.EditExpireDate.Date;
    //  
    if frmCertificateExpireDate.UseExpire.Checked then
    begin
      if certfile <> '' then
      begin
        SQL := 'UPDATE uni_hardware SET `expire`=' + QuotedStr(FormatDateTime('yyyy-mm-dd', certdate)) +
          ' WHERE `file`=' + QuotedStr(certfile) + ' ;';
      end
      else
      begin
        SQL := 'UPDATE uni_hardware SET `expire`=' + QuotedStr(FormatDateTime('yyyy-mm-dd', certdate)) +
          ' WHERE `rec_no`=' + THardware.FieldByName('rec_no').AsString + ' ;';
      end;
    end
    else
    begin
      //   
      if certfile <> '' then
      begin
        SQL := 'UPDATE uni_hardware SET `expire`=NULL WHERE `file`=' + QuotedStr(certfile) + ' ;';
      end
      else
      begin
        SQL := 'UPDATE uni_hardware SET `expire`=NULL WHERE `rec_no`=' + THardware.FieldByName('rec_no')
          .AsString + ' ;';
      end;
    end;
    //  
    try
      MyQuery1.SQL.Text := SQL;
      MyQuery1.Execute;
      // showmessage(': ' + SQL);
    except
      showmessage('  : ' + SQL);
    end;
    UpdateData;
  end;
end;

procedure TfrmHardware.actAttExpireUpdate(Sender: TObject);
Var
  res: Boolean;
Begin
  {
    If (THardware.RecNo < 1) and (frmMain.usergroup.Length < 5) Then
    res := false
    Else If (HardwareGrid.SelectedRows.Count = 1) Then
    Begin
    res := (Length(THardware.FieldByName('file').AsString) > 10)
    End;
    actAttExpire.Enabled := res;
    if not res or (THardware.FieldByName('expire').AsString = '') then
    actAttExpire.Caption := 'C   '
    else
    begin
    actAttExpire.Caption := 'C    (' + THardware.FieldByName('expire').AsString + ')';
    end;
  }
end;

procedure TfrmHardware.actAttOpenExecute(Sender: TObject);
Var
  fn, fp, d: String;
Begin
  fp := frmMain.ComputerInfo.Folders.Temp + '\';
  //     
  // If (THardware.RecNo > 0) And (HardwareGrid.SelectedRows.Count < 2) Then
  If (THardware.RecNo > 0) Then
  Begin
    //  
    fn := THardware.FieldByName('file').AsString;
    If (fn <> '') Then
    Begin
      frmUniversal.FileGetByNameToFile(fn, fp + fn);
    End;
  End;

  if FileExists(fp + fn) then
  begin
    frmMain.OpenFile(fp + fn);
  end;
end;

procedure TfrmHardware.actAttOpenUpdate(Sender: TObject);
Var
  res: Boolean;
Begin
  res := false;
  If (THardware.RecNo > 0) Then
  Begin
    //  
    res := Length(THardware.FieldByName('file').AsString) > 0;
  End;
  actAttOpen.Enabled := res;
end;

Procedure TfrmHardware.actAttSaveToFileExecute(Sender: TObject);
Var
  fn, d: String;
Begin
  //  
  If (THardware.RecNo > 0) Then
  Begin
    //  
    fn := THardware.FieldByName('file').AsString;
    dlgSave.FileName := fn;
    dlgSave.DefaultExt := ExtractFileExt(fn);
    If (fn <> '') And dlgSave.Execute Then
    Begin
      frmUniversal.FileGetByNameToFile(fn, dlgSave.FileName);
    End;
  End;
End;

Procedure TfrmHardware.actAttSaveToFileUpdate(Sender: TObject);
Var
  res: Boolean;
Begin
  res := false;
  If (THardware.RecNo > 0) Then
  Begin
    //  
    res := Length(THardware.FieldByName('file').AsString) > 0;
  End;
  actAttSaveToFile.Enabled := res;
End;

Procedure TfrmHardware.actAutoSizeExecute(Sender: TObject);
Begin
  HardwareGrid.AutoSizeColumns(false); // := Not HardwareGrid.AutoSizeColumns;
End;

Procedure TfrmHardware.actAutoSizeUpdate(Sender: TObject);
Begin
  // actAutoSize.Checked := HardwareGrid.AutoSizeColumns;
End;

Procedure TfrmHardware.actFindLostExecute(Sender: TObject);
Begin
  //  
  frmFindLost.ShowModal;
  TTemplate.Refresh;
End;

procedure TfrmHardware.actFindLostUpdate(Sender: TObject);
begin
  actFindLost.Enabled := (frmMain.usergroup.Length > 1);
end;

Procedure TfrmHardware.actMoveExecute(Sender: TObject);
Var
  i: Integer;
Begin
  // 
  If frmHardwareMove.ShowModal = mrOk Then
    Try
      THardware.DisableControls;
      If frmHardwareMove.dir > 0 Then
      Begin
        {
          If HardwareGrid.SelectedRows.Count > 0 Then
          Begin
          With HardwareGrid.DataSource.DataSet Do
          For i := 0 To HardwareGrid.SelectedRows.Count - 1 Do
          Begin
          GotoBookmark(TBookmark(pointer(HardwareGrid.SelectedRows.Items[i])));
          THardware.Edit;
          THardware.FieldByName('kind').AsInteger := frmHardwareMove.dir;
          THardware.Post;
          End;
          End
          Else }
        Begin
          If TTemplate.RecNo > 0 Then
            Try
              THardware.Edit;
              THardware.FieldByName('kind').AsInteger := frmHardwareMove.dir;
              THardware.Post;
            Except
            End;
        End;
      End;
      THardware.Refresh;
      THardware.First;
    Except
    End;
  THardware.EnableControls;
  // HardwareGrid.SelectedRows.Clear;
End;

Procedure TfrmHardware.actAddCopyExecute(Sender: TObject);
Var
  TemplateNo, HardwareNo: Integer;
  s1, s2: String;
Begin
  frmHardwareAdd.Caption := '   ';
  If THardware.State In [dsEdit, dsInsert] Then
    THardware.Post;
  frmHardwareAdd.Clear;
  TemplateNo := TTemplate.FieldByName('rec_no').AsInteger;
  HardwareNo := THardware.FieldByName('rec_no').AsInteger;
  frmHardwareAdd.CategoryNo := THardware.FieldByName('kind').AsInteger;
  frmHardwareAdd.HardwareNo := -1;
  frmHardwareAdd._article.Text := THardware.FieldByName('article').AsString;
  frmHardwareAdd._kinddesc.Text := THardware.FieldByName('kinddesc').AsString;
  frmHardwareAdd._name.Text := THardware.FieldByName('name').AsString;
  frmHardwareAdd._comment.Text := THardware.FieldByName('comment').AsString;
  frmHardwareAdd._developer.Text := THardware.FieldByName('developer').AsString;
  frmHardwareAdd._price.Value := THardware.FieldByName('price').AsFloat;
  // frmHardwareAdd._modules.Value := THardware.FieldByName('modules').AsFloat;
  frmHardwareAdd._modules.Text := FormatFloat('0.##', THardware.FieldByName('modules').AsFloat);
  frmHardwareAdd._modules2.Text := FormatFloat('0.##', THardware.FieldByName('modules2').AsFloat);

  // TAtt fill
  TAtt.SQL.Text := 'SELECT * FROM `uni_attachment` WHERE parent=' + IntToStr(HardwareNo) + ';';
  TAtt.Active := true;
  While Not TAtt.eof Do
  Begin
    frmHardwareAdd.DefTable.Append;
    frmHardwareAdd.DefTable.FieldByName('attname').AsString := TAtt.FieldByName('name').AsString;
    frmHardwareAdd.DefTable.FieldByName('attvalue').AsString := TAtt.FieldByName('content').AsString;
    frmHardwareAdd.DefTable.Post;
    TAtt.Next;
  End;
  // deffields fill
  //     
  TDefFields.SQL.Text := 'SELECT * FROM `uni_templatesfields` WHERE parent=' + IntToStr(TemplateNo) + ';';
  TDefFields.Active := true;
  While Not TDefFields.eof Do
  Begin
    s1 := TDefFields.FieldByName('name').AsString;
    s2 := TDefFields.FieldByName('defaultvalue').AsString;
    If Not frmHardwareAdd.DefTable.Locate('attname', s1, []) Then
    Begin
      frmHardwareAdd.DefTable.Append;
      frmHardwareAdd.DefTable.FieldByName('attname').AsString := s1;
      frmHardwareAdd.DefTable.FieldByName('attvalue').AsString := s2;
      frmHardwareAdd.DefTable.Post;
    End;
    TDefFields.Next;
  End;
  frmHardwareAdd.DefTable.First;

  If (THardware.RecordCount > 0) Then
    Try
      If frmHardwareAdd.ShowModal = mrOk Then
      Begin
        THardware.Insert;
        THardware.FieldByName('kind').AsInteger := frmHardwareAdd.CategoryNo;
        THardware.FieldByName('article').AsString := Trim(frmHardwareAdd._article.Text);
        THardware.FieldByName('kinddesc').AsString := Trim(frmHardwareAdd._kinddesc.Text);
        THardware.FieldByName('name').AsString := Trim(frmHardwareAdd._name.Text);
        THardware.FieldByName('comment').AsString := Trim(frmHardwareAdd._comment.Text);
        THardware.FieldByName('developer').AsString := Trim(frmHardwareAdd._developer.Text);
        THardware.FieldByName('price').AsFloat := frmHardwareAdd._price.Value;
        THardware.FieldByName('valuta').AsString := 'RUB';
        THardware.FieldByName('modules').AsFloat := StrToFloat(frmHardwareAdd._modules.Text);
        THardware.FieldByName('modules2').AsFloat := StrToFloat(frmHardwareAdd._modules2.Text);
        THardware.FieldByName('lastupdate').AsString := DateToStr(now());
        THardware.Post;
        // TAtt fill
        HardwareNo := THardware.FieldByName('rec_no').AsInteger;
        //    
        frmHardwareAdd.DefTable.First;
        If HardwareNo > 0 Then
        Begin
          TAtt.SQL.Text := 'SELECT * FROM `uni_attachment` WHERE parent=' + IntToStr(HardwareNo) + ';';
          TAtt.Active := true;
          While Not frmHardwareAdd.DefTable.eof Do
          Begin
            s1 := frmHardwareAdd.DefTable.FieldByName('attname').AsString;
            s2 := frmHardwareAdd.DefTable.FieldByName('attvalue').AsString;
            If TAtt.Locate('name', s1, []) Then
            Begin
              TAtt.Edit;
              TAtt.FieldByName('content').AsString := s2;
              TAtt.Post;
            End
            Else If s1 <> '' Then
            Begin
              TAtt.Append;
              TAtt.FieldByName('parent').AsInteger := HardwareNo;
              TAtt.FieldByName('name').AsString := s1;
              TAtt.FieldByName('content').AsString := s2;
              TAtt.Post;
            End;
            frmHardwareAdd.DefTable.Next;
          End;
        End;
        //
      End
    Except
    End;
End;

Procedure TfrmHardware.UpdateSelCount;
begin
  { if HardwareGrid.SelCount > 0 then
    StatusBar.Panels[1].Text := ': ' + IntToStr(HardwareGrid.SelCount)
    else
    StatusBar.Panels[1].Text := '';
  }
end;

{
  //
  If Field.FieldName = 'file' Then
  With HardwareGrid.Canvas Do
  Begin
  // Brush.Color := clBlue; //clWhite;
  If THardware.FieldByName('file').AsString <> '' Then
  Begin
  if THardware.FieldByName('expire').IsNull then
  begin
  Brush.Color := $00F08080;
  Font.Color := clWhite;
  FillRect(Rect);
  TextOut(Rect.Left + 2, Rect.Top + 2, ' ');
  end
  else if THardware.FieldByName('expire').AsDateTime > (now() - 1) then
  begin
  Brush.Color := $00008000;
  Font.Color := clWhite;
  FillRect(Rect);
  TextOut(Rect.Left + 2, Rect.Top + 2, THardware.FieldByName('expire').AsString);
  end
  else
  begin
  Brush.Color := clRed;
  Font.Color := clWhite;
  FillRect(Rect);
  TextOut(Rect.Left + 2, Rect.Top + 2, THardware.FieldByName('expire').AsString);
  end;
  End
  else
  begin
  // HardwareGrid.DefaultDrawDataCell(Rect, Field, State);
  HardwareGrid.DefaultDrawing := true;
  end;
  End
  Else
  begin
  HardwareGrid.DefaultDrawing := true;
  // HardwareGrid.DefaultDrawDataCell(Rect, Field, State);
  end;
}

Procedure TfrmHardware.UpdateData;
Var
  filter: String;
  search_RU, search_EN: string;
  developer_RU, developer_EN: string;
  i: Integer;
  rec_no: Integer;
  sf: string;
  SQL: string;
  search: string;
const
  cols = 'rec_no,uni_hardware.kind,uni_hardware.kinddesc,uni_hardware.name,uni_hardware.article,uni_hardware.comment,uni_hardware.price,uni_hardware.developer,uni_hardware.file,uni_hardware.modules,uni_hardware.expire';
  // username,lastupdate,
Begin
  // THardware.DisableControls;
  HardwareGrid.enabled := false;

  rec_no := -1;
  if THardware.Active then
    rec_no := THardware.FieldByName('rec_no').AsInteger;

  // THardware.Active := false;
  search := Trim(_Search.Text);

  try
    filter := '';
    If search <> '' Then
    Begin
      search_EN := frmMain.TransformToEN(search);
      search_RU := frmMain.TransformToRU(search);
      filter := '(`article` LIKE ' + QuotedStr('%' + search + '%');
      filter := filter + ' OR `name` LIKE ' + QuotedStr('%' + search + '%');
      filter := filter + ' OR `name` LIKE ' + QuotedStr('%' + search_RU + '%');
      filter := filter + ' OR `name` LIKE ' + QuotedStr('%' + search_EN + '%');
      filter := filter + ' OR `developer` LIKE ' + QuotedStr('%' + search_RU + '%');
      filter := filter + ' OR `developer` LIKE ' + QuotedStr('%' + search_EN + '%');
      filter := filter + ' OR `comment` LIKE ' + QuotedStr('%' + search + '%');
      filter := filter + ')';
    End;
    If OnlyCategory.Checked Then
    Begin
      If filter <> '' Then
        filter := filter + ' AND ';
      filter := filter + ' `kind`=' + IntToStr(TTemplate.FieldByName('rec_no').AsInteger);
    End;
    If (_SearchDeveloper.Text <> '') Then
    Begin
      If filter <> '' Then
        filter := filter + ' AND ';
      developer_EN := frmMain.TransformToEN(_SearchDeveloper.Text);
      developer_RU := frmMain.TransformToRU(_SearchDeveloper.Text);
      filter := filter + '(`developer`=' + QuotedStr(developer_EN);
      filter := filter + ' OR `developer`=' + QuotedStr(developer_RU) + ') ';
    End;

    if filter <> '' then
    begin
      SQL := 'SELECT ' + cols +
        ',(SELECT `name` FROM `uni_templates` WHERE `rec_no`=uni_hardware.kind) as `tkind` FROM `uni_hardware` WHERE ' +
        filter;
    end
    else
    begin
      SQL := 'SELECT ' + cols +
        ',(SELECT `name` FROM `uni_templates` WHERE `rec_no`=uni_hardware.kind) as `tkind` FROM `uni_hardware`';
    end;

    if HardwareGrid.SortSettings.Column > -1 then
    begin
      sf := HardwareGrid.Columns[HardwareGrid.SortSettings.Column].FieldName;
      SQL := SQL + ' ORDER BY ' + sf;
      If HardwareGrid.SortSettings.Direction = sdDescending Then
        SQL := SQL + ' DESC';
    end;

    if THardware.SQL.Text <> SQL then
      THardware.SQL.Text := SQL;

    if not THardware.Active then
      try
        THardware.Active := true;
      except
        showmessage(SQL);
      end;

    if THardware.Active then
      LabelInfo.Caption := '  (' + IntToStr(THardware.RecordCount) + ')'
    else
      LabelInfo.Caption := ' ';

    if THardware.Active then
      THardware.Refresh;

    // if THardware.Active then THardware.FetchAll;

    //     
    // if THardware.Active and (rec_no > -1) then    THardware.Locate('rec_no', rec_no, []);

  except
    showmessage('search err');
  end;

  HardwareGrid.enabled := true;
  // THardware.EnableControls;

End;

End.
