unit Funcs;

interface

uses
  SysUtils, Classes, FMTBcd, DB, SqlExpr, Provider, DBClient;

type
  TfrmFuncs = class(TDataModule)
    DataSource1: TDataSource;
    ClientDataSet1: TClientDataSet;
    ClientDataSet1rec_no: TIntegerField;
    ClientDataSet1parent: TIntegerField;
    ClientDataSet1description: TStringField;
    ClientDataSet1kind: TIntegerField;
    ClientDataSet1color: TIntegerField;
    DataSetProvider1: TDataSetProvider;
    SQLQuery1: TSQLQuery;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    list_mesto, list_scvajina, list_plast: TStrings;
    list_opz_sostav_num: TStrings;
    function get_mesto: TStrings;
    function get_plast: TStrings;
    function get_scvajina: TStrings;
    function get_opz_sostav_num: TStrings;
    { Public declarations }
  end;

var
  frmFuncs: TfrmFuncs;

implementation

{$R *.dfm}

procedure TfrmFuncs.DataModuleCreate(Sender: TObject);
begin
  list_mesto := TStringList.Create;
  list_scvajina := TStringList.Create;
  list_plast := TStringList.Create;
  list_opz_sostav_num := TStringList.Create;
end;

procedure TfrmFuncs.DataModuleDestroy(Sender: TObject);
begin
  list_mesto.Free;
  list_scvajina.Free;
  list_plast.Free;
  list_opz_sostav_num.Free;
end;

function TfrmFuncs.get_mesto: TStrings;
var
  sql: string;
begin
  SQLQuery1.Close;
  sql := 'SELECT DISTINCT(`description`) FROM `obj_single` WHERE `kind`=0';
  SQLQuery1.sql.Text := sql;
  SQLQuery1.Open;
  list_mesto.Clear;
  if SQLQuery1.RecordCount > 0 then
    while not SQLQuery1.Eof do
    begin
      list_mesto.Add(SQLQuery1.FieldByName('description').AsString);
      SQLQuery1.Next;
    end;
  SQLQuery1.Close;
  result := list_mesto;
end;

function TfrmFuncs.get_opz_sostav_num: TStrings;
var
  sql: string;
  sostav: string;
begin
  SQLQuery1.Close;
  sql := 'SELECT DISTINCT(`opz_sostav_num`) FROM `obj_single`';
  SQLQuery1.sql.Text := sql;
  SQLQuery1.Open;
  list_opz_sostav_num.Clear;
  if SQLQuery1.RecordCount > 0 then
    while not SQLQuery1.Eof do
    begin
      sostav := SQLQuery1.FieldByName('opz_sostav_num').AsString;
      if sostav <> '' then
        list_opz_sostav_num.Add(sostav);
      SQLQuery1.Next;
    end;
  SQLQuery1.Close;
  result := list_opz_sostav_num;
end;

function TfrmFuncs.get_plast: TStrings;
var
  sql: string;
begin
  SQLQuery1.Close;
  sql := 'SELECT DISTINCT(`description`) FROM `obj_single` WHERE `kind`=2';
  SQLQuery1.sql.Text := sql;
  SQLQuery1.Open;
  list_plast.Clear;
  if SQLQuery1.RecordCount > 0 then
    while not SQLQuery1.Eof do
    begin
      list_plast.Add(SQLQuery1.FieldByName('description').AsString);
      SQLQuery1.Next;
    end;
  SQLQuery1.Close;
  result := list_plast;
end;

function TfrmFuncs.get_scvajina: TStrings;
var
  sql: string;
begin
  SQLQuery1.Close;
  sql := 'SELECT DISTINCT(`description`) FROM `obj_single` WHERE `kind`=1';
  SQLQuery1.sql.Text := sql;
  SQLQuery1.Open;
  list_scvajina.Clear;
  if SQLQuery1.RecordCount > 0 then
    while not SQLQuery1.Eof do
    begin
      list_scvajina.Add(SQLQuery1.FieldByName('description').AsString);
      SQLQuery1.Next;
    end;
  SQLQuery1.Close;
  result := list_scvajina;
end;

end.
