Unit FindLost;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls,
  JvExExtCtrls, JvExtComponent, DB,
  JvExControls, JvSpecialProgress, ComCtrls, JvExComCtrls, JvProgressBar,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.Client, FireDAC.Comp.DataSet;

Type
  TfrmFindLost = Class(TForm)
    Info: TLabel;
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    THardware: TFDTable;
    TimerStart2: TTimer;
    ProgressBar1: TProgressBar;
    TTemplate: TFDTable;
    Info2: TLabel;
    ProgressBar3: TProgressBar;
    TimerStart3: TTimer;
    TimerEnd: TTimer;
    TCustomers: TFDQuery;
    TCustomerTree: TFDQuery;
    TimerStart1: TTimer;
    Label1: TLabel;
    ProgressBar2: TProgressBar;
    MyQuery1: TFDQuery;
    Procedure FormShow(Sender: TObject);
    Procedure TimerStart2Timer(Sender: TObject);
    Procedure JvFooterBtn1Click(Sender: TObject);
    procedure TimerStart3Timer(Sender: TObject);
    procedure TimerEndTimer(Sender: TObject);
    procedure TimerStart1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  Private
    { Private declarations }
  Public
    br: boolean;
    Script: Tstrings;
    { Public declarations }
  End;

Var
  frmFindLost: TfrmFindLost;

Implementation

Uses Main,  Universal;
{$R *.dfm}

procedure TfrmFindLost.FormCreate(Sender: TObject);
begin
  Script := TStringList.Create;
end;

procedure TfrmFindLost.FormDestroy(Sender: TObject);
begin
  Script.Free;
end;

Procedure TfrmFindLost.FormShow(Sender: TObject);
Begin
  if not frmUniversal.DBConnected then
    close;
  try
    br := false;
    ProgressBar1.Min := 0;
    ProgressBar1.Position := 0;
    Application.ProcessMessages;
    TimerStart1.Enabled := true;
  except
  end;
End;

Procedure TfrmFindLost.JvFooterBtn1Click(Sender: TObject);
Begin
  br := true;
End;

procedure TfrmFindLost.TimerStart1Timer(Sender: TObject);
var
  i: integer;
begin
  TimerStart1.Enabled := false;
  //
  Script.Clear;
  Script.Add('CREATE TABLE `uni_docparts` ( ' +
    '    `rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
    '    `kind` varchar(20) DEFAULT NULL,' +
    '    `name` varchar(200) DEFAULT NULL,' + '    `store` mediumblob,' +
    '    `project_no` int(11) DEFAULT 0,' +
    '    `defaultext` varchar(10) DEFAULT NULL,' + '    PRIMARY KEY (`rec_no`)'
    + ') AUTO_INCREMENT = 2 CHARACTER SET cp1251 COLLATE cp1251_general_ci;');

  {
    Script.Add('CREATE TABLE `uni_customertree` (' +
    '  `rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
    '  `parent` int(11) DEFAULT 0,' + '  `name` varchar(100) DEFAULT NULL,' +
    '  `icon_no` int(11) DEFAULT NULL,' + '  PRIMARY KEY (`rec_no`)' +
    ') AUTO_INCREMENT = 2 CHARACTER SET cp1251 COLLATE cp1251_general_ci;');

    Script.Add('CREATE TABLE `uni_customerdetail` (' +
    '  `rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
    '  `parent` int(11) DEFAULT 0,' + '  `name` varchar(100) DEFAULT NULL,' +
    '  `email` varchar(100) DEFAULT NULL,' +
    '  `user_fio` varchar(200) DEFAULT NULL,' +
    '  `user_job` varchar(200) DEFAULT NULL,' +
    '  `country_code` varchar(10) DEFAULT NULL,' +
    '  `phone_1` varchar(20) DEFAULT NULL,' +
    '  `phone_2` varchar(20) DEFAULT NULL,' +
    '  `address_index` varchar(20) DEFAULT NULL,' +
    '  `address_line_1` varchar(100) DEFAULT NULL,' +
    '  `address_line_2` varchar(100) DEFAULT NULL,' +
    '  `submissions` varchar(20) DEFAULT NULL,' +
    '  `lastlogin` date DEFAULT NULL,' + '  `kind` varchar(20) DEFAULT NULL,' +
    '  `comment` text,' + '  `web` varchar(200) DEFAULT NULL,' +
    '  `owner` varchar(100) DEFAULT NULL,' + '  PRIMARY KEY (`rec_no`)' +
    ') AUTO_INCREMENT = 2 CHARACTER SET cp1251 COLLATE cp1251_general_ci;');

    Script.Add('ALTER TABLE uni_customers ADD parent int;');
    Script.Add('ALTER TABLE uni_customers ADD parentcustomer int;');
    Script.Add('ALTER TABLE uni_customers ADD name_uri VARCHAR(100);');
    Script.Add
    ('UPDATE uni_customers SET `name_uri`=`name` WHERE `name_uri`="" or `name_uri` is null;');
    Script.Add('ALTER TABLE uni_customers ADD web VARCHAR(100);');
    Script.Add('ALTER TABLE uni_customers ADD inn VARCHAR(20);');
    Script.Add('ALTER TABLE uni_customers ADD kpp VARCHAR(20);');
    Script.Add('ALTER TABLE uni_customers ADD bank TEXT;');
    Script.Add('ALTER TABLE uni_customers ADD owner VARCHAR(100);');
    Script.Add('ALTER TABLE uni_projects ADD description VARCHAR(200);');
    Script.Add('ALTER TABLE uni_hardware ADD expire DATE;');
    Script.Add('ALTER TABLE uni_projecthardware ADD expire DATE;');
    Script.Add('ALTER TABLE uni_systemsdetail ADD expire DATE;');
    Script.Add('ALTER TABLE uni_projectsystems ADD orderby int;');
  }
  Script.Add
    ('UPDATE uni_projectsystems SET `orderby`=`rec_no` WHERE `orderby`<1 or `orderby` is null;');
  Script.Add('ALTER TABLE uni_projecthardware ADD orderby int;');
  Script.Add
    ('UPDATE uni_projecthardware SET `orderby`=`rec_no` WHERE `orderby`<1 or `orderby` is null;');
  Script.Add('ALTER TABLE uni_systemsopts ADD autofill VARCHAR(12);');

  ProgressBar1.Min := 0;
  ProgressBar1.Position := 0;
  ProgressBar1.Max := Script.Count;

  for i := 0 to Script.Count - 1 do
    Try
      ProgressBar1.Position := i + 1;
      Application.ProcessMessages;
      MyQuery1.SQL.Text := Script[i];
      MyQuery1.Execute;
    Except
    End;
  //
  TimerStart2.Enabled := true;
end;

Procedure TfrmFindLost.TimerStart2Timer(Sender: TObject);
Var
  ex: Array Of integer;
  i: integer;
  fnd: boolean;
  kind: integer;
  trash_no: integer;
Begin
  TimerStart2.Enabled := false;
  trash_no := -1;
  Try
    //  ,    
    fnd := false;
    TTemplate.Active := true;
    TTemplate.First;
    SetLength(ex, TTemplate.RecordCount);
    For i := 0 To TTemplate.RecordCount - 1 Do
    Begin
      ex[i] := TTemplate.FieldByName('rec_no').AsInteger;
      If (TTemplate.FieldByName('parent').AsInteger = 0) And
        (TTemplate.FieldByName('name').AsString = '') Then
      Begin
        fnd := true;
        trash_no := ex[i];
      End;
      TTemplate.Next;
    End;
    //  ,  
    If Not fnd Then
    Begin
      TTemplate.Insert;
      TTemplate.FieldByName('parent').AsInteger := 0;
      TTemplate.FieldByName('name').AsString := '';
      TTemplate.Post;
      TTemplate.Refresh;
      If TTemplate.Locate('name', '', []) Then
      Begin
        trash_no := TTemplate.FieldByName('rec_no').AsInteger;
      End;
    End;
    //      
    THardware.Active := true;
    THardware.First;
    ProgressBar2.Min := 0;
    ProgressBar2.Position := 0;
    ProgressBar2.Max := THardware.RecordCount;
    While Not THardware.eof Do
      If Not br Then
      Begin
        Info.Caption := ': ' + IntToStr(THardware.RecNo) + '  ' +
          IntToStr(THardware.RecordCount);
        ProgressBar2.Position := THardware.RecNo;
        Application.ProcessMessages;
        //
        kind := THardware.FieldByName('kind').AsInteger;
        fnd := false;
        For i := 0 To Length(ex) - 1 Do
        Begin
          If kind = ex[i] Then
            fnd := true;
        End;
        If (Not fnd) And (trash_no > 0) Then
        Begin
          //  
          THardware.Edit;
          THardware.FieldByName('kind').AsInteger := trash_no;
          THardware.Post;
        End;
        //
        THardware.Next;
      End;
    THardware.Active := false;
    // 
  Except
  End;
  TimerStart3.Enabled := true;
  // ModalResult := mrOk;
End;

procedure TfrmFindLost.TimerEndTimer(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TfrmFindLost.TimerStart3Timer(Sender: TObject);
Var
  ex: Array Of integer;
  i: integer;
  fnd: boolean;
  kind: integer;
  trash_no: integer;
Begin
  TimerStart3.Enabled := false;
  trash_no := -1;
  Try
    //  ,    
    fnd := false;
    TCustomerTree.Active := true;
    TCustomerTree.First;
    SetLength(ex, TCustomerTree.RecordCount);
    For i := 0 To TCustomerTree.RecordCount - 1 Do
    Begin
      ex[i] := TCustomerTree.FieldByName('rec_no').AsInteger;
      If (TCustomerTree.FieldByName('parent').AsInteger = 0) And
        (TCustomerTree.FieldByName('name').AsString = '') Then
      Begin
        fnd := true;
        trash_no := ex[i];
      End;
      TCustomerTree.Next;
    End;
    //  ,  
    If Not fnd Then
    Begin
      TCustomerTree.Insert;
      TCustomerTree.FieldByName('parent').AsInteger := 0;
      TCustomerTree.FieldByName('name').AsString := '';
      TCustomerTree.Post;
      TCustomerTree.Refresh;
      If TCustomerTree.Locate('name', '', []) Then
      Begin
        trash_no := TCustomerTree.FieldByName('rec_no').AsInteger;
      End;
    End;
    //      
    TCustomers.Active := true;
    TCustomers.First;
    ProgressBar3.Min := 0;
    ProgressBar3.Position := 0;
    ProgressBar3.Max := TCustomers.RecordCount;
    While Not TCustomers.eof Do
      If Not br Then
      Begin
        Info2.Caption := ': ' + IntToStr(TCustomers.RecNo) + '  ' +
          IntToStr(TCustomers.RecordCount);
        ProgressBar3.Position := TCustomers.RecNo;
        Application.ProcessMessages;
        //
        kind := TCustomers.FieldByName('parent').AsInteger;
        fnd := false;
        For i := 0 To Length(ex) - 1 Do
        Begin
          If kind = ex[i] Then
            fnd := true;
        End;
        If (Not fnd) And (trash_no > 0) Then
        Begin
          //  
          TCustomers.Edit;
          TCustomers.FieldByName('parent').AsInteger := trash_no;
          TCustomers.Post;
        End;
        //
        TCustomers.Next;
      End;
    TCustomers.Active := false;
    // 
  Except
  End;
  TimerEnd.Enabled := true;
end;

End.
