unit Filters;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, JvExGrids, JvStringGrid, ExtCtrls, Menus, StdActns, ActnList,
  JvMenus, DB, DBTables, JvDataSource, DBGrids, JvExDBGrids, JvDBGrid, FMTBcd,
  SqlExpr, DBClient, Provider, ComCtrls;

type
  TfrmFilters = class(TForm)
    Panel4: TPanel;
    TablePMenu: TPopupMenu;
    Actions: TActionList;
    actAddSQL: TAction;
    actEditSQL: TAction;
    actDelete: TAction;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    JvDBGrid1: TJvDBGrid;
    StatusBar: TStatusBar;
    TableFilters: TSQLTable;
    DSPFilters: TDataSetProvider;
    CDSFilters: TClientDataSet;
    DSFilters: TDataSource;
    TableFiltersrec_no: TIntegerField;
    TableFiltersdesc: TStringField;
    TableFilterssql: TMemoField;
    CDSFiltersrec_no: TIntegerField;
    CDSFiltersdesc: TStringField;
    CDSFilterssql: TMemoField;
    MainMenu: TMainMenu;
    N12: TMenuItem;
    N15: TMenuItem;
    N14: TMenuItem;
    N13: TMenuItem;
    TableFiltersf_captions: TStringField;
    TableFiltersf_visible: TStringField;
    TableFiltersf_width: TStringField;
    CDSFiltersf_captions: TStringField;
    CDSFiltersf_visible: TStringField;
    CDSFiltersf_width: TStringField;
    actAddMaster: TAction;
    actEditMaster: TAction;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    N10: TMenuItem;
    N11: TMenuItem;
    TableFilterssql_params: TMemoField;
    TableFilterssql_values: TMemoField;
    CDSFilterssql_params: TMemoField;
    CDSFilterssql_values: TMemoField;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure actAddSQLExecute(Sender: TObject);
    procedure actEditSQLExecute(Sender: TObject);
    procedure actDeleteExecute(Sender: TObject);
    procedure CDSFiltersAfterPost(DataSet: TDataSet);
    procedure actAddSQLUpdate(Sender: TObject);
    procedure actEditSQLUpdate(Sender: TObject);
    procedure actDeleteUpdate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure CDSFiltersAfterDelete(DataSet: TDataSet);
    procedure actAddMasterUpdate(Sender: TObject);
    procedure actEditMasterUpdate(Sender: TObject);
    procedure actAddMasterExecute(Sender: TObject);
    procedure actEditMasterExecute(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmFilters: TfrmFilters;

implementation

uses Main, FilterAdd, FilterDelete, MasterFilters;

{$R *.dfm}

procedure TfrmFilters.actAddMasterExecute(Sender: TObject);
var sql: string;
begin
    if frmMasterFilters.ShowModal=mrOk then
      begin
      //  
      sql:='SELECT ';
      sql:=sql+frmMasterFilters.f_fieldnames;
      sql:=sql+' FROM `obj_single` ';
      if frmMasterFilters.sql<>'' then
      sql:=sql+' WHERE '+frmMasterFilters.sql;
      //    
      CDSFilters.Append;
      CDSFilters.FieldByName('desc').AsString := frmMasterFilters.Desc.Text;
      CDSFilters.FieldByName('sql').AsString := sql;
      CDSFilters.FieldByName('f_captions').AsString := frmMasterFilters.f_captions;
//      CDSFilters.FieldByName('f_visible').AsString := frmMasterFilters.f_visible.Text;
      CDSFilters.FieldByName('f_width').AsString := frmMasterFilters.f_fieldwidth;
      CDSFilters.Post;
      end;
end;

procedure TfrmFilters.actAddMasterUpdate(Sender: TObject);
begin
    actAddMaster.Enabled:=(CDSFilters.Active);
end;

procedure TfrmFilters.actAddSQLExecute(Sender: TObject);
begin
    frmFilterAdd.Desc.Text := '';
    frmFilterAdd.SQL.Text := 'SELECT * FROM `obj_single`';
    frmFilterAdd.Caption := '  ()';
    frmFilterAdd.f_captions.Text := '';
    frmFilterAdd.f_visible.Text := '';
    frmFilterAdd.f_width.Text := '';
    if frmFilterAdd.ShowModal=mrOk then
      begin
      CDSFilters.Append;
      CDSFilters.FieldByName('desc').AsString := frmFilterAdd.Desc.Text;
      CDSFilters.FieldByName('sql').AsString := frmFilterAdd.SQL.Text;
      CDSFilters.FieldByName('f_captions').AsString := frmFilterAdd.f_captions.Text;
      CDSFilters.FieldByName('f_visible').AsString := frmFilterAdd.f_visible.Text;
      CDSFilters.FieldByName('f_width').AsString := frmFilterAdd.f_width.Text;
      CDSFilters.Post;
      end;
end;

procedure TfrmFilters.actAddSQLUpdate(Sender: TObject);
begin
    actAddSQL.Enabled:=(CDSFilters.Active);
end;

procedure TfrmFilters.actDeleteExecute(Sender: TObject);
begin
    if frmFilterDelete.ShowModal=mrOk then
      begin
      CDSFilters.Delete;
      end;
end;

procedure TfrmFilters.actDeleteUpdate(Sender: TObject);
begin
    actDelete.Enabled:=(CDSFilters.Active and (CDSFilters.RecordCount>0) and (CDSFilters.RecNo>0));
end;


procedure TfrmFilters.actEditMasterExecute(Sender: TObject);
begin
    if frmMasterFilters.ShowModal=mrOk then
      begin

      end;
end;

procedure TfrmFilters.actEditMasterUpdate(Sender: TObject);
begin
    actEditSQL.Enabled:=(CDSFilters.Active and (CDSFilters.RecordCount>0) and (CDSFilters.RecNo>0));
end;

procedure TfrmFilters.actEditSQLExecute(Sender: TObject);
begin
    frmFilterAdd.Caption := '  ()';
    frmFilterAdd.Desc.Text := CDSFilters.FieldByName('desc').AsString;
    frmFilterAdd.SQL.Text := CDSFilters.FieldByName('sql').AsString;
    frmFilterAdd.f_captions.Text := CDSFilters.FieldByName('f_captions').AsString;
    frmFilterAdd.f_visible.Text := CDSFilters.FieldByName('f_visible').AsString;
    frmFilterAdd.f_width.Text := CDSFilters.FieldByName('f_width').AsString;
    if frmFilterAdd.ShowModal=mrOk then
      begin
      CDSFilters.Edit;
      CDSFilters.FieldByName('desc').AsString := frmFilterAdd.Desc.Text;
      CDSFilters.FieldByName('sql').AsString := frmFilterAdd.SQL.Text;
      CDSFilters.FieldByName('f_captions').AsString := frmFilterAdd.f_captions.Text;
      CDSFilters.FieldByName('f_visible').AsString := frmFilterAdd.f_visible.Text;
      CDSFilters.FieldByName('f_width').AsString := frmFilterAdd.f_width.Text;
      CDSFilters.Post;
      end;
end;

procedure TfrmFilters.actEditSQLUpdate(Sender: TObject);
begin
    actEditSQL.Enabled:=(CDSFilters.Active and (CDSFilters.RecordCount>0) and (CDSFilters.RecNo>0));
end;

procedure TfrmFilters.CDSFiltersAfterDelete(DataSet: TDataSet);
begin
  CDSFilters.ApplyUpdates(0);
end;

procedure TfrmFilters.CDSFiltersAfterPost(DataSet: TDataSet);
begin
  CDSFilters.ApplyUpdates(0);
  CDSFilters.Refresh;
end;

procedure TfrmFilters.FormActivate(Sender: TObject);
begin
    try
    if not CDSFilters.Active then CDSFilters.Active:=true;
    except
    end;
end;

procedure TfrmFilters.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

end.
