unit FilesImportExport;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, JvBaseDlg, JvSelectDirectory, FireDAC.Phys.Intf,
  Vcl.StdCtrls, Vcl.ExtCtrls, JvComponentBase, JvSearchFiles, System.IOUtils;

type
  TfrmFilesImportExport = class(TForm)
    JvSelectDirectory1: TJvSelectDirectory;
    JvSearchFiles1: TJvSearchFiles;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    FilePathImport: TLabeledEdit;
    btnSelectImport: TButton;
    btnImport: TButton;
    btnExport: TButton;
    FilePathExport: TLabeledEdit;
    btnSelectExport: TButton;
    GroupBox3: TGroupBox;
    btnTables: TButton;
    checkImport1: TCheckBox;
    checkImport255: TCheckBox;
    checkExport255: TCheckBox;
    checkExport1: TCheckBox;
    procedure btnSelectImportClick(Sender: TObject);
    // procedure btnImportClick(Sender: TObject);
    procedure FilePathImportChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    // procedure btnExportClick(Sender: TObject);
    procedure btnSelectExportClick(Sender: TObject);
    procedure btnTablesClick(Sender: TObject);
    procedure checkExport255Click(Sender: TObject);
    procedure JvSearchFiles1Progress(Sender: TObject);
  private
    procedure GetDBList;
    procedure CreateFileTables;
    procedure btnExportClick(Sender: TObject);
    procedure btnImportClick(Sender: TObject);
    { Private declarations }
  public
    dblist: tstrings;
    { Public declarations }
  end;

var
  frmFilesImportExport: TfrmFilesImportExport;

implementation

{$R *.dfm}

uses Main, Universal;

// uses Universal;

procedure TfrmFilesImportExport.btnSelectImportClick(Sender: TObject);
begin
  JvSelectDirectory1.InitialDir := FilePathImport.Text;
  if JvSelectDirectory1.Execute then
  begin
    FilePathImport.Text := JvSelectDirectory1.Directory;
  end;
end;

procedure TfrmFilesImportExport.btnSelectExportClick(Sender: TObject);
begin
  JvSelectDirectory1.InitialDir := FilePathExport.Text;
  if JvSelectDirectory1.Execute then
  begin
    FilePathExport.Text := JvSelectDirectory1.Directory;
  end;
end;

procedure TfrmFilesImportExport.btnExportClick(Sender: TObject);
var
  i: integer;
  fn, fn_export, dir: string;
begin
  if Trim(FilePathExport.Text) = '' then
    exit;
  if not DirectoryExists(FilePathExport.Text) then
    exit;

  btnExport.Enabled := false;

  //  
  for i := 0 to dblist.Count - 1 do
  begin
    fn := dblist[i];
    btnExport.Caption := ' ' + i.ToString + '  ' + dblist.Count.ToString + ' (' + ExtractFileName(fn) + ')';
    dir := FilePathExport.Text;
    fn_export := TPath.Combine(dir, fn);
    frmUniversal.FileGetByNameToFile(fn, fn_export);
    Application.ProcessMessages;
  end;

  btnExport.Enabled := true;
  btnExport.Caption := '   ' + dblist.Count.ToString + ' ';
end;

procedure TfrmFilesImportExport.btnImportClick(Sender: TObject);
var
  i: integer;
  fn: string;
begin
  if Trim(FilePathImport.Text) = '' then
    exit;

  btnImport.Enabled := false;

  //  
  for i := 0 to JvSearchFiles1.TotalFiles - 1 do
  begin
    fn := JvSearchFiles1.Files[i];
    btnImport.Caption := ' ' + i.ToString + '  ' + JvSearchFiles1.TotalFiles.ToString + ' (' +
      ExtractFileName(fn) + ')';
    frmUniversal.FileSaveToFB(fn);
    Application.ProcessMessages;
  end;

  btnImport.Enabled := true;
  btnImport.Caption := '   ' + JvSearchFiles1.TotalFiles.ToString + ' ';
end;

procedure TfrmFilesImportExport.btnTablesClick(Sender: TObject);
begin
  btnTables.Enabled := false;
  CreateFileTables;
  btnTables.Caption := btnTables.Hint;
  btnTables.Enabled := true;
end;

procedure TfrmFilesImportExport.CreateFileTables;
var
  i: integer;
  table, postfix: string;
  list: tstrings;
begin

  try
    frmUniversal.DatabaseConnection.ExecSQL
      ('CREATE TABLE `uni_systemstemplates` (`rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
      '`kind` VARCHAR(100),`construction` VARCHAR(100),`voltage` VARCHAR(200),' +
      '`current` VARCHAR(200),`protection` VARCHAR(200),`entries` VARCHAR(200),' +
      '`voltage_secondary` VARCHAR(200),`strength` VARCHAR(200),`file` VARCHAR(200),' + '	PRIMARY KEY (`rec_no`));');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systemstemplates` ADD `expire` datetime;');
  except
  end;

  list := TStringList.Create;
  frmUniversal.DatabaseConnection.GetTableNames('', '', '', list, [osMy], [tkTable], true);
  for i := 0 to list.Count - 1 do
    try
      table := list[i];
      frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE ' + table +
        ' CONVERT TO CHARACTER SET utf8 COLLATE utf8_general_ci;');
      btnTables.Caption := table;
      Application.ProcessMessages;
    except
    end;
  list.Free;

  try
    frmUniversal.DatabaseConnection.ExecSQL('CREATE INDEX parent_idx ON `uni_attachment` (`parent`);');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('CREATE INDEX project_no_idx ON `uni_projecthardware` (`project_no`);');
  except
  end;
  try
    //      
    frmUniversal.DatabaseConnection.ExecSQL('CREATE INDEX project_file_idx ON `uni_projecthardware` (`file`);');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('CREATE INDEX file_idx ON `uni_projecthardware` (`file` varchar(200));');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('CREATE INDEX project_no_idx ON `uni_projectsystems` (`project_no`);');
  except
  end;

  frmUniversal.DatabaseQuery1.active := false;
  try
    for i := 0 to 255 do
    begin
      try
        postfix := lowercase(IntToHex(i, 2));
        frmUniversal.DatabaseQuery1.SQL.Text := 'CREATE TABLE IF NOT EXISTS `files_' + postfix +
          '` (`rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
          ' `name` varchar(40) DEFAULT NULL, `file` longblob, PRIMARY KEY (`rec_no`));';
        frmUniversal.DatabaseQuery1.ExecSQL;
        try
          frmUniversal.DatabaseQuery1.SQL.Text := 'CREATE INDEX name_idx ON `files_' + postfix + '` (`name`(40));';
          frmUniversal.DatabaseQuery1.ExecSQL;
        except
        end;

        btnTables.Caption := 'files_' + postfix;
        Application.ProcessMessages;
      except
      end;
    end;
  except
  end;

  btnTables.Caption := '  ';

  try
    // frmUniversal.DatabaseConnection.ExecSQL('DROP TABLE `uni_messageslib`;');
  except
  end;

  try
    frmUniversal.DatabaseQuery1.SQL.Text := 'CREATE TABLE IF NOT EXISTS `uni_docparts` ( ' +
      ' `rec_no` int(11) NOT NULL AUTO_INCREMENT, `kind` varchar(20) DEFAULT NULL, `name` varchar(200) DEFAULT NULL,' +
      ' `store` mediumblob, `project_no` int(11) DEFAULT 0, `defaultext` varchar(10) DEFAULT NULL,' +
      '  PRIMARY KEY (`rec_no`)' + ');';
    frmUniversal.DatabaseQuery1.ExecSQL;
  except
  end;

  try
    frmUniversal.DatabaseQuery1.SQL.Text :=
      'CREATE TABLE IF NOT EXISTS `uni_messages` (`rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
      ' `project_no` int(11) DEFAULT 0, `dt` datetime,  `kind` int(11), `username` varchar(100), `comment` mediumtext, `orderby` int(11) DEFAULT 0, PRIMARY KEY (`rec_no`));';
    frmUniversal.DatabaseQuery1.ExecSQL;
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_messages` ADD `kind` int(11);');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('CREATE INDEX kind_idx ON `uni_messages` (`kind`);');
    frmUniversal.DatabaseConnection.ExecSQL('CREATE INDEX project_no_idx ON `uni_messages` (`project_no`);');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_messages` ADD `username` varchar(100);');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_messages` MODIFY `dt` datetime;');
  except
  end;

  try
    frmUniversal.DatabaseQuery1.SQL.Text :=
      'CREATE TABLE IF NOT EXISTS `uni_messageslib` (`rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
      ' `kind` int(11), `dt` datetime, `username` varchar(100), `comment` mediumtext, `short` text, `orderby` int(11) DEFAULT 0, PRIMARY KEY (`rec_no`));';
    frmUniversal.DatabaseQuery1.ExecSQL;
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_messageslib` MODIFY `dt` datetime;');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_messageslib` ADD `short` text;');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_messageslib` ADD `kind` int(11);');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_messageslib` DROP COLUMN `name`;');
  except
  end;

  //      
  try
    frmUniversal.DatabaseQuery1.SQL.Text :=
      'CREATE TABLE IF NOT EXISTS `uni_settings` (`rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
      ' `name` varchar(20), `value` varchar(20), `dt` datetime, PRIMARY KEY (`rec_no`));';
    frmUniversal.DatabaseQuery1.ExecSQL;
  except
  end;

  try
    frmUniversal.DatabaseQuery1.SQL.Text :=
      'CREATE TABLE IF NOT EXISTS `uni_pricelist` (`rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
      ' `name` varchar(200), `username` varchar(100), `counter` int(11), `dt` datetime, PRIMARY KEY (`rec_no`));';
    frmUniversal.DatabaseQuery1.ExecSQL;
  except
  end;

  { try
    frmUniversal.DatabaseQuery1.SQL.Text := 'DROP TABLE IF EXISTS `uni_log`;';
    frmUniversal.DatabaseQuery1.ExecSQL;
    except
    end; }

  try
    frmUniversal.DatabaseQuery1.SQL.Text :=
      'CREATE TABLE IF NOT EXISTS `uni_log` (`rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
      ' `timestamp` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, `username` varchar(20),`operation` int DEFAULT 0,' +
      ' `table_name` varchar(20), `project_name` varchar(20), `system_name` varchar(20), `text` varchar(40), ' +
      ' PRIMARY KEY (`rec_no`));';
    frmUniversal.DatabaseQuery1.ExecSQL;
  except
  end;

  try
    frmUniversal.DatabaseQuery1.SQL.Text :=
      'CREATE TABLE IF NOT EXISTS `uni_prices` (`rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
      ' `pricelist` int(11), `name` varchar(200), `article` varchar(200), `price` float(14,2) DEFAULT 0, PRIMARY KEY (`rec_no`));';
    frmUniversal.DatabaseQuery1.ExecSQL;
  except
  end;

  try
    frmUniversal.DatabaseQuery1.SQL.Text := 'CREATE INDEX article_idx ON `uni_prices` (`article`(200));';
    frmUniversal.DatabaseQuery1.ExecSQL;
  except
  end;

  {
    try
    frmUniversal.DatabaseQuery1.SQL.Text :=
    'CREATE TABLE IF NOT EXISTS `uni_standart` (`rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
    ' `project_no` int(11) DEFAULT 0, `kind` int(11) DEFAULT 0, `name` varchar(100) DEFAULT NULL, `dt` date, `adv` varchar(100), `comment` varchar(200), PRIMARY KEY (`rec_no`));';
    frmUniversal.DatabaseQuery1.ExecSQL;
    except
    end; }

  {
    try
    frmUniversal.DatabaseQuery1.SQL.Text :=
    'CREATE TABLE IF NOT EXISTS `uni_kb` (`rec_no` int(11) NOT NULL AUTO_INCREMENT,' +
    ' `project_no` int(11) DEFAULT 0, `name` varchar(100) DEFAULT NULL, `dt_start` date, `dt_end` date, `adv` varchar(100), `comment` varchar(200), PRIMARY KEY (`rec_no`));';
    frmUniversal.DatabaseQuery1.ExecSQL;
    except
    end; }

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_hardware` ADD `modules2` float(14,2) DEFAULT NULL;');
  except
  end;

  //  
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_hardware` ADD `lastupdate` datetime DEFAULT NULL;');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_hardware` MODIFY `lastupdate` datetime DEFAULT NULL;');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_hardware` ADD `username` varchar(20) DEFAULT NULL;');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL
      ('ALTER TABLE `uni_projecthardware` ADD `username` varchar(20) DEFAULT NULL;');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL
      ('ALTER TABLE `uni_projecthardware` ADD `lastupdate` datetime DEFAULT NULL;');
  except
  end;
  //

  try
    frmUniversal.DatabaseConnection.ExecSQL
      ('ALTER TABLE `uni_projecthardware` ADD `modules2` float(14,2) DEFAULT NULL;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projecthardware` ADD `kind` int DEFAULT NULL;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` ADD `query` int DEFAULT NULL;');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` ADD `tag` varchar(100) DEFAULT NULL;');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` ADD `tag` varchar(100) DEFAULT NULL;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systemsdetail` ADD `orderby` int(11) DEFAULT NULL;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL
      ('UPDATE `uni_systemsdetail` SET `orderby`=`rec_no` WHERE `orderby` IS NULL;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_hardware` MODIFY `modules` float(14,2) DEFAULT NULL;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_hardware` MODIFY `modules2` float(14,2) DEFAULT NULL;');
    frmUniversal.DatabaseConnection.ExecSQL
      ('ALTER TABLE `uni_projecthardware` MODIFY `modules` float(14,2) DEFAULT NULL;');
    frmUniversal.DatabaseConnection.ExecSQL
      ('ALTER TABLE `uni_projecthardware` MODIFY `modules2` float(14,2) DEFAULT NULL;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL
      ('UPDATE `uni_hardware` SET `modules2`=`modules`*18 WHERE `modules`>0 AND NOT (`modules2`>0);');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL
      ('UPDATE `uni_projecthardware` SET `modules2`=`modules`*18 WHERE `modules`>0 AND NOT (`modules2`>0);');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` ADD `price` float(14,2) DEFAULT 0;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projects` ADD `price` float(14,2) DEFAULT 0;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` ADD `zav_pre` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` ADD `zav` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` ADD `zav_post` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` ADD `cab_w` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` ADD `cab_h` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` ADD `cab_d` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` ADD `zav_date` datetime;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` ADD `overprice` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` ADD `overprice_kind` int DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` ADD `total` float(14,2) DEFAULT 0;');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `zav_pre` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `zav` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `zav_post` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `cab_w` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `cab_h` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `cab_d` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `zav_date` datetime;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `overprice` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `overprice_kind` int DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `total` float(14,2) DEFAULT 0;');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL
      ('ALTER TABLE `uni_projectsystems` ADD `zav_pre` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` ADD `zav` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL
      ('ALTER TABLE `uni_projectsystems` ADD `zav_post` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` ADD `cab_w` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` ADD `cab_h` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` ADD `cab_d` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` ADD `zav_date` datetime;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` ADD `overprice` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` ADD `overprice_kind` int DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` ADD `total` float(14,2) DEFAULT 0;');
  except
  end;
  try
    frmUniversal.DatabaseConnection.ExecSQL
      ('ALTER TABLE `uni_projectsystems` MODIFY `zav_pre` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` MODIFY `zav` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL
      ('ALTER TABLE `uni_projectsystems` MODIFY `zav_post` varchar(10) DEFAULT  NULL;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` MODIFY `cab_w` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` MODIFY `cab_h` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` MODIFY `cab_d` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` MODIFY `zav_date` datetime;');
    frmUniversal.DatabaseConnection.ExecSQL
      ('ALTER TABLE `uni_projectsystems` MODIFY `overprice` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` MODIFY `overprice_kind` int DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` MODIFY `total` float(14,2) DEFAULT 0;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_hardware` ADD `din` int DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projecthardware` ADD `din` int DEFAULT 0;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projecthardware` MODIFY `price` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` MODIFY `price` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projects` MODIFY `price` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systemsdetail` MODIFY `price` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systemsdetail` MODIFY `modules` float(14,2) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_prices` MODIFY `price` float(14,2) DEFAULT 0;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('CREATE INDEX kind_idx ON `uni_hardware` (`kind`);');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('UPDATE `uni_projectsystems` SET `tag`="" WHERE `tag` IS NULL;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` MODIFY `zav_pre` int(11) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` MODIFY `zav` int(11) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_projectsystems` MODIFY `zav_post` int(11) DEFAULT 0;');
  except
  end;

  try
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `zav_pre` int(11) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `zav` int(11) DEFAULT 0;');
    frmUniversal.DatabaseConnection.ExecSQL('ALTER TABLE `uni_systems` MODIFY `zav_post` int(11) DEFAULT 0;');
  except
  end;

end;

procedure TfrmFilesImportExport.checkExport255Click(Sender: TObject);
begin
  GetDBList;
end;

procedure TfrmFilesImportExport.FilePathImportChange(Sender: TObject);
begin
  if Trim(FilePathImport.Text) = '' then
    exit;

  JvSearchFiles1.RootDirectory := FilePathImport.Text;
  JvSearchFiles1.Search;
  btnImport.Caption := ' ' + JvSearchFiles1.TotalFiles.ToString + '   ';
end;

procedure TfrmFilesImportExport.FormActivate(Sender: TObject);
begin
  frmUniversal.DatabaseQuery1.SQL.Text := 'SELECT * FROM `files`';
  GetDBList;
end;

procedure TfrmFilesImportExport.FormCreate(Sender: TObject);
begin
  dblist := TStringList.Create;
  btnImport.Caption := '';
  btnExport.Caption := '';
end;

procedure TfrmFilesImportExport.FormDestroy(Sender: TObject);
begin
  dblist.Free;
end;

procedure TfrmFilesImportExport.GetDBList;
var
  i: integer;
  postfix: string;
begin
  dblist.Clear;
  postfix := '';
  // old table

  if checkExport1.Checked then
    try
      frmUniversal.FilebaseQuery1.SQL.Text := 'SELECT `name` FROM `files`';
      frmUniversal.FilebaseQuery1.active := true;
      while not frmUniversal.FilebaseQuery1.eof do
      begin
        dblist.add(frmUniversal.FilebaseQuery1.FieldByName('name').AsString);
        frmUniversal.FilebaseQuery1.next;
      end;
    except

    end;

  // new tables
  if checkExport255.Checked then
    for i := 0 to 255 do
    begin
      Application.ProcessMessages;
      btnExport.Caption := ' ' + dblist.Count.ToString + '   ';
      try
        postfix := IntToHex(i, 2);
        frmUniversal.FilebaseQuery1.SQL.Text := 'SELECT * FROM `files_' + postfix + '`';
        frmUniversal.FilebaseQuery1.active := true;
        while not frmUniversal.FilebaseQuery1.eof do
        begin
          dblist.add(frmUniversal.FilebaseQuery1.FieldByName('name').AsString);
          frmUniversal.FilebaseQuery1.next;
        end;
      except

      end;
    end;

  // show
  btnExport.Caption := ' ' + dblist.Count.ToString + '   ';
end;

procedure TfrmFilesImportExport.JvSearchFiles1Progress(Sender: TObject);
begin
  Application.ProcessMessages;
end;

end.
