Unit Developers;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, Menus, JvMenus, ActnList, StdCtrls,
  ExtCtrls, Grids, DBGrids, JvExDBGrids, JvDBGrid, ComCtrls, System.Actions,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client;

Type
  TfrmDevelopers = Class(TForm)
    TemplateGrid: TJvDBGrid;
    Panel1: TPanel;
    Label2: TLabel;
    _Search: TEdit;
    MainMenu: TMainMenu;
    mUsers: TMenuItem;
    mUsersAdd: TMenuItem;
    mUsersEdit: TMenuItem;
    mUsersDelete: TMenuItem;
    Actions: TActionList;
    actDevelopersAdd: TAction;
    actDevelopersEdit: TAction;
    actDevelopersDelete: TAction;
    PopupMenu: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    DSDevelopers: TDataSource;
    TDevelopers: TFDQuery;
    StatusBar: TStatusBar;
    Procedure FormActivate(Sender: TObject);
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    Procedure FormShow(Sender: TObject);
    Procedure _SearchChange(Sender: TObject);
    Procedure TemplateGridDblClick(Sender: TObject);
    Procedure actDevelopersEditUpdate(Sender: TObject);
    Procedure actDevelopersDeleteUpdate(Sender: TObject);
    Procedure actDevelopersEditExecute(Sender: TObject);
    Procedure actDevelopersDeleteExecute(Sender: TObject);
    Procedure actDevelopersAddExecute(Sender: TObject);
    procedure actDevelopersAddUpdate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  Private
    Procedure UpdateList;
    { Private declarations }
  Public
    { Public declarations }
  End;

Var
  frmDevelopers: TfrmDevelopers;

Implementation

Uses Main, DeveloperAdd, CustomerDelete, Universal;

{$R *.dfm}

Procedure TfrmDevelopers.actDevelopersAddExecute(Sender: TObject);
Begin
  frmDeveloperAdd.Caption := ' - ';
  frmDeveloperAdd.ClearData;
  If frmDeveloperAdd.ShowModal = mrOk Then
  Begin
    TDevelopers.Append;
    TDevelopers.FieldByName('name').AsString := frmDeveloperAdd.name.Text;
    TDevelopers.FieldByName('kind').AsString := frmDeveloperAdd.kind.Text;
    TDevelopers.FieldByName('user_fio').AsString := frmDeveloperAdd.user_fio.Text;
    TDevelopers.FieldByName('user_job').AsString := frmDeveloperAdd.user_job.Text;
    TDevelopers.FieldByName('email').AsString := frmDeveloperAdd.email.Text;
    TDevelopers.FieldByName('phone_1').AsString := frmDeveloperAdd.phone_1.Text;
    TDevelopers.FieldByName('phone_2').AsString := frmDeveloperAdd.phone_2.Text;
    TDevelopers.FieldByName('address_line_1').AsString := frmDeveloperAdd.address_line_1.Text;
    TDevelopers.FieldByName('address_line_2').AsString := frmDeveloperAdd.address_line_2.Text;
    TDevelopers.FieldByName('comment').AsString := frmDeveloperAdd.comment.Text;
    TDevelopers.Post;
  End;
End;

procedure TfrmDevelopers.actDevelopersAddUpdate(Sender: TObject);
begin
  actDevelopersAdd.Enabled := (frmMain.usergroup.Length > 1);
end;

Procedure TfrmDevelopers.actDevelopersDeleteExecute(Sender: TObject);
Begin
  If frmCustomerDelete.ShowModal = mrOk Then
  Begin
    TDevelopers.Delete;
  End;
End;

Procedure TfrmDevelopers.actDevelopersDeleteUpdate(Sender: TObject);
Begin
  actDevelopersDelete.Enabled := (frmMain.usergroup.Length > 1) and (TDevelopers.RecordCount > 0);
End;

Procedure TfrmDevelopers.actDevelopersEditExecute(Sender: TObject);
Begin
  frmDeveloperAdd.Caption := ' - ';
  frmDeveloperAdd.ClearData;
  frmDeveloperAdd.name.Text := TDevelopers.FieldByName('name').AsString;
  frmDeveloperAdd.kind.Text := TDevelopers.FieldByName('kind').AsString;
  frmDeveloperAdd.user_fio.Text := TDevelopers.FieldByName('user_fio').AsString;
  frmDeveloperAdd.user_job.Text := TDevelopers.FieldByName('user_job').AsString;
  frmDeveloperAdd.email.Text := TDevelopers.FieldByName('email').AsString;
  frmDeveloperAdd.phone_1.Text := TDevelopers.FieldByName('phone_1').AsString;
  frmDeveloperAdd.phone_2.Text := TDevelopers.FieldByName('phone_2').AsString;
  frmDeveloperAdd.address_line_1.Text := TDevelopers.FieldByName('address_line_1').AsString;
  frmDeveloperAdd.address_line_2.Text := TDevelopers.FieldByName('address_line_2').AsString;
  frmDeveloperAdd.comment.Text := TDevelopers.FieldByName('comment').AsString;
  If frmDeveloperAdd.ShowModal = mrOk Then
  Begin
    TDevelopers.Edit;
    TDevelopers.FieldByName('name').AsString := frmDeveloperAdd.name.Text;
    TDevelopers.FieldByName('kind').AsString := frmDeveloperAdd.kind.Text;
    TDevelopers.FieldByName('user_fio').AsString := frmDeveloperAdd.user_fio.Text;
    TDevelopers.FieldByName('user_job').AsString := frmDeveloperAdd.user_job.Text;
    TDevelopers.FieldByName('email').AsString := frmDeveloperAdd.email.Text;
    TDevelopers.FieldByName('phone_1').AsString := frmDeveloperAdd.phone_1.Text;
    TDevelopers.FieldByName('phone_2').AsString := frmDeveloperAdd.phone_2.Text;
    TDevelopers.FieldByName('address_line_1').AsString := frmDeveloperAdd.address_line_1.Text;
    TDevelopers.FieldByName('address_line_2').AsString := frmDeveloperAdd.address_line_2.Text;
    TDevelopers.FieldByName('comment').AsString := frmDeveloperAdd.comment.Text;
    TDevelopers.Post;
  End;
End;

Procedure TfrmDevelopers.actDevelopersEditUpdate(Sender: TObject);
Begin
  actDevelopersEdit.Enabled := (frmMain.usergroup.Length > 1) and (TDevelopers.RecordCount > 0);
End;

Procedure TfrmDevelopers.FormActivate(Sender: TObject);
Begin
  _Search.SetFocus;
End;

Procedure TfrmDevelopers.FormClose(Sender: TObject; Var Action: TCloseAction);
Begin
  Action := caFree;
End;

procedure TfrmDevelopers.FormCreate(Sender: TObject);
begin
  WindowState := frmMain.ws;
end;

Procedure TfrmDevelopers.FormShow(Sender: TObject);
Begin
  if not frmUniversal.DBConnected then
    close;

  Try
    TDevelopers.Active := true;
  Except
    showmessage('   ');
    close;
  End;
End;

Procedure TfrmDevelopers.TemplateGridDblClick(Sender: TObject);
Begin
  actDevelopersEdit.Execute;
End;

Procedure TfrmDevelopers._SearchChange(Sender: TObject);
Begin
  UpdateList;
End;

Procedure TfrmDevelopers.UpdateList;
Var
  filter: String;
Begin

  If _Search.Text <> '' Then
  Begin
    filter := filter + ' WHERE (`name` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `email` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `user_fio` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `phone_1` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `phone_2` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `address_line_1` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `address_line_2` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `comment` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ') ';
  End;

  TDevelopers.SQL.Text := 'SELECT * FROM `uni_developers` ' + filter + ' ORDER BY `name`;';
  TDevelopers.Active := true;
End;

End.
