Unit DescEdit;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, JvExStdCtrls, JvEdit, StdCtrls, Mask, JvExMask, JvToolEdit,
  JvMaskEdit, JvCheckedMaskEdit, JvDatePickerEdit, ExtCtrls, JvButton, JvCtrls,
  JvFooter, JvExExtCtrls, JvExtComponent, JvDialogs;

Type
  TfrmDescEdit = Class(TForm)
    Label3: TLabel;
    JvFooter1: TJvFooter;
    btnCancel: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    description: TComboBox;
    btnFileSelect: TJvFooterBtn;
    OpenDialog: TJvOpenDialog;
    btnClear: TJvFooterBtn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnOkClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnFileSelectClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
  Private
    { Private declarations }
  Public
    { Public declarations }
  End;

Var
  frmDescEdit: TfrmDescEdit;

Implementation

{$R *.dfm}

procedure TfrmDescEdit.btnFileSelectClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    description.Text := OpenDialog.FileName;
  end;
end;

procedure TfrmDescEdit.btnOkClick(Sender: TObject);
begin
  description.Text := trim(description.Text);
  ModalResult := mrOk;
end;

procedure TfrmDescEdit.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  btnFileSelect.Visible := false;
  btnClear.Visible := false;
  description.items.Clear;
end;

procedure TfrmDescEdit.FormShow(Sender: TObject);
begin
  description.SetFocus;
end;

procedure TfrmDescEdit.btnClearClick(Sender: TObject);
begin
  description.Clear;
end;

End.
