Unit Customers;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, Menus, JvMenus, ActnList, ExtCtrls,
  Grids, DBGrids, JvExDBGrids, JvDBGrid, StdCtrls, ComCtrls,
  JvExComCtrls, JvDBTreeView, System.Actions, FireDAC.Stan.Intf,
  FireDAC.Stan.Option, FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS,
  FireDAC.Phys.Intf, FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt,
  FireDAC.Comp.DataSet, FireDAC.Comp.Client;

Type
  TfrmCustomers = Class(TForm)
    MainMenu: TMainMenu;
    mUsers: TMenuItem;
    mUsersAdd: TMenuItem;
    mUsersEdit: TMenuItem;
    mUsersDelete: TMenuItem;
    Actions: TActionList;
    actCustomersAdd: TAction;
    actCustomersEdit: TAction;
    actCustomersDelete: TAction;
    pmList: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    DSCustomers: TDataSource;
    TCustomers: TFDQuery;
    StatusBar: TStatusBar;
    Splitter3: TSplitter;
    Panel2: TPanel;
    CatalogTree: TJvDBTreeView;
    TCustomerTree: TFDQuery;
    DSCustomerTree: TDataSource;
    pmTree: TPopupMenu;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    actTreeAdd: TAction;
    actTreeEdit: TAction;
    actTreeDelete: TAction;
    actTreeAdd2: TAction;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    PanelRight: TPanel;
    PanelCustomers: TPanel;
    Panel4: TPanel;
    DBGridCustomerDetail: TJvDBGrid;
    Splitter1: TSplitter;
    Label1: TLabel;
    TContacts: TFDQuery;
    DSContacts: TDataSource;
    pmContacts: TPopupMenu;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem6: TMenuItem;
    MenuItem7: TMenuItem;
    MenuItem8: TMenuItem;
    MenuItem9: TMenuItem;
    actContactAdd: TAction;
    actContactEdit: TAction;
    actContactDelete: TAction;
    Panel1: TPanel;
    Label2: TLabel;
    _Search: TEdit;
    actCustomerMove: TAction;
    N12: TMenuItem;
    actToProject: TAction;
    N13: TMenuItem;
    N14: TMenuItem;
    TCustomerGroups: TFDQuery;
    DSCustomerGroups: TDataSource;
    Panel5: TPanel;
    Label3: TLabel;
    TemplateGrid: TJvDBGrid;
    actCustomerProjects: TAction;
    N15: TMenuItem;
    actCustomerProjectNew: TAction;
    N10: TMenuItem;
    N11: TMenuItem;
    actCustomerMoveAll: TAction;
    Procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    Procedure FormShow(Sender: TObject);
    Procedure TemplateGridDblClick(Sender: TObject);
    Procedure actCustomersEditUpdate(Sender: TObject);
    Procedure actCustomersDeleteUpdate(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
    Procedure actCustomersAddExecute(Sender: TObject);
    Procedure actCustomersEditExecute(Sender: TObject);
    Procedure actCustomersDeleteExecute(Sender: TObject);
    Procedure _SearchChange(Sender: TObject);
    procedure actTreeAddExecute(Sender: TObject);
    procedure actTreeEditExecute(Sender: TObject);
    procedure actTreeDeleteExecute(Sender: TObject);
    procedure actTreeAdd2Execute(Sender: TObject);
    procedure CatalogTreeChange(Sender: TObject; Node: TTreeNode);
    procedure TCustomersAfterScroll(DataSet: TDataSet);
    procedure actContactAddExecute(Sender: TObject);
    procedure actContactAddUpdate(Sender: TObject);
    procedure actContactEditExecute(Sender: TObject);
    procedure actContactEditUpdate(Sender: TObject);
    procedure DBGridCustomerDetailDblClick(Sender: TObject);
    procedure actCustomerMoveExecute(Sender: TObject);
    procedure actContactDeleteUpdate(Sender: TObject);
    procedure MenuItem7Click(Sender: TObject);
    procedure actCustomerMoveUpdate(Sender: TObject);
    procedure actToProjectExecute(Sender: TObject);
    procedure actToProjectUpdate(Sender: TObject);
    procedure actTreeDeleteUpdate(Sender: TObject);
    procedure actTreeEditUpdate(Sender: TObject);
    procedure actTreeAdd2Update(Sender: TObject);
    procedure actTreeAddUpdate(Sender: TObject);
    procedure actContactDeleteExecute(Sender: TObject);
    procedure actCustomerProjectsExecute(Sender: TObject);
    procedure actCustomerProjectNewExecute(Sender: TObject);
    procedure actCustomerMoveAllUpdate(Sender: TObject);
    procedure actCustomerMoveAllExecute(Sender: TObject);
    procedure N7Click(Sender: TObject);
  Private
    Procedure UpdateList;
    procedure RenewTCustomerDetails;
    procedure RenewTCustomers;
    { Private declarations }
  Public
    fromForm: TForm;
    { Public declarations }
  End;

Var
  frmCustomers: TfrmCustomers;

Implementation

Uses Main, CustomerAdd, CustomerDelete, TemplateAdd, EffectEdit,
  EffectDelete, CustomerContactAdd, CustomerMove, Project, OrderSelect,
  CustomerAdd2, OrderNew, Universal;
{$R *.dfm}

procedure TfrmCustomers.actContactAddExecute(Sender: TObject);
var
  p: integer;
begin
  frmCustomerContactAdd.Caption := '  - ';
  frmCustomerContactAdd.ClearData;
  if TCustomers.Active and TContacts.Active then
    If frmCustomerContactAdd.ShowModal = mrOk Then
    Begin
      p := TCustomers.FieldByName('rec_no').AsInteger;
      TContacts.Append;
      TContacts.FieldByName('parent').AsInteger := p;
      TContacts.FieldByName('name').AsString := frmCustomerContactAdd.name.Text;
      // TContacts.FieldByName('kind').AsString := frmCustomerContactAdd.kind.Text;
      // TContacts.FieldByName('user_fio').AsString := frmCustomerContactAdd.user_fio.Text;
      TContacts.FieldByName('user_job').AsString := frmCustomerContactAdd.user_job.Text;
      TContacts.FieldByName('email').AsString := frmCustomerContactAdd.email.Text;
      TContacts.FieldByName('phone_1').AsString := frmCustomerContactAdd.phone_1.Text;
      TContacts.FieldByName('phone_2').AsString := frmCustomerContactAdd.phone_2.Text;
      TContacts.FieldByName('address_line_1').AsString := frmCustomerContactAdd.address_line_1.Text;
      // TContacts.FieldByName('address_line_2').AsString :=      frmCustomerContactAdd.address_line_2.Text;
      TContacts.FieldByName('comment').AsString := frmCustomerContactAdd.comment.Text;
      TContacts.FieldByName('web').AsString := frmCustomerContactAdd.web.Text;
      TContacts.FieldByName('owner').AsString := frmMain.username;
      TContacts.Post;
    End;
end;

procedure TfrmCustomers.actContactAddUpdate(Sender: TObject);
begin
  actContactAdd.Enabled := (TCustomers.RecNo > 0);
end;

procedure TfrmCustomers.actContactDeleteExecute(Sender: TObject);
begin
  try
    TContacts.Delete;
  except
  end;
end;

procedure TfrmCustomers.actContactDeleteUpdate(Sender: TObject);
begin
  actContactDelete.Enabled := (TCustomers.RecNo > 0) and (TContacts.RecNo > 0) and
    ((frmMain.usergroup.Length > 1) or (TCustomers.FieldByName('owner').AsString = frmMain.username));
end;

procedure TfrmCustomers.actContactEditExecute(Sender: TObject);
begin
  frmCustomerContactAdd.Caption := '  - ';
  frmCustomerContactAdd.ClearData;
  frmCustomerContactAdd.name.Text := TContacts.FieldByName('name').AsString;
  frmCustomerContactAdd.user_job.Text := TContacts.FieldByName('user_job').AsString;
  frmCustomerContactAdd.email.Text := TContacts.FieldByName('email').AsString;
  frmCustomerContactAdd.phone_1.Text := TContacts.FieldByName('phone_1').AsString;
  frmCustomerContactAdd.phone_2.Text := TContacts.FieldByName('phone_2').AsString;
  frmCustomerContactAdd.address_line_1.Text := TContacts.FieldByName('address_line_1').AsString;
  frmCustomerContactAdd.comment.Text := TContacts.FieldByName('comment').AsString;
  frmCustomerContactAdd.web.Text := TContacts.FieldByName('web').AsString;
  if (TCustomers.RecNo > 0) and (TContacts.RecNo > 0) then
    If frmCustomerContactAdd.ShowModal = mrOk Then
    Begin
      TContacts.Edit;
      TContacts.FieldByName('name').AsString := frmCustomerContactAdd.name.Text;
      TContacts.FieldByName('user_job').AsString := frmCustomerContactAdd.user_job.Text;
      TContacts.FieldByName('email').AsString := frmCustomerContactAdd.email.Text;
      TContacts.FieldByName('phone_1').AsString := frmCustomerContactAdd.phone_1.Text;
      TContacts.FieldByName('phone_2').AsString := frmCustomerContactAdd.phone_2.Text;
      TContacts.FieldByName('address_line_1').AsString := frmCustomerContactAdd.address_line_1.Text;
      TContacts.FieldByName('web').AsString := frmCustomerContactAdd.web.Text;
      TContacts.FieldByName('comment').AsString := frmCustomerContactAdd.comment.Text;
      TContacts.FieldByName('owner').AsString := frmMain.username;
      TContacts.Post;
    End;
end;

procedure TfrmCustomers.actContactEditUpdate(Sender: TObject);
begin
  actContactEdit.Enabled := (TCustomers.RecNo > 0) and (TContacts.RecNo > 0) and
    ((frmMain.usergroup.Length > 1) or (TContacts.FieldByName('owner').AsString = frmMain.username));
end;

procedure TfrmCustomers.actCustomerMoveAllExecute(Sender: TObject);
Var
  i: integer;
Begin
  // 
  If frmCustomerMove.ShowModal = mrOk Then
    Try
      TCustomers.DisableControls;
      If frmCustomerMove.dir > 0 Then
      Begin
        If TemplateGrid.SelectedRows.Count > 0 Then
        Begin
          With TemplateGrid.DataSource.DataSet Do
            For i := 0 To TemplateGrid.SelectedRows.Count - 1 Do
            Begin
              GotoBookmark(TBookmark(pointer(TemplateGrid.SelectedRows.Items[i])));
              Edit;
              FieldByName('parent').AsInteger := frmCustomerMove.dir;
              Post;
            End;
        End
        Else
        Begin
          If TCustomers.RecNo > 0 Then
            Try
              TCustomers.Edit;
              TCustomers.FieldByName('parent').AsInteger := frmCustomerMove.dir;
              TCustomers.Post;
            Except
            End;
        End;
      End;
      TCustomers.Refresh;
      TCustomers.First;
    Except
    End;
  TCustomers.EnableControls;
  TemplateGrid.SelectedRows.Clear;
end;

procedure TfrmCustomers.actCustomerMoveAllUpdate(Sender: TObject);
begin
  actCustomerMoveAll.Enabled := (TCustomers.RecordCount > 0) and
    ((frmMain.usergroup.Length > 1) or (TCustomers.FieldByName('owner').AsString = frmMain.username));
end;

procedure TfrmCustomers.actCustomerMoveExecute(Sender: TObject);
Var
  i: integer;
Begin
  // 
  If frmCustomerMove.ShowModal = mrOk Then
    Try
      TCustomers.DisableControls;
      If frmCustomerMove.dir > 0 Then
      Begin
        If TemplateGrid.SelectedRows.Count > 0 Then
        Begin
          With TemplateGrid.DataSource.DataSet Do
            For i := 0 To TemplateGrid.SelectedRows.Count - 1 Do
            Begin
              GotoBookmark(TBookmark(pointer(TemplateGrid.SelectedRows.Items[i])));
              Edit;
              FieldByName('parent').AsInteger := frmCustomerMove.dir;
              Post;
            End;
        End
        Else
        Begin
          If TCustomers.RecNo > 0 Then
            Try
              TCustomers.Edit;
              TCustomers.FieldByName('parent').AsInteger := frmCustomerMove.dir;
              TCustomers.Post;
            Except
            End;
        End;
      End;
      TCustomers.Refresh;
      TCustomers.First;
    Except
    End;
  TCustomers.EnableControls;
  TemplateGrid.SelectedRows.Clear;
end;

procedure TfrmCustomers.actCustomerMoveUpdate(Sender: TObject);
begin
  actCustomerMove.Enabled := (TCustomers.RecordCount > 0) and
    ((frmMain.usergroup.Length > 1) or (TCustomers.FieldByName('owner').AsString = frmMain.username));
end;

procedure TfrmCustomers.actCustomerProjectNewExecute(Sender: TObject);
var
  NewCaption: string;
begin
  //    
  frmOrderNew.CopyFrom := -1;
  frmOrderNew._customers.Text := TCustomers.FieldByName('name').AsString;
  If frmOrderNew.ShowModal = mrOk Then
  Begin
    NewCaption := ' ' + frmOrderNew._name.Text + ' / ' + frmOrderNew._customers.Text;
    If Not frmMain.MDIExists(NewCaption) Then
      With TfrmProject.Create(Application) Do
      Begin
        Project_no := frmOrderNew.Project_no;
        Project_name := frmOrderNew._name.Text;
        Project_customer := frmOrderNew._customers.Text;
        Project_manager := frmOrderNew._managers.Text;
        Project_datestart := frmOrderNew.Project_datestart;
        Project_dateend := frmOrderNew.Project_dateend;
        Project_customer := frmOrderNew._customers.Text;
        FormActivate(self);
      End;
  End;
end;

procedure TfrmCustomers.actCustomerProjectsExecute(Sender: TObject);
var
  NewCaption, cn: string;
begin
  //   
  try
    cn := TCustomers.FieldByName('name').AsString;
    NewCaption := '';
    if cn <> '' then
      If Not frmMain.MDIExists(NewCaption) Then
        With TfrmOrderSelect.Create(Application) Do
        begin
          Caption := NewCaption;
          _customers.Text := cn;
        end;
  except
  end;
end;

Procedure TfrmCustomers.actCustomersAddExecute(Sender: TObject);
var
  p: integer;
  nn: string;
Begin
  frmCustomerAdd2.name.Text := '';
  if frmCustomerAdd2.ShowModal = mrOk then
  begin
    nn := frmCustomerAdd2.name.Text;
    if (nn <> '') then
    begin
      TCustomers.Append;
      TCustomers.FieldByName('name').AsString := frmCustomerAdd2.name.Text;
      TCustomers.FieldByName('name_uri').AsString := frmCustomerAdd2.name.Text;
      TCustomers.FieldByName('parent').AsInteger := TCustomerTree.FieldByName('rec_no').AsInteger;
      TCustomers.FieldByName('owner').AsString := frmMain.username;
      TCustomers.Post;
      RenewTCustomers;
    end;
  end;
End;

Procedure TfrmCustomers.actCustomersDeleteExecute(Sender: TObject);
Begin
  If frmCustomerDelete.ShowModal = mrOk Then
  Begin
    TCustomers.Delete;
    RenewTCustomers;
  End;
End;

Procedure TfrmCustomers.actCustomersDeleteUpdate(Sender: TObject);
Begin
  actCustomersDelete.Enabled := (TCustomers.RecordCount > 0) and
    ((frmMain.usergroup.Length > 1) or (TCustomers.FieldByName('owner').AsString = frmMain.username));
End;

Procedure TfrmCustomers.actCustomersEditExecute(Sender: TObject);
Begin
  frmCustomerAdd.common_rec_no := TCustomers.FieldByName('rec_no').AsInteger;
  frmCustomerAdd.common_tree_no := TCustomers.FieldByName('parent').AsInteger;
  frmCustomerAdd.ShowModal;
  RenewTCustomers;
End;

Procedure TfrmCustomers.actCustomersEditUpdate(Sender: TObject);
Begin
  actCustomersEdit.Enabled := (TCustomers.RecordCount > 0) and
    ((frmMain.usergroup.Length > 1) or (TCustomers.FieldByName('owner').AsString = frmMain.username));
End;

procedure TfrmCustomers.actTreeAdd2Execute(Sender: TObject);
Var
  Description: String;
  parent_no: integer;
Begin
  If TCustomerTree.RecNo > 0 Then
    parent_no := TCustomerTree.FieldByName('rec_no').AsInteger
  Else
    parent_no := 0;
  If parent_no < 0 Then
    parent_no := 0;
  If frmTemplateAdd.ShowModal = mrOk Then
  Begin
    Description := frmTemplateAdd.Description.Text;
    TCustomerTree.Append;
    TCustomerTree.FieldByName('name').AsString := Description;
    TCustomerTree.FieldByName('parent').AsInteger := parent_no;
    TCustomerTree.Post;
    TCustomerTree.Refresh;
  End;
end;

procedure TfrmCustomers.actTreeAdd2Update(Sender: TObject);
begin
  actTreeAdd2.Enabled := (TCustomerTree.Active) and (frmMain.usergroup.Length > 1);
end;

procedure TfrmCustomers.actTreeAddExecute(Sender: TObject);
Var
  Description: String;
  parent_no: integer;
Begin
  If TCustomerTree.RecNo > 0 Then
    parent_no := TCustomerTree.FieldByName('parent').AsInteger
  Else
    parent_no := 0;
  If parent_no < 0 Then
    parent_no := 0;
  If frmTemplateAdd.ShowModal = mrOk Then
  Begin
    Description := frmTemplateAdd.Description.Text;
    TCustomerTree.Append;
    TCustomerTree.FieldByName('name').AsString := Description;
    TCustomerTree.FieldByName('parent').AsInteger := parent_no;
    TCustomerTree.Post;
    TCustomerTree.Refresh;
  End;
end;

procedure TfrmCustomers.actTreeAddUpdate(Sender: TObject);
begin
  actTreeAdd.Enabled := (TCustomerTree.Active) and (frmMain.usergroup.Length > 1);
end;

procedure TfrmCustomers.actTreeDeleteExecute(Sender: TObject);
begin
  If frmEffectDelete.ShowModal = mrOk Then
  Begin
    CatalogTree.DeleteNode(CatalogTree.Selected);
  End;
end;

procedure TfrmCustomers.actTreeDeleteUpdate(Sender: TObject);
begin
  actTreeDelete.Enabled := (TCustomerTree.RecNo > 0) and (frmMain.usergroup.Length > 1);
end;

procedure TfrmCustomers.actTreeEditExecute(Sender: TObject);
begin
  frmEffectEdit.Description.Text := TCustomerTree.FieldByName('name').AsString;
  If frmEffectEdit.ShowModal = mrOk Then
  Begin
    TCustomerTree.Edit;
    TCustomerTree.FieldByName('name').AsString := frmEffectEdit.Description.Text;
    TCustomerTree.Post;
  End;
end;

procedure TfrmCustomers.actTreeEditUpdate(Sender: TObject);
begin
  actTreeEdit.Enabled := (TCustomerTree.RecNo > 0) and (frmMain.usergroup.Length > 1);
end;

procedure TfrmCustomers.CatalogTreeChange(Sender: TObject; Node: TTreeNode);
Begin
  RenewTCustomers;
end;

procedure TfrmCustomers.RenewTCustomers;
Var
  rec_no: integer;
  pos_no: integer;
  filter: string;
Begin
  rec_no := TCustomerTree.FieldByName('rec_no').AsInteger;
  try
    pos_no := TCustomers.FieldByName('rec_no').AsInteger;
    TCustomers.DisableControls;
  except
  end;

  If _Search.Text <> '' Then
  Begin
    filter := filter + ' WHERE (`name` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `email` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `user_fio` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `phone_1` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `phone_2` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `address_line_1` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `address_line_2` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ' OR `comment` LIKE ' + QuotedStr('%' + _Search.Text + '%');
    filter := filter + ') ';
    TCustomers.SQL.Text := 'SELECT * FROM `uni_customers` ' + filter + ' ORDER BY `name`;';
    TCustomers.Active := true;
  End
  else
  begin
    TCustomers.SQL.Text := 'SELECT * FROM `uni_customers` WHERE `parent`=' + inttostr(rec_no) +
      ' AND (`parentcustomer`<1 OR `parentcustomer` is null) ORDER BY `name`;';
    TCustomers.Active := true;
  end;
  ShowScrollBar(TemplateGrid.Handle, SB_VERT, true);

  if TCustomers.Active and (TCustomers.RecordCount > 0) then
    try
      TCustomers.Locate('rec_no', pos_no, []);
      TemplateGrid.SelectedRows.Clear;
    except
    end;
  TCustomers.EnableControls;

  if TCustomers.Active then
    StatusBar.Panels[0].Text := ': ' + inttostr(TCustomers.RecordCount)
  else
    StatusBar.Panels[0].Text := '';

  RenewTCustomerDetails;
end;

procedure TfrmCustomers.DBGridCustomerDetailDblClick(Sender: TObject);
begin
  actContactEdit.Execute;
end;

Procedure TfrmCustomers.FormActivate(Sender: TObject);
Begin
  _Search.SetFocus;
  RenewTCustomers;
End;

Procedure TfrmCustomers.FormClose(Sender: TObject; Var Action: TCloseAction);
Begin
  Action := caFree;
End;

Procedure TfrmCustomers.FormShow(Sender: TObject);
Begin
  if not frmUniversal.DBConnected then
    close;

  Try
    TCustomers.Active := true;
    TCustomerTree.Active := true;
  Except
    showmessage('   ');
    close;
  End;
End;

procedure TfrmCustomers.MenuItem7Click(Sender: TObject);
begin
  if frmCustomerDelete.ShowModal = mrOk then
    TContacts.Delete;
end;

procedure TfrmCustomers.N7Click(Sender: TObject);
begin
  RenewTCustomers;
end;

procedure TfrmCustomers.TCustomersAfterScroll(DataSet: TDataSet);
begin
  RenewTCustomerDetails;
end;

procedure TfrmCustomers.RenewTCustomerDetails;
var
  rn: integer;
begin
  rn := -1;
  if TCustomers.Active and (TCustomers.RecNo > 0) then
  begin
    rn := TCustomers.FieldByName('rec_no').AsInteger;
    ShowScrollBar(TemplateGrid.Handle, SB_VERT, true);
  end;
  if rn > 0 then
  begin
    TContacts.SQL.Text := 'SELECT * FROM `uni_customerdetail` WHERE `parent`=' + inttostr(rn) + ' ORDER BY `name`;';
    TContacts.Active := true;
    DBGridCustomerDetail.Enabled := true;
  end
  else
  begin
    TContacts.Active := false;
    DBGridCustomerDetail.Enabled := false;
  end;
end;

Procedure TfrmCustomers.TemplateGridDblClick(Sender: TObject);
Begin
  actToProject.Update;
  if actToProject.Enabled then
  begin
    actToProject.Execute;
    close;
  end
  else
  begin
    actCustomersEdit.Execute;
  end;
End;

Procedure TfrmCustomers._SearchChange(Sender: TObject);
Begin
  UpdateList;
End;

Procedure TfrmCustomers.UpdateList;
Begin
  RenewTCustomers;
End;

procedure TfrmCustomers.actToProjectExecute(Sender: TObject);
var
  customer_name: string;
begin
  //   
  if (fromForm <> nil) and (TCustomers.RecNo > 0) then
  begin
    if (fromForm is TfrmProject) then
    begin
      customer_name := TCustomers.FieldByName('name').AsString;
      // (fromForm as TfrmProject).setupCustomer(customer_name);
    end;
    if (fromForm is TfrmOrderSelect) then
    begin
      customer_name := TCustomers.FieldByName('name').AsString;
      // (fromForm as TfrmOrderSelect).setupCustomer(customer_name);
    end;
  end;
end;

procedure TfrmCustomers.actToProjectUpdate(Sender: TObject);
begin
  if (fromForm <> nil) and (TCustomers.RecNo > 0) then
  begin
    if (fromForm is TfrmProject) and ((fromForm as TfrmProject).Project_name <> '') then
    begin
      actToProject.Enabled := true;
      actToProject.Caption := '   [' + (fromForm as TfrmProject).Project_name + ']';
    end
    else if (fromForm is TfrmOrderSelect) then
    begin
      actToProject.Enabled := true;
      actToProject.Caption := '   ';
    end
    else
    begin
      actToProject.Caption := '  ';
      actToProject.Enabled := false;
    end;
  end
  else
  begin
    actToProject.Enabled := false;
    actToProject.Caption := '  ';
  end;
end;

End.
