unit CustomerMove;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Data.DB,
  Vcl.StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, Vcl.ExtCtrls,
  JvExExtCtrls, JvExtComponent, Vcl.ComCtrls, JvExComCtrls, JvDBTreeView,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client;

type
  TfrmCustomerMove = class(TForm)
    CatalogTree: TJvDBTreeView;
    JvFooter1: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    TCustomerTree: TFDQuery;
    DSCustomerTree: TDataSource;
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
  private
    { Private declarations }
  public
    dir: integer;
    { Public declarations }
  end;

var
  frmCustomerMove: TfrmCustomerMove;

implementation

{$R *.dfm}

uses  Main, Universal;

procedure TfrmCustomerMove.btnOkClick(Sender: TObject);
begin
  dir := TCustomerTree.FieldByName('rec_no').AsInteger;
  TCustomerTree.Active := false;
  Modalresult := mrOk;
end;

procedure TfrmCustomerMove.FormActivate(Sender: TObject);
begin
  btnOk.SetFocus;
end;

procedure TfrmCustomerMove.FormShow(Sender: TObject);
begin
  if not frmUniversal.DBConnected then
    close;
  try
    TCustomerTree.Active := true;
  Except
  End;
  dir := -1;
end;

end.
