Unit CustomerAdd;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, JvExStdCtrls, JvButton, JvCtrls, JvFooter, ExtCtrls,
  JvExExtCtrls, JvExtComponent, Data.DB, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet,
  FireDAC.Comp.Client;

Type
  TfrmCustomerAdd = Class(TForm)
    Footer: TJvFooter;
    JvFooterBtn1: TJvFooterBtn;
    btnOk: TJvFooterBtn;
    TCustomers: TFDQuery;
    PanelTop: TPanel;
    Label1: TLabel;
    name: TEdit;
    name_uri: TComboBox;
    Label16: TLabel;
    PanelBottom: TPanel;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label2: TLabel;
    Label11: TLabel;
    Label5: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label17: TLabel;
    email: TEdit;
    user_fio: TEdit;
    phone_1: TEdit;
    phone_2: TEdit;
    address_line_1: TEdit;
    address_line_2: TEdit;
    user_job: TEdit;
    Comment: TMemo;
    bank: TMemo;
    inn: TEdit;
    kpp: TEdit;
    web: TEdit;
    Kind: TComboBox;
    btnDelete: TButton;
    btnAdd: TButton;
    btnEdit: TButton;
    Procedure btnOkClick(Sender: TObject);
    Procedure FormActivate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
  Private
    procedure GetCommon;
    procedure SaveCurrent;
    { Private declarations }
  Public
    common_rec_no, common_tree_no: integer;
    Procedure ClearData;
    { Public declarations }
  End;

Var
  frmCustomerAdd: TfrmCustomerAdd;

Implementation

{$R *.dfm}

uses  DescEdit, Main, Universal;

procedure TfrmCustomerAdd.btnEditClick(Sender: TObject);
var
  ii: integer;
begin
  ii := name_uri.ItemIndex;
  if ii > -1 then
  begin
    frmDescEdit.Description.Text := name_uri.Items[ii];
    if frmDescEdit.ShowModal = mrOk then
    begin
      name_uri.Items[ii] := frmDescEdit.Description.Text;
      name_uri.ItemIndex := ii;
      SaveCurrent;
    end;
  end;
end;

Procedure TfrmCustomerAdd.btnOkClick(Sender: TObject);
Begin
  SaveCurrent;
  If length(Name.Text) > 0 Then
    ModalResult := mrOk;
End;

Procedure TfrmCustomerAdd.ClearData;
Begin
  Name.Text := '';
  Kind.Text := '';
  user_fio.Text := '';
  user_job.Text := '';
  email.Text := '';
  phone_1.Text := '';
  phone_2.Text := '';
  address_line_1.Text := '';
  address_line_2.Text := '';
  Comment.Text := '';
  web.Text := '';
  inn.Text := '';
  kpp.Text := '';
  bank.Text := '';
End;

Procedure TfrmCustomerAdd.FormActivate(Sender: TObject);
Begin
  Name.SetFocus;
  GetCommon;
End;

procedure TfrmCustomerAdd.FormShow(Sender: TObject);
begin
  if not frmUniversal.DBConnected then
    close;
end;

procedure TfrmCustomerAdd.GetCommon;
begin
  TCustomers.SQL.Text := 'SELECT * FROM `uni_customers` WHERE rec_no=' +
    IntToStr(common_rec_no) + ';';
  TCustomers.Active := true;
  ClearData;
  name.Text := TCustomers.FieldByName('name').AsString;
  name_uri.Clear;
  name_uri.Items.Add(TCustomers.FieldByName('name_uri').AsString);
  name_uri.ItemIndex := 0;
  Kind.Text := TCustomers.FieldByName('kind').AsString;
  user_fio.Text := TCustomers.FieldByName('user_fio').AsString;
  user_job.Text := TCustomers.FieldByName('user_job').AsString;
  email.Text := TCustomers.FieldByName('email').AsString;
  phone_1.Text := TCustomers.FieldByName('phone_1').AsString;
  phone_2.Text := TCustomers.FieldByName('phone_2').AsString;
  address_line_1.Text := TCustomers.FieldByName('address_line_1').AsString;
  address_line_2.Text := TCustomers.FieldByName('address_line_2').AsString;
  Comment.Text := TCustomers.FieldByName('comment').AsString;
  web.Text := TCustomers.FieldByName('web').AsString;
  inn.Text := TCustomers.FieldByName('inn').AsString;
  kpp.Text := TCustomers.FieldByName('kpp').AsString;
  bank.Text := TCustomers.FieldByName('bank').AsString;

end;

Procedure TfrmCustomerAdd.SaveCurrent;
Begin
  TCustomers.Edit;
  TCustomers.FieldByName('name').AsString := frmCustomerAdd.name.Text;
  TCustomers.FieldByName('name_uri').AsString := frmCustomerAdd.name_uri.Text;
  TCustomers.FieldByName('kind').AsString := frmCustomerAdd.Kind.Text;
  TCustomers.FieldByName('user_fio').AsString := frmCustomerAdd.user_fio.Text;
  TCustomers.FieldByName('user_job').AsString := frmCustomerAdd.user_job.Text;
  TCustomers.FieldByName('email').AsString := frmCustomerAdd.email.Text;
  TCustomers.FieldByName('phone_1').AsString := frmCustomerAdd.phone_1.Text;
  TCustomers.FieldByName('phone_2').AsString := frmCustomerAdd.phone_2.Text;
  TCustomers.FieldByName('address_line_1').AsString :=
    frmCustomerAdd.address_line_1.Text;
  TCustomers.FieldByName('address_line_2').AsString :=
    frmCustomerAdd.address_line_2.Text;
  TCustomers.FieldByName('comment').AsString := frmCustomerAdd.Comment.Text;
  TCustomers.FieldByName('web').AsString := frmCustomerAdd.web.Text;
  TCustomers.FieldByName('inn').AsString := frmCustomerAdd.inn.Text;
  TCustomers.FieldByName('kpp').AsString := frmCustomerAdd.kpp.Text;
  TCustomers.FieldByName('bank').AsString := frmCustomerAdd.bank.Text;
  TCustomers.FieldByName('owner').AsString := frmMain.username;
  TCustomers.Post;
End;

End.
