unit CopySystem;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, JvExStdCtrls, JvButton,
  JvCtrls, JvFooter, Vcl.ExtCtrls, JvExExtCtrls, JvExtComponent,
  Vcl.Samples.Spin, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, Data.DB, FireDAC.Comp.DataSet,
  FireDAC.Comp.Client;

type
  TfrmCopySystem = class(TForm)
    Label3: TLabel;
    JvFooter1: TJvFooter;
    btnOk: TJvFooterBtn;
    btnCancel: TJvFooterBtn;
    description: TComboBox;
    Label1: TLabel;
    Multiply: TSpinEdit;
    QuerySRC: TFDQuery;
    QueryDST: TFDQuery;
    procedure btnOkClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    procedure CopyHardware(Multiply: Integer);
    { Private declarations }
  public
    tableSRC, tableDST: string;
    systemnoSRC, systemnoDST: Integer;
    { Public declarations }
  end;

var
  frmCopySystem: TfrmCopySystem;

implementation

{$R *.dfm}

uses Main;

procedure TfrmCopySystem.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  description.items.Clear;
end;

procedure TfrmCopySystem.FormCreate(Sender: TObject);
begin
  tableSRC := 'uni_systems';
  tableDST := 'uni_systems';
end;

procedure TfrmCopySystem.FormShow(Sender: TObject);
begin
  //    
  try
    description.items.Clear;

    QuerySRC.SQL.Text := 'SELECT `name` FROM `uni_projectsystems` WHERE `project_no`=:project_no';
    QuerySRC.ParamByName('project_no').AsInteger := frmMain.current_projectno;
    QuerySRC.Active := true;
    while not QuerySRC.eof do
    begin
      frmCopySystem.description.items.add(QuerySRC.FieldByName('name').AsString);
      QuerySRC.Next;
    end;
  finally

  end;
  //
  description.Text := '';
  if tableSRC <> tableDST then
    description.Text := frmMain.current_projectsystemname;

end;

Procedure TfrmCopySystem.CopyHardware(Multiply: Integer);
Var
  // SQL, flds, pars: String;
  orderby: Integer;
Begin
  //   
  QuerySRC.SQL.Text := 'SELECT MAX(`orderby`) FROM uni_projecthardware WHERE `project_no`=' +
    IntToStr(frmMain.current_projectno) + ' AND `system_no`=' + IntToStr(frmMain.current_projectsystemno) + ';';
  QuerySRC.Active := true;
  orderby := 0;
  if QuerySRC.RecordCount > 0 then
    orderby := QuerySRC.Fields[0].AsInteger;
  //
  if tableSRC = 'uni_systems' then
  begin
    QuerySRC.SQL.Text :=
      'SELECT name,kinddesc,article,comment,developer,file,price,valuta,count,modules FROM `uni_systemsdetail` WHERE `system_no`='
      + IntToStr(frmMain.current_systemno) + ' ORDER BY `rec_no`;';
  end
  else
  begin
    QuerySRC.SQL.Text :=
      'SELECT name,kinddesc,article,comment,developer,file,price,valuta,count,modules FROM `uni_projecthardware` WHERE `system_no`='
      + IntToStr(systemnoSRC) + ' ORDER BY `rec_no`;';
  end;
  QuerySRC.Active := true;
  if QuerySRC.RecordCount > 0 then
    try
      QueryDST.Connection.StartTransaction;
      while not QuerySRC.eof do
      begin
        inc(orderby);
        QueryDST.SQL.Text :=
          'INSERT INTO uni_projecthardware (orderby,project_no,system_no,name,kinddesc,article,comment,developer,file,price,valuta,count,modules)'
          + ' VALUES (:orderby,:project_no,:system_no,:name,:kinddesc,:article,:comment,:developer,:file,:price,:valuta,:count,:modules);';
        QueryDST.ParamByName('orderby').AsInteger := orderby;
        QueryDST.ParamByName('project_no').AsInteger := frmMain.current_projectno;
        QueryDST.ParamByName('system_no').AsInteger := systemnoDST;
        QueryDST.ParamByName('name').AsString := QuerySRC.FieldByName('name').AsString;
        QueryDST.ParamByName('kinddesc').AsString := QuerySRC.FieldByName('kinddesc').AsString;
        QueryDST.ParamByName('article').AsString := QuerySRC.FieldByName('article').AsString;
        QueryDST.ParamByName('developer').AsString := QuerySRC.FieldByName('developer').AsString;
        QueryDST.ParamByName('comment').AsString := QuerySRC.FieldByName('comment').AsString;
        QueryDST.ParamByName('file').AsString := QuerySRC.FieldByName('file').AsString;
        QueryDST.ParamByName('price').AsString := QuerySRC.FieldByName('price').AsString;
        QueryDST.ParamByName('valuta').AsString := QuerySRC.FieldByName('valuta').AsString;
        QueryDST.ParamByName('count').AsInteger := QuerySRC.FieldByName('count').AsInteger * Multiply;
        QueryDST.ParamByName('modules').AsString := QuerySRC.FieldByName('modules').AsString;
        QueryDST.ExecSQL;

        QuerySRC.Next;
      end;
      QueryDST.Connection.Commit;
    except
    end;
End;

procedure TfrmCopySystem.btnOkClick(Sender: TObject);
var
  systemname, s: string;
  r: Integer;
begin
  description.Text := trim(description.Text);
  if length(description.Text) < 1 then
    exit;

  //    
  systemname := description.Text;

  //       ,  ,   
  QuerySRC.SQL.Text := 'SELECT `rec_no` FROM `'+tableDST+'` WHERE `project_no`=:project_no AND `name`=:name';
  QuerySRC.ParamByName('project_no').AsInteger := frmMain.current_projectno;
  QuerySRC.ParamByName('name').AsString := systemname;
  QuerySRC.Active := true;
  if QuerySRC.RecordCount = 0 then
    try
      //    , 
      QuerySRC.SQL.Text := 'SELECT * FROM `'+tableSRC+'` WHERE `rec_no`=:system_no';
      QuerySRC.ParamByName('system_no').AsInteger := systemnoSRC;
      QuerySRC.Active := true;

      QueryDST.SQL.Text :=
        'INSERT INTO `uni_projectsystems` (project_no,name,construction,kind,voltage,current,protection,entries,voltage_secondary,tag,'
        + 'overprice,zav_date,zav_pre,zav,zav_post,cab_w,cab_h,cab_d,active)' +
        ' VALUES (:project_no,:name,:construction,:kind,:voltage,:current,:protection,:entries,:voltage_secondary,:tag,'
        + ':overprice,:zav_date,:zav_pre,:zav,:zav_post,:cab_w,:cab_h,:cab_d,1)';
      QueryDST.ParamByName('project_no').AsInteger := frmMain.current_projectno;
      QueryDST.ParamByName('name').AsString := systemname;
      QueryDST.ParamByName('construction').AsString := QuerySRC.FieldByName('construction').AsString;
      QueryDST.ParamByName('kind').AsString := QuerySRC.FieldByName('kind').AsString;
      QueryDST.ParamByName('voltage').AsString := QuerySRC.FieldByName('voltage').AsString;
      QueryDST.ParamByName('current').AsString := QuerySRC.FieldByName('current').AsString;
      QueryDST.ParamByName('protection').AsString := QuerySRC.FieldByName('protection').AsString;
      QueryDST.ParamByName('entries').AsString := QuerySRC.FieldByName('entries').AsString;
      QueryDST.ParamByName('voltage_secondary').AsString := QuerySRC.FieldByName('voltage_secondary').AsString;
      QueryDST.ParamByName('tag').AsString := QuerySRC.FieldByName('tag').AsString;
      QueryDST.ParamByName('overprice').AsInteger := QuerySRC.FieldByName('overprice').AsInteger;
      QueryDST.ParamByName('zav_date').AsDateTime := QuerySRC.FieldByName('zav_date').AsDateTime;
      QueryDST.ParamByName('zav_pre').AsString := QuerySRC.FieldByName('zav_pre').AsString;
      QueryDST.ParamByName('zav').AsString := QuerySRC.FieldByName('zav').AsString;
      QueryDST.ParamByName('zav_post').AsString := QuerySRC.FieldByName('zav_post').AsString;
      QueryDST.ParamByName('cab_w').AsString := QuerySRC.FieldByName('cab_w').AsString;
      QueryDST.ParamByName('cab_h').AsString := QuerySRC.FieldByName('cab_h').AsString;
      QueryDST.ParamByName('cab_d').AsString := QuerySRC.FieldByName('cab_d').AsString;

      QueryDST.ExecSQL;
    except
      ShowMessage('   ');
    end;

  QuerySRC.SQL.Text := 'SELECT `rec_no` FROM `uni_projectsystems` WHERE `project_no`=:project_no AND `name`=:name';
  QuerySRC.ParamByName('project_no').AsInteger := frmMain.current_projectno;
  QuerySRC.ParamByName('name').AsString := systemname;
  QuerySRC.Active := true;
  if QuerySRC.RecordCount > 0 then
  begin
    //    
    systemnoSRC := frmMain.current_projectsystemno;
    systemnoDST := QuerySRC.FieldByName('rec_no').AsInteger;
    //   
    CopyHardware(frmCopySystem.Multiply.Value);
    frmMain.current_projectsystemno := systemnoDST;
  end;

  frmMain.Log(1, 'uni_projectsystems', frmMain.current_projectname, '', trim(systemname));

  ModalResult := mrOk;
end;

end.
